/*
 * Copyright 2012-2017 Aerospike, Inc.
 *
 * Portions may be licensed to Aerospike, Inc. under one or more contributor
 * license agreements WHICH ARE COMPATIBLE WITH THE APACHE LICENSE, VERSION 2.0.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package org.springframework.data.aerospike.repository.query;

import org.springframework.data.aerospike.query.qualifier.IQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;

/**
 * @author Michael Zhang
 * @author Jeff Boone
 * @deprecated Since 4.6.0. Use {@link Qualifier}
 */
@Deprecated(since = "4.6.0", forRemoval = true)
public class AerospikeCriteria extends Qualifier implements CriteriaDefinition {

    public AerospikeCriteria(IQualifierBuilder builder) {
        super(builder);
    }

    public AerospikeCriteria(Qualifier qualifier) {
        super(qualifier);
    }

    @Override
    public Qualifier getCriteriaObject() {
        return this;
    }

    @Override
    public String getCriteriaField() {
        return this.getField();
    }
}
