/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

import com.aerospike.client.IAerospikeClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.aerospike.config.AerospikeDataConfigurationSupport;
import org.springframework.data.aerospike.config.AerospikeSettings;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.index.AerospikePersistenceEntityIndexCreator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.StatementBuilder;
import org.springframework.data.aerospike.query.cache.IndexInfoParser;
import org.springframework.data.aerospike.query.cache.IndexRefresher;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.cache.InternalIndexOperations;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;

@Configuration
public abstract class AbstractAerospikeDataConfiguration
extends AerospikeDataConfigurationSupport {
    private static final Logger log = LoggerFactory.getLogger(AbstractAerospikeDataConfiguration.class);

    @Bean(name={"aerospikeTemplate"})
    public AerospikeTemplate aerospikeTemplate(IAerospikeClient aerospikeClient, MappingAerospikeConverter mappingAerospikeConverter, AerospikeMappingContext aerospikeMappingContext, AerospikeExceptionTranslator aerospikeExceptionTranslator, QueryEngine queryEngine, IndexRefresher indexRefresher, ServerVersionSupport serverVersionSupport, AerospikeSettings settings) {
        return new AerospikeTemplate(aerospikeClient, settings.getConnectionSettings().getNamespace(), mappingAerospikeConverter, aerospikeMappingContext, aerospikeExceptionTranslator, queryEngine, indexRefresher, serverVersionSupport);
    }

    @Bean(name={"aerospikeQueryEngine"})
    public QueryEngine queryEngine(IAerospikeClient aerospikeClient, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder, AerospikeSettings settings) {
        QueryEngine queryEngine = new QueryEngine(aerospikeClient, statementBuilder, filterExpressionsBuilder);
        boolean scansEnabled = settings.getDataSettings().isScansEnabled();
        log.debug("AerospikeDataSettings.scansEnabled: {}", (Object)scansEnabled);
        queryEngine.setScansEnabled(scansEnabled);
        long queryMaxRecords = settings.getDataSettings().getQueryMaxRecords();
        log.debug("AerospikeDataSettings.queryMaxRecords: {}", (Object)queryMaxRecords);
        queryEngine.setQueryMaxRecords(queryMaxRecords);
        return queryEngine;
    }

    @Bean
    public AerospikePersistenceEntityIndexCreator aerospikePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> aerospikeMappingContext, AerospikeIndexResolver aerospikeIndexResolver, ObjectProvider<AerospikeTemplate> template, AerospikeSettings settings) {
        boolean indexesOnStartup = settings.getDataSettings().isCreateIndexesOnStartup();
        log.debug("AerospikeDataSettings.indexesOnStartup: {}", (Object)indexesOnStartup);
        return new AerospikePersistenceEntityIndexCreator(aerospikeMappingContext, indexesOnStartup, aerospikeIndexResolver, template);
    }

    @Bean(name={"aerospikeIndexRefresher"})
    public IndexRefresher indexRefresher(IAerospikeClient aerospikeClient, IndexesCacheUpdater indexesCacheUpdater, ServerVersionSupport serverVersionSupport, AerospikeSettings settings) {
        IndexRefresher refresher = new IndexRefresher(aerospikeClient, aerospikeClient.getInfoPolicyDefault(), new InternalIndexOperations(new IndexInfoParser()), indexesCacheUpdater, serverVersionSupport);
        refresher.refreshIndexes();
        int refreshFrequency = settings.getDataSettings().getIndexCacheRefreshSeconds();
        this.processCacheRefreshFrequency(refreshFrequency, refresher);
        log.debug("AerospikeDataSettings.indexCacheRefreshSeconds: {}", (Object)refreshFrequency);
        return refresher;
    }

    private void processCacheRefreshFrequency(int indexCacheRefreshSeconds, IndexRefresher indexRefresher) {
        if (indexCacheRefreshSeconds <= 0) {
            log.info("Periodic index cache refreshing is not scheduled, interval ({}) is <= 0", (Object)indexCacheRefreshSeconds);
        } else {
            indexRefresher.scheduleRefreshIndexes(indexCacheRefreshSeconds);
        }
    }
}

