/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchResults;
import com.aerospike.client.Bin;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.ResultSet;
import com.aerospike.client.query.Statement;
import com.aerospike.client.task.IndexTask;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.CoreUtils;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.index.IndexesCacheRefresher;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.query.KeyRecordIterator;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.cache.IndexRefresher;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.data.util.StreamUtils;
import org.springframework.util.Assert;

public class AerospikeTemplate
extends BaseAerospikeTemplate
implements AerospikeOperations,
IndexesCacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(AerospikeTemplate.class);
    private static final Pattern INDEX_EXISTS_REGEX_PATTERN = Pattern.compile("^FAIL:(-?\\d+).*$");
    private final IAerospikeClient client;
    private final QueryEngine queryEngine;
    private final IndexRefresher indexRefresher;

    public AerospikeTemplate(IAerospikeClient client, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, QueryEngine queryEngine, IndexRefresher indexRefresher, ServerVersionSupport serverVersionSupport) {
        super(namespace, converter, mappingContext, exceptionTranslator, client.getWritePolicyDefault(), serverVersionSupport);
        this.client = client;
        this.queryEngine = queryEngine;
        this.indexRefresher = indexRefresher;
    }

    @Override
    public IAerospikeClient getAerospikeClient() {
        return this.client;
    }

    @Override
    public long getQueryMaxRecords() {
        return this.queryEngine.getQueryMaxRecords();
    }

    @Override
    public void refreshIndexesCache() {
        this.indexRefresher.refreshIndexes();
    }

    @Override
    public <T> void save(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.save(document, this.getSetName((Object)document));
    }

    @Override
    public <T> void save(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationCasAwarePolicy(data);
            this.doPersistWithVersionAndHandleCasError(document, data, policy, true, BaseAerospikeTemplate.OperationType.SAVE_OPERATION);
        } else {
            WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void saveAll(Iterable<T> documents) {
        this.validateForBatchWrite(documents, "Documents for saving");
        this.saveAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> void saveAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for saving");
        this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.SAVE_OPERATION);
    }

    private <T> void applyBufferedBatchWrite(Iterable<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType) {
        int batchSize = this.converter.getAerospikeSettings().getBatchWriteSize();
        ArrayList<T> docsList = new ArrayList<T>();
        for (T doc : documents) {
            if (this.batchWriteSizeMatch(batchSize, docsList.size())) {
                this.batchWriteAllDocuments(docsList, setName, operationType);
                docsList.clear();
            }
            docsList.add(doc);
        }
        if (!docsList.isEmpty()) {
            this.batchWriteAllDocuments(docsList, setName, operationType);
        }
    }

    private <T> void batchWriteAllDocuments(List<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType) {
        ArrayList batchWriteDataList = new ArrayList();
        switch (operationType) {
            case SAVE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForSave(document, setName)));
                break;
            }
            case INSERT_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForInsert(document, setName)));
                break;
            }
            case UPDATE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForUpdate(document, setName)));
                break;
            }
            case DELETE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForDelete(document, setName)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected operation name: " + String.valueOf((Object)operationType));
            }
        }
        List<BatchRecord> batchWriteRecords = batchWriteDataList.stream().map(BaseAerospikeTemplate.BatchWriteData::batchRecord).toList();
        try {
            this.client.operate(null, batchWriteRecords);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
        this.checkForErrorsAndUpdateVersion(batchWriteDataList, batchWriteRecords, operationType);
    }

    protected <T> void checkForErrorsAndUpdateVersion(List<BaseAerospikeTemplate.BatchWriteData<T>> batchWriteDataList, List<BatchRecord> batchWriteRecords, BaseAerospikeTemplate.OperationType operationType) {
        boolean errorsFound = false;
        String casErrorDocumentId = null;
        for (BaseAerospikeTemplate.BatchWriteData<T> data : batchWriteDataList) {
            if (!errorsFound && this.batchRecordFailed(data.batchRecord())) {
                errorsFound = true;
            }
            if (!data.hasVersionProperty()) continue;
            if (!this.batchRecordFailed(data.batchRecord())) {
                if (operationType == BaseAerospikeTemplate.OperationType.DELETE_OPERATION) continue;
                this.updateVersion(data.document(), data.batchRecord().record);
                continue;
            }
            if (!this.hasOptimisticLockingError(data.batchRecord().resultCode)) continue;
            casErrorDocumentId = data.batchRecord().key.userKey.toString();
        }
        if (errorsFound) {
            if (casErrorDocumentId != null) {
                throw this.getOptimisticLockingFailureException("Failed to %s the record with ID '%s' due to versions mismatch".formatted(new Object[]{operationType, casErrorDocumentId}), null);
            }
            AerospikeException e = new AerospikeException("Errors during batch " + String.valueOf((Object)operationType));
            throw new AerospikeException.BatchRecordArray((BatchRecord[])batchWriteRecords.toArray(BatchRecord[]::new), (Throwable)e);
        }
    }

    @Override
    public <T> void insert(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.insert(document, this.getSetName((Object)document));
    }

    @Override
    public <T> void insert(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.CREATE_ONLY);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            this.doPersistWithVersionAndHandleError(document, data, policy);
        } else {
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void insertAll(Iterable<? extends T> documents) {
        this.validateForBatchWrite(documents, "Documents for insert");
        this.insertAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> void insertAll(Iterable<? extends T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for insert");
        this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.INSERT_OPERATION);
    }

    @Override
    public <T> void persist(T document, WritePolicy policy) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        this.persist(document, policy, this.getSetName((Object)document));
    }

    @Override
    public <T> void persist(T document, WritePolicy policy, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        this.doPersistAndHandleError(data, policy, operations);
    }

    @Override
    public <T> void update(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.update(document, this.getSetName((Object)document));
    }

    @Override
    public <T> void update(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            this.doPersistWithVersionAndHandleCasError(document, data, policy, true, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
        } else {
            WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = (Operation[])Stream.concat(Stream.of(Operation.delete()), data.getBins().stream().map(Operation::put)).toArray(Operation[]::new);
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void update(T document, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        this.update(document, this.getSetName((Object)document), fields);
    }

    @Override
    public <T> void update(T document, String setName, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeDataWithSpecificFields(document, setName, fields);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            this.doPersistWithVersionAndHandleCasError(document, data, policy, false, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
        } else {
            WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
            this.doPersistAndHandleError(data, policy, operations);
        }
    }

    @Override
    public <T> void updateAll(Iterable<T> documents) {
        this.validateForBatchWrite(documents, "Documents for update");
        this.updateAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> void updateAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for update");
        this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
    }

    @Override
    @Deprecated(since="4.6.0", forRemoval=true)
    public <T> void delete(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.delete(this.getSetName((Class)entityClass));
    }

    @Override
    @Deprecated(since="4.6.0", forRemoval=true)
    public <T> boolean delete(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull((Object)id, (String)"Id must not be null!");
        try {
            Key key = this.getKey(id, this.getSetName((Class)entityClass));
            return this.client.delete(this.ignoreGenerationPolicy(), key);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean delete(T document) {
        Assert.notNull(document, (String)"Document must not be null!");
        return this.delete(document, this.getSetName((Object)document));
    }

    @Override
    public <T> boolean delete(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            return this.doDeleteWithVersionAndHandleCasError(data);
        }
        return this.doDeleteIgnoreVersionAndTranslateError(data);
    }

    private boolean doDeleteWithVersionAndHandleCasError(AerospikeWriteData data) {
        try {
            return this.client.delete(this.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY), data.getKey());
        }
        catch (AerospikeException e) {
            throw this.translateCasError(e, "Failed to delete record due to versions mismatch");
        }
    }

    private boolean doDeleteIgnoreVersionAndTranslateError(AerospikeWriteData data) {
        try {
            return this.client.delete(this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY), data.getKey());
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean deleteById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteById(id, this.getSetName((Class)entityClass));
    }

    @Override
    public boolean deleteById(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            Key key = this.getKey(id, setName);
            return this.client.delete(this.ignoreGenerationPolicy(), key);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> void deleteAll(Iterable<T> documents) {
        String setName = this.getSetName((Object)documents.iterator().next());
        int batchSize = this.converter.getAerospikeSettings().getBatchWriteSize();
        ArrayList<T> documentsList = new ArrayList<T>();
        for (T document : documents) {
            if (this.batchWriteSizeMatch(batchSize, documentsList.size())) {
                this.deleteAll(documentsList, setName);
                documentsList.clear();
            }
            documentsList.add(document);
        }
        if (!documentsList.isEmpty()) {
            this.deleteAll(documentsList, setName);
        }
    }

    @Override
    public <T> void deleteAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for deleting");
        this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.DELETE_OPERATION);
    }

    @Override
    public <T> void deleteByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    public void deleteByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(ids, "IDs");
        int batchSize = this.converter.getAerospikeSettings().getBatchWriteSize();
        ArrayList idsList = new ArrayList();
        for (Object id : ids) {
            if (this.batchWriteSizeMatch(batchSize, idsList.size())) {
                this.deleteByIds(idsList, setName);
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            this.deleteByIds(idsList, setName);
        }
    }

    private void deleteByIds(Collection<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(ids, "IDs");
        if (ids.isEmpty()) {
            return;
        }
        Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, setName)).toArray(Key[]::new);
        this.deleteAndHandleErrors(this.client, keys);
    }

    @Override
    public void deleteByIds(GroupedKeys groupedKeys) {
        this.validateGroupedKeys(groupedKeys);
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return;
        }
        this.deleteGroupedEntitiesByGroupedKeys(groupedKeys);
    }

    private void deleteGroupedEntitiesByGroupedKeys(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        this.deleteAndHandleErrors(this.client, entitiesKeys.getKeys());
    }

    @Override
    public <T> void deleteAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteAll(entityClass, null);
    }

    @Override
    public <T> void deleteAll(Class<T> entityClass, Instant beforeLastUpdate) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteAll(this.getSetName((Class)entityClass), beforeLastUpdate);
    }

    @Override
    public void deleteAll(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.deleteAll(setName, null);
    }

    @Override
    public void deleteAll(String setName, Instant beforeLastUpdate) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Calendar beforeLastUpdateCalendar = this.convertToCalendar(beforeLastUpdate);
        try {
            this.client.truncate(null, this.getNamespace(), setName, beforeLastUpdateCalendar);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private void deleteAndHandleErrors(IAerospikeClient client, Key[] keys) {
        BatchResults results;
        try {
            results = client.delete(null, null, keys);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
        if (results.records == null) {
            throw new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete"));
        }
        for (int i = 0; i < results.records.length; ++i) {
            BatchRecord record = results.records[i];
            if (!this.batchRecordFailed(record)) continue;
            throw new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete"));
        }
    }

    @Override
    public <T> T add(T document, Map<String, Long> values) {
        return this.add(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> T add(T document, String setName, Map<String, Long> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document, setName);
            Operation[] ops = CoreUtils.operations(values, Operation.Type.ADD, Operation.get());
            WritePolicy writePolicy = WritePolicyBuilder.builder(this.client.getWritePolicyDefault()).expiration(data.getExpiration()).build();
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T add(T document, String binName, long value) {
        return this.add(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> T add(T document, String setName, String binName, long value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document, setName);
            WritePolicy writePolicy = WritePolicyBuilder.builder(this.client.getWritePolicyDefault()).expiration(data.getExpiration()).build();
            Record aeroRecord = this.client.operate(writePolicy, data.getKey(), new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get()});
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T append(T document, Map<String, String> values) {
        return this.append(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> T append(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document, setName);
            Operation[] ops = CoreUtils.operations(values, Operation.Type.APPEND, Operation.get());
            Record aeroRecord = this.client.operate(null, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T append(T document, String binName, String value) {
        return this.append(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> T append(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document, setName);
            Record aeroRecord = this.client.operate(null, data.getKey(), new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)});
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T prepend(T document, String fieldName, String value) {
        return this.prepend(document, this.getSetName((Object)document), fieldName, value);
    }

    @Override
    public <T> T prepend(T document, String setName, String fieldName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)fieldName, (String)"Field name must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document, setName);
            Record aeroRecord = this.client.operate(null, data.getKey(), new Operation[]{Operation.prepend((Bin)new Bin(fieldName, value)), Operation.get((String)fieldName)});
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T prepend(T document, Map<String, String> values) {
        return this.prepend(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> T prepend(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        try {
            AerospikeWriteData data = this.writeData(document, setName);
            Operation[] ops = CoreUtils.operations(values, Operation.Type.PREPEND, Operation.get());
            Record aeroRecord = this.client.operate(null, data.getKey(), ops);
            return this.mapToEntity(data.getKey(), this.getEntityClass(document), aeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        try {
            return supplier.get();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findById(id, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> T findById(Object id, Class<T> entityClass, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return (T)this.findById(id, entityClass, null, setName);
    }

    @Override
    public <T, S> S findById(Object id, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findById(id, entityClass, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> S findById(Object id, Class<T> entityClass, Class<S> targetClass, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return (S)this.findByIdUsingQuery(id, entityClass, targetClass, setName, null);
    }

    private Record getRecord(AerospikePersistentEntity<?> entity, Key key, Query query) {
        Record aeroRecord;
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
            aeroRecord = this.getAndTouch(key, entity.getExpiration(), null, null);
        } else {
            Policy policy = this.getPolicyFilterExp(query);
            aeroRecord = this.getAerospikeClient().get(policy, key);
        }
        return aeroRecord;
    }

    private BatchPolicy getBatchPolicyFilterExp(Query query) {
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            BatchPolicy policy = new BatchPolicy(this.getAerospikeClient().getBatchPolicyDefault());
            policy.filterExp = this.queryEngine.getFilterExpressionsBuilder().build(query);
            return policy;
        }
        return null;
    }

    private Key[] getKeys(Collection<?> ids, String setName) {
        return (Key[])ids.stream().map(id -> this.getKey(id, setName)).toArray(Key[]::new);
    }

    private <S> Object getRecordMapToTargetClass(AerospikePersistentEntity<?> entity, Key key, Class<S> targetClass, Query query) {
        Record aeroRecord;
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for expiration property");
            aeroRecord = this.getAndTouch(key, entity.getExpiration(), binNames, query);
        } else {
            Policy policy = this.getPolicyFilterExp(query);
            aeroRecord = this.getAerospikeClient().get(policy, key, binNames);
        }
        return this.mapToEntity(key, targetClass, aeroRecord);
    }

    private String[] getBinNamesFromTargetClass(Class<?> targetClass) {
        AerospikePersistentEntity targetEntity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(targetClass);
        ArrayList binNamesList = new ArrayList();
        targetEntity.doWithProperties(property -> binNamesList.add(property.getFieldName()));
        return binNamesList.toArray(new String[0]);
    }

    private Policy getPolicyFilterExp(Query query) {
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            Policy policy = new Policy(this.getAerospikeClient().getReadPolicyDefault());
            policy.filterExp = this.queryEngine.getFilterExpressionsBuilder().build(query);
            return policy;
        }
        return null;
    }

    private Record getAndTouch(Key key, int expiration, String[] binNames, Query query) {
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.client.getWritePolicyDefault()).expiration(expiration);
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            writePolicyBuilder.filterExp(this.queryEngine.getFilterExpressionsBuilder().build(query));
        }
        WritePolicy writePolicy = writePolicyBuilder.build();
        try {
            if (binNames == null || binNames.length == 0) {
                return this.client.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
            }
            Operation[] operations = new Operation[binNames.length + 1];
            operations[0] = Operation.touch();
            for (int i = 1; i < operations.length; ++i) {
                operations[i] = Operation.get((String)binNames[i - 1]);
            }
            return this.client.operate(writePolicy, key, operations);
        }
        catch (AerospikeException aerospikeException) {
            if (aerospikeException.getResultCode() == 2) {
                return null;
            }
            throw aerospikeException;
        }
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        return this.findByIds(ids, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> List<T> findByIds(Iterable<?> ids, Class<T> entityClass, String setName) {
        return this.findByIds(ids, entityClass, null, setName);
    }

    @Override
    public <T, S> List<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass) {
        return this.findByIds(ids, entityClass, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> List<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass, String setName) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        int batchSize = this.converter.getAerospikeSettings().getBatchWriteSize();
        ArrayList idsList = new ArrayList();
        List result = new ArrayList();
        for (Object id : ids) {
            if (this.batchWriteSizeMatch(batchSize, idsList.size())) {
                result = Stream.concat(result.stream(), this.findByIdsUsingQuery(idsList, entityClass, targetClass, setName, null).stream()).toList();
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            result = Stream.concat(result.stream(), this.findByIdsUsingQuery(idsList, entityClass, targetClass, setName, null).stream()).toList();
        }
        return result;
    }

    @Override
    public GroupedEntities findByIds(GroupedKeys groupedKeys) {
        this.validateGroupedKeys(groupedKeys);
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return GroupedEntities.builder().build();
        }
        return this.findGroupedEntitiesByGroupedKeys(groupedKeys);
    }

    private GroupedEntities findGroupedEntitiesByGroupedKeys(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        Record[] aeroRecords = this.client.get(null, entitiesKeys.getKeys());
        return this.toGroupedEntities(entitiesKeys, aeroRecords);
    }

    @Override
    public <T, S> Object findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, Query query) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIdUsingQuery(id, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Object findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, String setName, Query query) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
            Key key = this.getKey(id, setName);
            if (targetClass != null && targetClass != entityClass) {
                return this.getRecordMapToTargetClass(entity, key, targetClass, query);
            }
            return this.mapToEntity(key, entityClass, this.getRecord(entity, key, query));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T, S> List<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, Query query) {
        return this.findByIdsUsingQuery(ids, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> List<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, String setName, Query query) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Class<Object> target;
            Record[] aeroRecords;
            Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, setName)).toArray(Key[]::new);
            BatchPolicy policy = this.getBatchPolicyFilterExp(query);
            if (targetClass != null && targetClass != entityClass) {
                String[] binNames = this.getBinNamesFromTargetClass(targetClass);
                aeroRecords = this.getAerospikeClient().get(policy, keys, binNames);
                target = targetClass;
            } else {
                aeroRecords = this.getAerospikeClient().get(policy, keys);
                target = entityClass;
            }
            return IntStream.range(0, keys.length).filter(index -> aeroRecords[index] != null).mapToObj(index -> this.mapToEntity(keys[index], target, aeroRecords[index])).collect(Collectors.toList());
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> entityClass) {
        return this.find(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> find(Query query, Class<T> entityClass, Class<S> targetClass) {
        return this.find(query, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> find(Query query, Class<T> targetClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, query);
    }

    private <T> Stream<T> find(Class<T> targetClass, String setName) {
        return this.findRecordsUsingQuery(setName, targetClass, null).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, targetClass));
    }

    @Override
    public <T> Stream<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.findAll(entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> findAll(Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> findAll(Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.find(targetClass, setName);
    }

    @Override
    public <T> Stream<T> findAll(Sort sort, long offset, long limit, Class<T> entityClass) {
        return this.findAll(sort, offset, limit, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> findAll(Sort sort, long offset, long limit, Class<T> entityClass, Class<S> targetClass) {
        return this.findAll(sort, offset, limit, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> findAll(Sort sort, long offset, long limit, Class<T> targetClass, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findWithPostProcessing(setName, targetClass, sort, offset, limit);
    }

    private <T> Stream<T> findWithPostProcessing(String setName, Class<T> targetClass, Query query) {
        CoreUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        Stream<T> results = this.findUsingQueryWithDistinctPredicate(setName, targetClass, CoreUtils.getDistinctPredicate(query), query);
        return this.applyPostProcessingOnResults(results, query);
    }

    @Override
    public <T, S> Stream<S> findUsingQueryWithoutPostProcessing(Class<T> entityClass, Class<S> targetClass, Query query) {
        CoreUtils.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        return this.findUsingQueryWithDistinctPredicate(this.getSetName((Class)entityClass), targetClass, CoreUtils.getDistinctPredicate(query), query);
    }

    private <T> Stream<T> findUsingQueryWithDistinctPredicate(String setName, Class<T> targetClass, Predicate<KeyRecord> distinctPredicate, Query query) {
        return this.findRecordsUsingQuery(setName, targetClass, query).filter(distinctPredicate).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, targetClass));
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        return this.findInRange(offset, limit, sort, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Stream<S> findInRange(long offset, long limit, Sort sort, Class<T> entityClass, Class<S> targetClass) {
        return this.findInRange(offset, limit, sort, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Stream<T> findInRange(long offset, long limit, Sort sort, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, sort, offset, limit);
    }

    @Override
    public <T> boolean exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(id, this.getSetName((Class)entityClass));
    }

    @Override
    public boolean exists(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            Key key = this.getKey(id, setName);
            Record aeroRecord = this.client.operate(null, key, new Operation[]{Operation.getHeader()});
            return aeroRecord != null;
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> boolean existsByQuery(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.existsByQuery(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> boolean existsByQuery(Query query, Class<T> entityClass, String setName) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.find(query, entityClass, setName).findAny().isPresent();
    }

    @Override
    public <T> long count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.count(this.getSetName((Class)entityClass));
    }

    @Override
    public long count(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            Node[] nodes = this.client.getNodes();
            int replicationFactor = Utils.getReplicationFactor(nodes, this.namespace);
            long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(node, this.namespace, setName)).sum();
            return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> long count(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.count(query, this.getSetName((Class)entityClass));
    }

    @Override
    public long count(Query query, String setName) {
        Stream<KeyRecord> results = this.countRecordsUsingQuery(setName, query);
        return results.count();
    }

    private Stream<KeyRecord> countRecordsUsingQuery(String setName, Query query) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = QualifierUtils.getIdQualifier(qualifier)) != null) {
            return this.findByIdsWithoutMapping(TemplateUtils.getIdValue(idQualifier), setName, null, new Query(TemplateUtils.excludeIdQualifier(qualifier))).stream();
        }
        KeyRecordIterator recIterator = this.queryEngine.selectForCount(this.namespace, setName, query);
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    @Override
    public <T> ResultSet aggregate(Filter filter, Class<T> entityClass, String module, String function, List<Value> arguments) {
        return this.aggregate(filter, this.getSetName((Class)entityClass), module, function, arguments);
    }

    @Override
    public ResultSet aggregate(Filter filter, String setName, String module, String function, List<Value> arguments) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Statement statement = new Statement();
        if (filter != null) {
            statement.setFilter(filter);
        }
        statement.setSetName(setName);
        statement.setNamespace(this.namespace);
        ResultSet resultSet = arguments != null && !arguments.isEmpty() ? this.client.queryAggregate(null, statement, module, function, arguments.toArray(new Value[0])) : this.client.queryAggregate(null, statement);
        return resultSet;
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.createIndex(entityClass, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public <T> void createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.createIndex(this.getSetName((Class)entityClass), indexName, binName, indexType, indexCollectionType, ctx);
    }

    @Override
    public void createIndex(String setName, String indexName, String binName, IndexType indexType) {
        this.createIndex(setName, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public void createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        this.createIndex(setName, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public void createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull((Object)setName, (String)"Set name type must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        Assert.notNull((Object)ctx, (String)"Ctx must not be null!");
        try {
            IndexTask task = this.client.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType, ctx);
            if (task != null) {
                task.waitTillComplete();
            }
            this.refreshIndexesCache();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> void deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.deleteIndex(this.getSetName((Class)entityClass), indexName);
    }

    @Override
    public void deleteIndex(String setName, String indexName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            IndexTask task = this.client.dropIndex(null, this.namespace, setName, indexName);
            if (task != null) {
                task.waitTillComplete();
            }
            this.refreshIndexesCache();
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public boolean indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            Node[] nodes;
            for (Node node : nodes = this.client.getNodes()) {
                String response = Info.request((Node)node, (String)("sindex-exists:ns=" + this.namespace + ";indexname=" + indexName));
                if (response == null) {
                    throw new AerospikeException("Null node response");
                }
                if (response.equalsIgnoreCase("true")) {
                    return true;
                }
                if (response.equalsIgnoreCase("false")) {
                    return false;
                }
                Matcher matcher = INDEX_EXISTS_REGEX_PATTERN.matcher(response);
                if (matcher.matches()) {
                    int reason;
                    try {
                        reason = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        throw new AerospikeException("Unexpected node response, unable to parse ResultCode: " + response);
                    }
                    if (reason == 20) continue;
                    throw new AerospikeException(reason);
                }
                throw new AerospikeException("Unexpected node response: " + response);
            }
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
        return false;
    }

    private Record doPersistAndHandleError(AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        try {
            return this.client.operate(policy, data.getKey(), operations);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private <T> void doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy policy, boolean firstlyDeleteBins, BaseAerospikeTemplate.OperationType operationType) {
        try {
            Record newAeroRecord = this.putAndGetHeader(data, policy, firstlyDeleteBins);
            this.updateVersion(document, newAeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateCasError(e, "Failed to " + operationType.toString() + " record due to versions mismatch");
        }
    }

    private <T> void doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy policy) {
        try {
            Record newAeroRecord = this.putAndGetHeader(data, policy, false);
            this.updateVersion(document, newAeroRecord);
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private Record putAndGetHeader(AerospikeWriteData data, WritePolicy policy, boolean firstlyDeleteBins) {
        Key key = data.getKey();
        Operation[] operations = this.getPutAndGetHeaderOperations(data, firstlyDeleteBins);
        return this.client.operate(policy, key, operations);
    }

    private <T> Stream<T> findWithPostProcessing(String setName, Class<T> targetClass, Sort sort, long offset, long limit) {
        CoreUtils.verifyUnsortedWithOffset(sort, offset);
        Stream<T> results = this.find(targetClass, setName);
        return this.applyPostProcessingOnResults(results, sort, offset, limit);
    }

    private <T> Stream<T> applyPostProcessingOnResults(Stream<T> results, Query query) {
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = this.getComparator(query);
            results = results.sorted(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.limit(query.getRows());
        }
        return results;
    }

    private <T> Stream<T> applyPostProcessingOnResults(Stream<T> results, Sort sort, long offset, long limit) {
        if (sort != null && sort.isSorted()) {
            Comparator comparator = this.getComparator(sort);
            results = results.sorted(comparator);
        }
        if (offset > 0L) {
            results = results.skip(offset);
        }
        if (limit > 0L) {
            results = results.limit(limit);
        }
        return results;
    }

    private <T> Stream<KeyRecord> findRecordsUsingQuery(String setName, Class<T> targetClass, Query query) {
        KeyRecordIterator recIterator;
        Qualifier idQualifier;
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = QualifierUtils.getIdQualifier(qualifier)) != null) {
            return this.findByIdsWithoutMapping(TemplateUtils.getIdValue(idQualifier), setName, targetClass, new Query(TemplateUtils.excludeIdQualifier(qualifier))).stream();
        }
        if (targetClass != null) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            recIterator = this.queryEngine.select(this.namespace, setName, binNames, query);
        } else {
            recIterator = this.queryEngine.select(this.namespace, setName, query);
        }
        return (Stream)StreamUtils.createStreamFromIterator((Iterator)recIterator).onClose(() -> {
            try {
                recIterator.close();
            }
            catch (Exception e) {
                log.error("Caught exception while closing query", (Throwable)e);
            }
        });
    }

    private List<KeyRecord> findByIdsWithoutMapping(Collection<?> ids, String setName, Class<?> targetClass, Query query) {
        Assert.notNull(ids, (String)"Ids must not be null");
        if (ids.isEmpty()) {
            return Collections.emptyList();
        }
        try {
            Record[] aeroRecords;
            Key[] keys = this.getKeys(ids, setName);
            BatchPolicy policy = this.getBatchPolicyFilterExp(query);
            if (targetClass != null) {
                String[] binNames = this.getBinNamesFromTargetClass(targetClass);
                aeroRecords = this.getAerospikeClient().get(policy, keys, binNames);
            } else {
                aeroRecords = this.getAerospikeClient().get(policy, keys);
            }
            return IntStream.range(0, keys.length).filter(index -> aeroRecords[index] != null).mapToObj(index -> new KeyRecord(keys[index], aeroRecords[index])).collect(Collectors.toList());
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }
}

