/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchResults;
import com.aerospike.client.Bin;
import com.aerospike.client.Info;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.InfoPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.CoreUtils;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.index.IndexesCacheRefresher;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.ReactorQueryEngine;
import org.springframework.data.aerospike.query.cache.ReactorIndexRefresher;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.data.keyvalue.core.IterableConverter;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikeTemplate
extends BaseAerospikeTemplate
implements ReactiveAerospikeOperations,
IndexesCacheRefresher {
    private static final Logger log = LoggerFactory.getLogger(ReactiveAerospikeTemplate.class);
    private static final Pattern INDEX_EXISTS_REGEX_PATTERN = Pattern.compile("^FAIL:(-?\\d+).*$");
    private final IAerospikeReactorClient reactorClient;
    private final ReactorQueryEngine reactorQueryEngine;
    private final ReactorIndexRefresher reactorIndexRefresher;

    public ReactiveAerospikeTemplate(IAerospikeReactorClient reactorClient, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, ReactorQueryEngine queryEngine, ReactorIndexRefresher reactorIndexRefresher, ServerVersionSupport serverVersionSupport) {
        super(namespace, converter, mappingContext, exceptionTranslator, reactorClient.getWritePolicyDefault(), serverVersionSupport);
        Assert.notNull((Object)reactorClient, (String)"Aerospike reactor client must not be null!");
        this.reactorClient = reactorClient;
        this.reactorQueryEngine = queryEngine;
        this.reactorIndexRefresher = reactorIndexRefresher;
    }

    @Override
    public void refreshIndexesCache() {
        this.reactorIndexRefresher.refreshIndexes();
    }

    @Override
    public <T> Mono<T> save(T document) {
        Assert.notNull(document, (String)"Document for saving must not be null!");
        return this.save(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> save(T document, String setName) {
        Assert.notNull(document, (String)"Document for saving must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationCasAwarePolicy(data);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, policy, operations, BaseAerospikeTemplate.OperationType.SAVE_OPERATION);
        }
        WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> documents) {
        this.validateForBatchWrite(documents, "Documents for saving");
        return this.saveAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for saving");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.SAVE_OPERATION);
    }

    private <T> Flux<T> applyBufferedBatchWrite(Iterable<? extends T> documents, String setName, BaseAerospikeTemplate.OperationType operationType) {
        int batchSize = this.converter.getAerospikeSettings().getBatchWriteSize();
        ArrayList<T> docsList = new ArrayList<T>();
        Flux result = Flux.empty();
        for (T doc : documents) {
            if (this.batchWriteSizeMatch(batchSize, docsList.size())) {
                result = Flux.concat((Publisher[])new Publisher[]{result, this.batchWriteAllDocuments(docsList, setName, operationType)});
                docsList.clear();
            }
            docsList.add(doc);
        }
        if (!docsList.isEmpty()) {
            result = Flux.concat((Publisher[])new Publisher[]{result, this.batchWriteAllDocuments(docsList, setName, operationType)});
        }
        return result;
    }

    private <T> Flux<T> batchWriteAllDocuments(List<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType) {
        ArrayList batchWriteDataList = new ArrayList();
        switch (operationType) {
            case SAVE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForSave(document, setName)));
                break;
            }
            case INSERT_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForInsert(document, setName)));
                break;
            }
            case UPDATE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForUpdate(document, setName)));
                break;
            }
            case DELETE_OPERATION: {
                documents.forEach(document -> batchWriteDataList.add(this.getBatchWriteForDelete(document, setName)));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected operation name: " + String.valueOf((Object)operationType));
            }
        }
        List<BatchRecord> batchWriteRecords = batchWriteDataList.stream().map(BaseAerospikeTemplate.BatchWriteData::batchRecord).toList();
        return this.batchWriteAndCheckForErrors(batchWriteRecords, batchWriteDataList, operationType);
    }

    private <T> Flux<T> batchWriteAndCheckForErrors(List<BatchRecord> batchWriteRecords, List<BaseAerospikeTemplate.BatchWriteData<T>> batchWriteDataList, BaseAerospikeTemplate.OperationType operationType) {
        return this.reactorClient.operate(null, batchWriteRecords).onErrorMap(this::translateError).flatMap(ignore -> this.checkForErrorsAndUpdateVersion(batchWriteDataList, batchWriteRecords, operationType)).flux().flatMapIterable(list -> list.stream().map(BaseAerospikeTemplate.BatchWriteData::document).toList());
    }

    private <T> Mono<List<BaseAerospikeTemplate.BatchWriteData<T>>> checkForErrorsAndUpdateVersion(List<BaseAerospikeTemplate.BatchWriteData<T>> batchWriteDataList, List<BatchRecord> batchWriteRecords, BaseAerospikeTemplate.OperationType operationType) {
        boolean errorsFound = false;
        String casErrorDocumentId = null;
        for (BaseAerospikeTemplate.BatchWriteData<T> data : batchWriteDataList) {
            if (!errorsFound && this.batchRecordFailed(data.batchRecord())) {
                errorsFound = true;
            }
            if (!data.hasVersionProperty()) continue;
            if (!this.batchRecordFailed(data.batchRecord())) {
                if (operationType == BaseAerospikeTemplate.OperationType.DELETE_OPERATION) continue;
                this.updateVersion(data.document(), data.batchRecord().record);
                continue;
            }
            if (!this.hasOptimisticLockingError(data.batchRecord().resultCode)) continue;
            casErrorDocumentId = data.batchRecord().key.userKey.toString();
        }
        if (errorsFound) {
            if (casErrorDocumentId != null) {
                return Mono.error((Throwable)this.getOptimisticLockingFailureException("Failed to %s the record with ID '%s' due to versions mismatch".formatted(new Object[]{operationType, casErrorDocumentId}), null));
            }
            AerospikeException e = new AerospikeException("Errors during batch " + String.valueOf((Object)operationType));
            return Mono.error((Throwable)new AerospikeException.BatchRecordArray((BatchRecord[])batchWriteRecords.toArray(BatchRecord[]::new), (Throwable)e));
        }
        return Mono.just(batchWriteDataList);
    }

    @Override
    public <T> Mono<T> insert(T document) {
        return this.insert(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> insert(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.CREATE_ONLY);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleError(document, data, policy, operations);
        }
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Flux<T> insertAll(Iterable<? extends T> documents) {
        this.validateForBatchWrite(documents, "Documents for insert");
        return this.insertAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> insertAll(Iterable<? extends T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for insert");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.INSERT_OPERATION);
    }

    @Override
    public <T> Mono<T> persist(T document, WritePolicy policy) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        return this.persist(document, policy, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> persist(T document, WritePolicy policy, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Mono<T> update(T document) {
        return this.update(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> update(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}), Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, policy, operations, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
        }
        WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Mono<T> update(T document, Collection<String> fields) {
        return this.update(document, this.getSetName((Object)document), fields);
    }

    @Override
    public <T> Mono<T> update(T document, String setName, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(fields, (String)"Fields must not be null!");
        AerospikeWriteData data = this.writeDataWithSpecificFields(document, setName, fields);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy policy = this.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, policy, operations, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
        }
        WritePolicy policy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return this.doPersistAndHandleError(document, data, policy, operations);
    }

    @Override
    public <T> Flux<T> updateAll(Iterable<? extends T> documents) {
        this.validateForBatchWrite(documents, "Documents for update");
        return this.updateAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> updateAll(Iterable<? extends T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for update");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
    }

    @Override
    @Deprecated(since="4.6.0", forRemoval=true)
    public <T> Mono<Void> delete(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        try {
            String set = this.getSetName((Class)entityClass);
            return Mono.fromRunnable(() -> this.reactorClient.getAerospikeClient().truncate(null, this.namespace, set, null));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    @Deprecated(since="4.6.0", forRemoval=true)
    public <T> Mono<Boolean> delete(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        return this.reactorClient.delete(this.ignoreGenerationPolicy(), this.getKey(id, entity)).map(k -> true).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> delete(T document) {
        return this.delete(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<Boolean> delete(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(document, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            return this.reactorClient.delete(this.expectGenerationPolicy(data), data.getKey()).hasElement().onErrorMap(e -> this.translateCasThrowable((Throwable)e, BaseAerospikeTemplate.OperationType.DELETE_OPERATION.toString()));
        }
        return this.reactorClient.delete(this.ignoreGenerationPolicy(), data.getKey()).hasElement().onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> deleteById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteById(id, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> deleteById(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.reactorClient.delete(this.ignoreGenerationPolicy(), this.getKey(id, setName)).map(k -> true).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> deleteAll(Iterable<T> documents) {
        this.validateForBatchWrite(documents, "Documents for deleting");
        return this.deleteAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Mono<Void> deleteAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(documents, "Documents for deleting");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.DELETE_OPERATION).then();
    }

    @Override
    public <T> Mono<Void> deleteByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        this.validateForBatchWrite(ids, "IDs");
        return this.deleteByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Void> deleteByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(ids, "IDs");
        int batchSize = this.converter.getAerospikeSettings().getBatchWriteSize();
        ArrayList idsList = new ArrayList();
        Flux result = Flux.empty();
        for (Object id : ids) {
            if (this.batchWriteSizeMatch(batchSize, idsList.size())) {
                result = this.deleteByIds(idsList, setName).concatWith((Publisher)result);
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            result = this.deleteByIds(idsList, setName).concatWith((Publisher)result);
        }
        return result.then();
    }

    private Mono<Void> deleteByIds(Collection<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        this.validateForBatchWrite(ids, "IDs");
        Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, setName)).toArray(Key[]::new);
        return this.batchDeleteAndCheckForErrors(this.reactorClient, keys);
    }

    private Mono<Void> batchDeleteAndCheckForErrors(IAerospikeReactorClient reactorClient, Key[] keys) {
        Function<BatchResults, Mono> checkForErrors = results -> {
            if (results.records == null) {
                return Mono.error((Throwable)new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete")));
            }
            for (BatchRecord record : results.records) {
                if (!this.batchRecordFailed(record)) continue;
                return Mono.error((Throwable)new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete")));
            }
            return Mono.empty();
        };
        return reactorClient.delete(null, null, keys).onErrorMap(this::translateError).flatMap(checkForErrors);
    }

    @Override
    public Mono<Void> deleteByIds(GroupedKeys groupedKeys) {
        this.validateGroupedKeys(groupedKeys);
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return Mono.empty();
        }
        return this.deleteEntitiesByGroupedKeys(groupedKeys);
    }

    private Mono<Void> deleteEntitiesByGroupedKeys(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        this.reactorClient.delete(null, null, entitiesKeys.getKeys()).doOnError(this::translateError);
        return this.batchDeleteAndCheckForErrors(this.reactorClient, entitiesKeys.getKeys());
    }

    @Override
    public <T> Mono<Void> deleteAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteAll(this.getSetName((Class)entityClass), null);
    }

    @Override
    public <T> Mono<Void> deleteAll(Class<T> entityClass, Instant beforeLastUpdate) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteAll(this.getSetName((Class)entityClass), beforeLastUpdate);
    }

    @Override
    public Mono<Void> deleteAll(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.deleteAll(setName, null);
    }

    @Override
    public Mono<Void> deleteAll(String setName, Instant beforeLastUpdate) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Calendar beforeLastUpdateCalendar = this.convertToCalendar(beforeLastUpdate);
        try {
            return Mono.fromRunnable(() -> this.reactorClient.getAerospikeClient().truncate(null, this.namespace, setName, beforeLastUpdateCalendar));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Mono<T> add(T document, Map<String, Long> values) {
        return this.add(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> add(T document, String setName, Map<String, Long> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = new Operation[values.size() + 1];
        int x = 0;
        for (Map.Entry<String, Long> entry : values.entrySet()) {
            operations[x] = new Operation(Operation.Type.ADD, entry.getKey(), Value.get((Object)entry.getValue()));
            ++x;
        }
        operations[x] = Operation.get();
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        return this.executeOperationsOnValue(document, data, operations, writePolicy);
    }

    @Override
    public <T> Mono<T> add(T document, String binName, long value) {
        return this.add(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> add(T document, String setName, String binName, long value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        Operation[] operations = new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(document, data, operations, writePolicy);
    }

    @Override
    public <T> Mono<T> append(T document, Map<String, String> values) {
        return this.append(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> append(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = CoreUtils.operations(values, Operation.Type.APPEND, Operation.get());
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    @Override
    public <T> Mono<T> append(T document, String binName, String value) {
        return this.append(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> append(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    @Override
    public <T> Mono<T> prepend(T document, Map<String, String> values) {
        return this.prepend(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> prepend(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = CoreUtils.operations(values, Operation.Type.PREPEND, Operation.get());
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    @Override
    public <T> Mono<T> prepend(T document, String binName, String value) {
        return this.prepend(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> prepend(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = new Operation[]{Operation.prepend((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return this.executeOperationsOnValue(document, data, operations, null);
    }

    private <T> Mono<T> executeOperationsOnValue(T document, AerospikeWriteData data, Operation[] operations, WritePolicy writePolicy) {
        return this.reactorClient.operate(writePolicy, data.getKey(), operations).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, this.getEntityClass(document), keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<T> execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        return Mono.fromSupplier(supplier).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findById(id, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass, String setName) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, setName);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), null, null).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        return this.reactorClient.get(key).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Mono<S> findById(Object id, Class<T> entityClass, Class<S> targetClass) {
        return this.findById(id, entityClass, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Mono<S> findById(Object id, Class<T> entityClass, Class<S> targetClass, String setName) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, setName);
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), binNames, null).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, targetClass, keyRecord.record)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        return this.reactorClient.get(null, key, binNames).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, targetClass, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIds(ids, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIds(ids, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> targetClass, String setName) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(targetClass, (String)"Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        int batchSize = this.converter.getAerospikeSettings().getBatchWriteSize();
        ArrayList idsList = new ArrayList();
        Flux result = Flux.empty();
        for (Object id : ids) {
            if (this.batchWriteSizeMatch(batchSize, idsList.size())) {
                result = Flux.concat((Publisher[])new Publisher[]{result, this.findByIds(idsList, targetClass, setName)});
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            result = Flux.concat((Publisher[])new Publisher[]{result, this.findByIds(idsList, targetClass, setName)});
        }
        return result;
    }

    private <T> Flux<T> findByIds(Collection<?> ids, Class<T> targetClass, String setName) {
        Key[] keys = (Key[])IterableConverter.toList(ids).stream().map(id -> this.getKey(id, setName)).toArray(Key[]::new);
        return this.reactorClient.get(null, keys).flatMap(kr -> Mono.just((Object)kr.asMap())).flatMapMany(keyRecordMap -> {
            List entities = keyRecordMap.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> this.mapToEntity((Key)entry.getKey(), targetClass, (Record)entry.getValue())).collect(Collectors.toList());
            return Flux.fromIterable(entities);
        });
    }

    @Override
    public Mono<GroupedEntities> findByIds(GroupedKeys groupedKeys) {
        this.validateGroupedKeys(groupedKeys);
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return Mono.just((Object)GroupedEntities.builder().build());
        }
        return this.findGroupedEntitiesByGroupedKeys(groupedKeys);
    }

    private Mono<GroupedEntities> findGroupedEntitiesByGroupedKeys(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        return this.reactorClient.get(null, entitiesKeys.getKeys()).map(item -> this.toGroupedEntities(entitiesKeys, item.records)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Mono<?> findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, Query query) {
        return this.findByIdUsingQuery(id, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Mono<?> findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, String setName, Query query) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, setName);
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        Class<Object> target = targetClass != null && targetClass != entityClass ? targetClass : entityClass;
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), binNames, query).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        Policy policy = null;
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            policy = new Policy(this.reactorClient.getReadPolicyDefault());
            policy.filterExp = this.reactorQueryEngine.getFilterExpressionsBuilder().build(query);
        }
        return this.reactorClient.get(policy, key, binNames).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Flux<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, Query query) {
        return this.findByIdsUsingQuery(ids, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Flux<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, String setName, Query query) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy policy = this.getBatchPolicyFilterExp(query);
        Class<Object> target = targetClass != null && targetClass != entityClass ? targetClass : entityClass;
        return Flux.fromIterable(ids).map(id -> this.getKey(id, setName)).flatMap(key -> this.getFromClient(policy, (Key)key, targetClass)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record));
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.find(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> find(Query query, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.find(query, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> targetClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, query);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.findAll(entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findAll(Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findAll(Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.find(setName, targetClass);
    }

    @Override
    public <T> Flux<T> findAll(Sort sort, long offset, long limit, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAll(sort, offset, limit, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findAll(Sort sort, long offset, long limit, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(sort, offset, limit, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findAll(Sort sort, long offset, long limit, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, sort, offset, limit);
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findInRange(offset, limit, sort, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findInRange(long offset, long limit, Sort sort, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findInRange(offset, limit, sort, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, sort, offset, limit);
    }

    private BatchPolicy getBatchPolicyFilterExp(Query query) {
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            BatchPolicy policy = new BatchPolicy(this.reactorClient.getAerospikeClient().getBatchPolicyDefault());
            policy.filterExp = this.reactorQueryEngine.getFilterExpressionsBuilder().build(query);
            return policy;
        }
        return null;
    }

    private Mono<KeyRecord> getFromClient(BatchPolicy finalPolicy, Key key, Class<?> targetClass) {
        if (targetClass != null) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            return this.reactorClient.get((Policy)finalPolicy, key, binNames);
        }
        return this.reactorClient.get((Policy)finalPolicy, key);
    }

    @Override
    public <T> Mono<Boolean> exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(id, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> exists(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Key key = this.getKey(id, setName);
        return this.reactorClient.exists(key).map(Objects::nonNull).defaultIfEmpty((Object)false).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> existsByQuery(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.existsByQuery(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<Boolean> existsByQuery(Query query, Class<T> entityClass, String setName) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.find(query, entityClass, setName).hasElements();
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.count(setName);
    }

    @Override
    public Mono<Long> count(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            return Mono.fromCallable(() -> this.countSet(setName));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    private long countSet(String setName) {
        Node[] nodes = this.reactorClient.getAerospikeClient().getNodes();
        int replicationFactor = Utils.getReplicationFactor(nodes, this.namespace);
        long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(node, this.namespace, setName)).sum();
        return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
    }

    @Override
    public <T> Mono<Long> count(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.count(query, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Long> count(Query query, String setName) {
        Assert.notNull((Object)setName, (String)"Set for count must not be null!");
        return this.countRecordsUsingQuery(setName, query).count();
    }

    private Flux<KeyRecord> countRecordsUsingQuery(String setName, Query query) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = QualifierUtils.getIdQualifier(qualifier)) != null) {
            return this.findByIdsWithoutMapping(TemplateUtils.getIdValue(idQualifier), setName, null, new Query(TemplateUtils.excludeIdQualifier(qualifier)));
        }
        return this.reactorQueryEngine.selectForCount(this.namespace, setName, query);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        return this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.createIndex(entityClass, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        return this.createIndex(this.getSetName((Class)entityClass), indexName, binName, indexType, indexCollectionType, ctx);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType) {
        return this.createIndex(setName, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.createIndex(setName, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        Assert.notNull((Object)ctx, (String)"Ctx must not be null!");
        return this.reactorClient.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType, ctx).then(this.reactorIndexRefresher.refreshIndexes()).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteIndex(this.getSetName((Class)entityClass), indexName);
    }

    @Override
    public Mono<Void> deleteIndex(String setName, String indexName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        return this.reactorClient.dropIndex(null, this.namespace, setName, indexName).then(this.reactorIndexRefresher.refreshIndexes()).onErrorMap(this::translateError);
    }

    @Override
    public Mono<Boolean> indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            Node[] nodes;
            for (Node node : nodes = this.reactorClient.getAerospikeClient().getNodes()) {
                String response = Info.request((InfoPolicy)this.reactorClient.getAerospikeClient().getInfoPolicyDefault(), (Node)node, (String)("sindex-exists:ns=" + this.namespace + ";indexname=" + indexName));
                if (response == null) {
                    throw new AerospikeException("Null node response");
                }
                if (response.equalsIgnoreCase("true")) {
                    return Mono.just((Object)true);
                }
                if (response.equalsIgnoreCase("false")) {
                    return Mono.just((Object)false);
                }
                Matcher matcher = INDEX_EXISTS_REGEX_PATTERN.matcher(response);
                if (matcher.matches()) {
                    int reason;
                    try {
                        reason = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        throw new AerospikeException("Unexpected node response, unable to parse ResultCode: " + response);
                    }
                    if (reason == 20) continue;
                    throw new AerospikeException(reason);
                }
                throw new AerospikeException("Unexpected node response: " + response);
            }
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
        return Mono.just((Object)false);
    }

    @Override
    public IAerospikeReactorClient getAerospikeReactorClient() {
        return this.reactorClient;
    }

    @Override
    public long getQueryMaxRecords() {
        return this.reactorQueryEngine.getQueryMaxRecords();
    }

    private <T> Mono<T> doPersistAndHandleError(T document, AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        return this.reactorClient.operate(policy, data.getKey(), operations).map(docKey -> document).onErrorMap(this::translateError);
    }

    private <T> Mono<T> doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy policy, Operation[] operations, BaseAerospikeTemplate.OperationType operationType) {
        return this.putAndGetHeader(data, policy, operations).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, i -> this.translateCasError((AerospikeException)((Object)i), "Failed to " + operationType.toString() + " record due to versions mismatch"));
    }

    private <T> Mono<T> doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        return this.putAndGetHeader(data, policy, operations).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, this::translateError);
    }

    private Mono<Record> putAndGetHeader(AerospikeWriteData data, WritePolicy policy, Operation[] operations) {
        return this.reactorClient.operate(policy, data.getKey(), operations).map(keyRecord -> keyRecord.record);
    }

    private Mono<KeyRecord> getAndTouch(Key key, int expiration, String[] binNames, Query query) {
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(expiration);
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            writePolicyBuilder.filterExp(this.reactorQueryEngine.getFilterExpressionsBuilder().build(query));
        }
        WritePolicy writePolicy = writePolicyBuilder.build();
        if (binNames == null || binNames.length == 0) {
            return this.reactorClient.operate(writePolicy, key, new Operation[]{Operation.touch(), Operation.get()});
        }
        Operation[] operations = new Operation[binNames.length + 1];
        operations[0] = Operation.touch();
        for (int i = 1; i < operations.length; ++i) {
            operations[i] = Operation.get((String)binNames[i - 1]);
        }
        return this.reactorClient.operate(writePolicy, key, operations);
    }

    private String[] getBinNamesFromTargetClass(Class<?> targetClass) {
        AerospikePersistentEntity targetEntity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(targetClass);
        ArrayList binNamesList = new ArrayList();
        targetEntity.doWithProperties(property -> binNamesList.add(property.getFieldName()));
        return binNamesList.toArray(new String[0]);
    }

    private Throwable translateError(Throwable e) {
        if (e instanceof AerospikeException) {
            AerospikeException ae = (AerospikeException)e;
            return this.translateError(ae);
        }
        return e;
    }

    private Throwable translateCasThrowable(Throwable e, String operationName) {
        if (e instanceof AerospikeException) {
            AerospikeException ae = (AerospikeException)e;
            return this.translateCasError(ae, "Failed to %s record due to versions mismatch".formatted(operationName));
        }
        return e;
    }

    private <T> Flux<T> findWithPostProcessing(String setName, Class<T> targetClass, Query query) {
        this.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        Flux<T> results = this.findUsingQueryWithDistinctPredicate(setName, targetClass, CoreUtils.getDistinctPredicate(query), query);
        results = this.applyPostProcessingOnResults(results, query);
        return results;
    }

    private <T> Flux<T> findWithPostProcessing(String setName, Class<T> targetClass, Sort sort, long offset, long limit) {
        this.verifyUnsortedWithOffset(sort, offset);
        Flux<T> results = this.find(setName, targetClass);
        results = this.applyPostProcessingOnResults(results, sort, offset, limit);
        return results;
    }

    @Override
    public <T, S> Flux<S> findUsingQueryWithoutPostProcessing(Class<T> entityClass, Class<S> targetClass, Query query) {
        this.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        return this.findUsingQueryWithDistinctPredicate(this.getSetName((Class)entityClass), targetClass, CoreUtils.getDistinctPredicate(query), query);
    }

    private void verifyUnsortedWithOffset(Sort sort, long offset) {
        if ((sort == null || sort.isUnsorted()) && offset > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
    }

    private <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, Query query) {
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = this.getComparator(query);
            results = results.sort(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.take((long)query.getRows());
        }
        return results;
    }

    private <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, Sort sort, long offset, long limit) {
        if (sort != null && sort.isSorted()) {
            Comparator comparator = this.getComparator(sort);
            results = results.sort(comparator);
        }
        if (offset > 0L) {
            results = results.skip(offset);
        }
        if (limit > 0L) {
            results = results.take(limit);
        }
        return results;
    }

    private <T> Flux<T> find(String setName, Class<T> targetClass) {
        return this.findRecordsUsingQuery(setName, targetClass, null).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, targetClass));
    }

    private <T> Flux<T> findUsingQueryWithDistinctPredicate(String setName, Class<T> targetClass, Predicate<KeyRecord> distinctPredicate, Query query) {
        return this.findRecordsUsingQuery(setName, targetClass, query).filter(distinctPredicate).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, targetClass));
    }

    private <T> Flux<KeyRecord> findRecordsUsingQuery(String setName, Class<T> targetClass, Query query) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = QualifierUtils.getIdQualifier(qualifier)) != null) {
            return this.findByIdsWithoutMapping(TemplateUtils.getIdValue(idQualifier), setName, targetClass, new Query(TemplateUtils.excludeIdQualifier(qualifier)));
        }
        if (targetClass != null) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            return this.reactorQueryEngine.select(this.namespace, setName, binNames, query);
        }
        return this.reactorQueryEngine.select(this.namespace, setName, null, query);
    }

    private <T> Flux<KeyRecord> findByIdsWithoutMapping(Collection<?> ids, String setName, Class<T> targetClass, Query query) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy policy = this.getBatchPolicyFilterExp(query);
        return Flux.fromIterable(ids).map(id -> this.getKey(id, setName)).flatMap(key -> this.getFromClient(policy, (Key)key, targetClass)).filter(keyRecord -> Objects.nonNull(keyRecord.record));
    }
}

