/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.aerospike.annotation.Indexed;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AerospikeIndexResolver
implements EnvironmentAware {
    private Environment environment;

    public Set<AerospikeIndexDefinition> detectIndexes(BasicAerospikePersistentEntity<?> persistentEntity) {
        return StreamSupport.stream(persistentEntity.spliterator(), false).filter(property -> property.isAnnotationPresent(Indexed.class)).map(property -> this.convertToIndex(persistentEntity, (AerospikePersistentProperty)property)).collect(Collectors.toSet());
    }

    private AerospikeIndexDefinition convertToIndex(BasicAerospikePersistentEntity<?> persistentEntity, AerospikePersistentProperty property) {
        String indexName;
        Indexed annotation = (Indexed)property.getRequiredAnnotation(Indexed.class);
        if (StringUtils.hasText((String)annotation.name())) {
            Assert.notNull((Object)this.environment, (String)"Environment must be set to use 'indexed'");
            indexName = this.environment.resolveRequiredPlaceholders(annotation.name());
        } else {
            indexName = this.getIndexName(persistentEntity, property, annotation);
        }
        String binName = StringUtils.hasText((String)annotation.bin()) ? annotation.bin() : property.getFieldName();
        return AerospikeIndexDefinition.builder().entityClass(persistentEntity.getType()).bin(binName).name(indexName).type(annotation.type()).collectionType(annotation.collectionType()).ctx(this.toCtxArray(annotation.ctx())).build();
    }

    private String getIndexName(BasicAerospikePersistentEntity<?> entity, AerospikePersistentProperty property, Indexed annotation) {
        return String.join((CharSequence)"_", entity.getSetName(), property.getFieldName(), annotation.type().name().toLowerCase(), annotation.collectionType().name().toLowerCase());
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private CTX[] toCtxArray(String ctxString) {
        CTX[] ctxArr;
        if (!StringUtils.hasLength((String)ctxString)) {
            return null;
        }
        String[] ctxTokens = ctxString.split("\\.");
        if (ctxTokens.length != (ctxArr = (CTX[])Arrays.stream(ctxTokens).filter(Predicate.not(String::isEmpty)).map(this::toCtx).filter(Objects::nonNull).toArray(CTX[]::new)).length) {
            throw new IllegalArgumentException("@Indexed annotation '" + ctxString + "' contains empty context");
        }
        return ctxArr;
    }

    private CTX toCtx(String singleCtx) {
        switch (singleCtx.charAt(0)) {
            case '{': {
                return this.processSingleCtx(singleCtx, CtxType.MAP);
            }
            case '[': {
                return this.processSingleCtx(singleCtx, CtxType.LIST);
            }
        }
        Object res = AerospikeIndexResolver.isInDoubleOrSingleQuotes(singleCtx) ? singleCtx.substring(1, singleCtx.length() - 1) : AerospikeIndexResolver.parseIntOrReturnStr(singleCtx);
        return CTX.mapKey((Value)Value.get((Object)res));
    }

    private CTX processSingleCtx(String singleCtx, CtxType ctxType) {
        int length = singleCtx.length();
        if (length < 3) {
            throw new IllegalArgumentException("@Indexed annotation: context string '" + singleCtx + "' has no content");
        }
        if (singleCtx.charAt(length - 1) != ctxType.closingChar) {
            throw new IllegalArgumentException("@Indexed annotation: brackets mismatch, expecting '" + ctxType.closingChar + "', got '" + singleCtx.charAt(length - 1) + "' instead");
        }
        String substring = singleCtx.substring(2, length - 1);
        CTX result = singleCtx.charAt(1) == '=' && length > 3 ? this.processCtxValue(substring, ctxType) : (singleCtx.charAt(1) == '#' && length > 3 ? this.processCtxRank(substring, ctxType) : this.processCtxIndex(singleCtx, length, ctxType));
        return result;
    }

    private CTX processCtxValue(String substring, CtxType ctxType) {
        Object result = AerospikeIndexResolver.isInDoubleOrSingleQuotes(substring) ? substring.substring(1, substring.length() - 1) : AerospikeIndexResolver.parseIntOrReturnStr(substring);
        return switch (ctxType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> CTX.mapValue((Value)Value.get((Object)result));
            case 1 -> CTX.listValue((Value)Value.get((Object)result));
        };
    }

    private CTX processCtxRank(String substring, CtxType ctxType) {
        int rank = this.parseIntOrFail(substring, ctxType, "rank");
        return switch (ctxType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> CTX.mapRank((int)rank);
            case 1 -> CTX.listRank((int)rank);
        };
    }

    private CTX processCtxIndex(String singleCtx, int length, CtxType ctxType) {
        String substring = singleCtx.substring(1, length - 1);
        int idx = this.parseIntOrFail(substring, ctxType, "index");
        return switch (ctxType.ordinal()) {
            default -> throw new IncompatibleClassChangeError();
            case 0 -> CTX.mapIndex((int)idx);
            case 1 -> CTX.listIndex((int)idx);
        };
    }

    private int parseIntOrFail(String substring, CtxType ctxType, String parameterName) {
        try {
            return Integer.parseInt(substring);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("@Indexed annotation " + String.valueOf((Object)ctxType) + " " + parameterName + ": expecting only integer values, got '" + substring + "' instead");
        }
    }

    private static Object parseIntOrReturnStr(String str) {
        Object res;
        try {
            res = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            res = str;
        }
        return res;
    }

    private static boolean isInDoubleOrSingleQuotes(String str) {
        return !(str.length() <= 2 || str.charAt(0) != '\"' && str.charAt(0) != '\'' || str.charAt(str.length() - 1) != '\"' && str.charAt(str.length() - 1) != '\'');
    }

    private static enum CtxType {
        MAP('}'),
        LIST(']');

        private final char closingChar;

        private CtxType(char closingChar) {
            this.closingChar = closingChar;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

