/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.Expression;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;

public class FilterExpressionsBuilder {
    public Expression build(Query query) {
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && this.excludeIrrelevantFilters(qualifier)) {
            return Exp.build((Exp)qualifier.toFilterExp());
        }
        return null;
    }

    private boolean excludeIrrelevantFilters(Qualifier qualifier) {
        if (!qualifier.queryAsFilter().booleanValue()) {
            return true;
        }
        if (qualifier.queryAsFilter().booleanValue() && FilterOperation.dualFilterOperations.contains((Object)qualifier.getOperation())) {
            qualifier.setQueryAsFilter(false);
            return true;
        }
        qualifier.setQueryAsFilter(false);
        return false;
    }
}

