/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Key;
import com.aerospike.client.Record;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import com.aerospike.client.query.Statement;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.KeyQualifier;
import org.springframework.data.aerospike.query.KeyRecordIterator;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.StatementBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.lang.Nullable;

public class QueryEngine {
    public static final String SCANS_DISABLED_MESSAGE = "Query without a filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scans-enabled` property.";
    private final IAerospikeClient client;
    private final StatementBuilder statementBuilder;
    private final FilterExpressionsBuilder filterExpressionsBuilder;
    private boolean scansEnabled;
    private long queryMaxRecords;

    public QueryEngine(IAerospikeClient client, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder) {
        this.client = client;
        this.statementBuilder = statementBuilder;
        this.filterExpressionsBuilder = filterExpressionsBuilder;
    }

    public KeyRecordIterator select(String namespace, String set, @Nullable Query query) {
        return this.select(namespace, set, null, query);
    }

    public KeyRecordIterator select(String namespace, String set, String[] binNames, @Nullable Query query) {
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier instanceof KeyQualifier) {
            KeyQualifier kq = (KeyQualifier)qualifier;
            Key key = kq.makeKey(namespace, set);
            Record record = this.getRecord(null, key, binNames);
            if (record == null) {
                return new KeyRecordIterator(namespace);
            }
            KeyRecord keyRecord = new KeyRecord(key, record);
            return new KeyRecordIterator(namespace, keyRecord);
        }
        Statement statement = this.statementBuilder.build(namespace, set, query, binNames);
        statement.setMaxRecords(this.queryMaxRecords);
        QueryPolicy localQueryPolicy = this.getQueryPolicy(query, true);
        if (!this.scansEnabled && statement.getFilter() == null) {
            throw new IllegalStateException(SCANS_DISABLED_MESSAGE);
        }
        RecordSet rs = this.client.query(localQueryPolicy, statement);
        return new KeyRecordIterator(namespace, rs);
    }

    public KeyRecordIterator selectForCount(String namespace, String set, @Nullable Query query) {
        Statement statement = this.statementBuilder.build(namespace, set, query);
        statement.setMaxRecords(this.queryMaxRecords);
        QueryPolicy localQueryPolicy = this.getQueryPolicy(query, false);
        if (!this.scansEnabled && statement.getFilter() == null) {
            throw new IllegalStateException(SCANS_DISABLED_MESSAGE);
        }
        RecordSet rs = this.client.query(localQueryPolicy, statement);
        return new KeyRecordIterator(namespace, rs);
    }

    private Record getRecord(Policy policy, Key key, String[] binNames) {
        if (binNames == null || binNames.length == 0) {
            return this.client.get(policy, key);
        }
        return this.client.get(policy, key, binNames);
    }

    private QueryPolicy getQueryPolicy(Query query, boolean includeBins) {
        QueryPolicy queryPolicy = new QueryPolicy(this.client.getQueryPolicyDefault());
        queryPolicy.filterExp = this.filterExpressionsBuilder.build(query);
        queryPolicy.includeBinData = includeBins;
        return queryPolicy;
    }

    public FilterExpressionsBuilder getFilterExpressionsBuilder() {
        return this.filterExpressionsBuilder;
    }

    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    public void setQueryMaxRecords(long queryMaxRecords) {
        this.queryMaxRecords = queryMaxRecords;
    }

    public long getQueryMaxRecords() {
        return this.queryMaxRecords;
    }

    @Deprecated(since="4.6.0", forRemoval=true)
    public static enum Meta {
        KEY,
        TTL,
        EXPIRATION,
        GENERATION;


        public String toString() {
            return switch (this.ordinal()) {
                case 0 -> "__key";
                case 2 -> "__Expiration";
                case 3 -> "__generation";
                default -> throw new IllegalArgumentException();
            };
        }
    }
}

