/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.cache;

import com.aerospike.client.cdt.CTX;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.aerospike.query.model.Index;

public class IndexInfoParser {
    private static final String INDEX_NAME = "indexname";
    private static final String BIN = "bin";
    private static final String BINS = "bins";
    private static final String SET = "set";
    private static final String NS = "ns";
    private static final String NAMESPACE = "namespace";
    private static final String TYPE = "type";
    private static final String STRING_TYPE = "STRING";
    private static final String GEO2DSPHERE_TYPE = "GEO2DSPHERE";
    private static final String NUMERIC_TYPE = "NUMERIC";
    private static final String NONE = "NONE";
    private static final String LIST = "LIST";
    private static final String MAPKEYS = "MAPKEYS";
    private static final String MAPVALUES = "MAPVALUES";
    private static final String CONTEXT = "context";

    public Index parse(String infoString) {
        Map<String, String> values = this.getIndexInfo(infoString);
        String name = this.getRequiredName(values);
        String namespace = this.getRequiredNamespace(values);
        String set = this.getNullableSet(values);
        String bin = this.getRequiredBin(values);
        IndexType indexType = this.getIndexTypeInternal(values);
        IndexCollectionType collectionType = this.getIndexCollectionTypeInternal(values);
        CTX[] context = this.getIndexContext(values);
        return Index.builder().name(name).namespace(namespace).set(set).bin(bin).indexType(indexType).indexCollectionType(collectionType).ctx(context).build();
    }

    private Map<String, String> getIndexInfo(String info) {
        if (info.isEmpty()) {
            return Collections.emptyMap();
        }
        return Arrays.stream(info.split(":")).map(part -> {
            String[] kvParts = part.contains(CONTEXT) ? part.split("=", 2) : part.split("=");
            if (kvParts.length == 0) {
                throw new IllegalStateException("Failed to parse info string part: " + part);
            }
            if (kvParts.length == 1) {
                return null;
            }
            return new AbstractMap.SimpleEntry<String, String>(kvParts[0], kvParts[1]);
        }).filter(Objects::nonNull).collect(Collectors.toMap(AbstractMap.SimpleEntry::getKey, AbstractMap.SimpleEntry::getValue));
    }

    private String getRequiredName(Map<String, String> values) {
        String name = values.get(INDEX_NAME);
        if (name != null) {
            return name;
        }
        throw new IllegalStateException("Name not present in info: " + String.valueOf(values));
    }

    private IndexType getIndexTypeInternal(Map<String, String> values) {
        String indexTypeString = values.get(TYPE);
        if (indexTypeString == null) {
            throw new IllegalStateException("Index type not present in info: " + String.valueOf(values));
        }
        if (indexTypeString.equalsIgnoreCase(STRING_TYPE)) {
            return IndexType.STRING;
        }
        if (indexTypeString.equalsIgnoreCase(GEO2DSPHERE_TYPE)) {
            return IndexType.GEO2DSPHERE;
        }
        if (indexTypeString.equalsIgnoreCase(NUMERIC_TYPE)) {
            return IndexType.NUMERIC;
        }
        return null;
    }

    private IndexCollectionType getIndexCollectionTypeInternal(Map<String, String> values) {
        String indexTypeString = values.get("indextype");
        if (indexTypeString == null) {
            throw new IllegalStateException("Index type not present in info: " + String.valueOf(values));
        }
        if (indexTypeString.equalsIgnoreCase(NONE)) {
            return IndexCollectionType.DEFAULT;
        }
        if (indexTypeString.equalsIgnoreCase(LIST)) {
            return IndexCollectionType.LIST;
        }
        if (indexTypeString.equalsIgnoreCase(MAPKEYS)) {
            return IndexCollectionType.MAPKEYS;
        }
        if (indexTypeString.equalsIgnoreCase(MAPVALUES)) {
            return IndexCollectionType.MAPVALUES;
        }
        return null;
    }

    private String getRequiredBin(Map<String, String> values) {
        String bin = values.get(BIN);
        if (bin != null) {
            return bin;
        }
        String bins = values.get(BINS);
        if (bins != null) {
            return bins;
        }
        throw new IllegalStateException("Bin not present in info: " + String.valueOf(values));
    }

    private String getNullableSet(Map<String, String> values) {
        String set = values.get(SET);
        if (set != null && set.equalsIgnoreCase("null")) {
            return null;
        }
        return set;
    }

    private String getRequiredNamespace(Map<String, String> values) {
        String ns = values.get(NS);
        if (ns != null) {
            return ns;
        }
        String namespace = values.get(NAMESPACE);
        if (namespace != null) {
            return namespace;
        }
        throw new IllegalStateException("Namespace not present in info: " + String.valueOf(values));
    }

    private CTX[] getIndexContext(Map<String, String> values) {
        String contextString = values.get(CONTEXT);
        if (contextString != null && !contextString.equals("null")) {
            return CTX.fromBase64((String)contextString);
        }
        return null;
    }
}

