/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.cache;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.springframework.data.aerospike.query.cache.IndexesCache;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.model.Index;
import org.springframework.data.aerospike.query.model.IndexKey;
import org.springframework.data.aerospike.query.model.IndexedField;
import org.springframework.data.aerospike.query.model.IndexesInfo;

public class IndexesCacheHolder
implements IndexesCache,
IndexesCacheUpdater {
    private volatile IndexesInfo cache = IndexesInfo.empty();

    @Override
    public Optional<Index> getIndex(IndexKey indexKey) {
        return Optional.ofNullable(this.cache.indexes.get(indexKey));
    }

    @Override
    public List<Index> getAllIndexesForField(IndexedField indexedField) {
        ArrayList<Index> indexList = new ArrayList<Index>();
        this.cache.indexes.forEach((key, value) -> {
            if (Objects.equals(key.getNamespace(), indexedField.getNamespace()) && Objects.equals(key.getSet(), indexedField.getSet()) && Objects.equals(key.getField(), indexedField.getField())) {
                indexList.add((Index)value);
            }
        });
        return indexList;
    }

    @Override
    public boolean hasIndexFor(IndexedField indexedField) {
        return this.cache.indexedFields.contains(indexedField);
    }

    @Override
    public void update(IndexesInfo cache) {
        this.cache = cache;
    }
}

