/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.model;

import com.aerospike.client.cdt.CTX;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import java.util.Arrays;
import java.util.Objects;

public class IndexKey {
    private final String namespace;
    private final String set;
    private final String field;
    private final IndexType type;
    private final IndexCollectionType collectionType;
    private final CTX[] ctx;

    public IndexKey(String namespace, String set, String field, IndexType type, IndexCollectionType collectionType) {
        this.namespace = namespace;
        this.set = set;
        this.field = field;
        this.type = type;
        this.collectionType = collectionType;
        this.ctx = null;
    }

    public IndexKey(String namespace, String set, String field, IndexType type, IndexCollectionType collectionType, CTX[] ctx) {
        this.namespace = namespace;
        this.set = set;
        this.field = field;
        this.type = type;
        this.collectionType = collectionType;
        this.ctx = ctx;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getSet() {
        return this.set;
    }

    public String getField() {
        return this.field;
    }

    public IndexType getType() {
        return this.type;
    }

    public IndexCollectionType getCollectionType() {
        return this.collectionType;
    }

    public CTX[] getCTX() {
        return this.ctx;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexKey indexKey = (IndexKey)o;
        return Objects.equals(this.namespace, indexKey.namespace) && Objects.equals(this.set, indexKey.set) && Objects.equals(this.field, indexKey.field) && this.type == indexKey.type && this.collectionType == indexKey.collectionType && this.ctx == indexKey.ctx;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.set, this.field, this.type, this.collectionType, this.ctx);
    }

    public String toString() {
        return "IndexKey{namespace='" + this.namespace + "', set='" + this.set + "', field='" + this.field + "', type=" + String.valueOf(this.type) + ", collectionType=" + String.valueOf(this.collectionType) + ", ctx=" + Arrays.toString(this.ctx) + "}";
    }
}

