/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.qualifier;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.IQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;

abstract class BaseQualifierBuilder<T extends BaseQualifierBuilder<?>>
implements IQualifierBuilder {
    protected final Map<QualifierKey, Object> map = new HashMap<QualifierKey, Object>();

    BaseQualifierBuilder() {
    }

    public FilterOperation getFilterOperation() {
        return (FilterOperation)((Object)this.map.get((Object)QualifierKey.OPERATION));
    }

    public T setFilterOperation(FilterOperation filterOperation) {
        this.map.put(QualifierKey.OPERATION, (Object)filterOperation);
        return (T)this;
    }

    public String getField() {
        return (String)this.map.get((Object)QualifierKey.FIELD);
    }

    public boolean hasKey() {
        return this.map.get((Object)QualifierKey.KEY) != null;
    }

    public boolean hasValue() {
        return this.map.get((Object)QualifierKey.VALUE) != null;
    }

    public boolean hasSecondValue() {
        return this.map.get((Object)QualifierKey.SECOND_VALUE) != null;
    }

    public boolean hasDotPath() {
        return this.map.get((Object)QualifierKey.DOT_PATH) != null;
    }

    @Override
    public Qualifier build() {
        this.validate();
        return new Qualifier(this);
    }

    @Override
    public Map<QualifierKey, Object> getMap() {
        return Collections.unmodifiableMap(this.map);
    }

    protected void validate() {
    }
}

