/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.qualifier;

import java.util.Collection;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.BaseQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.util.Assert;

public class MetadataQualifierBuilder
extends BaseQualifierBuilder<MetadataQualifierBuilder> {
    MetadataQualifierBuilder() {
    }

    public CriteriaDefinition.AerospikeMetadata getMetadataField() {
        return (CriteriaDefinition.AerospikeMetadata)((Object)this.map.get((Object)QualifierKey.METADATA_FIELD));
    }

    public MetadataQualifierBuilder setMetadataField(CriteriaDefinition.AerospikeMetadata metadataField) {
        this.map.put(QualifierKey.METADATA_FIELD, metadataField);
        return this;
    }

    public Object getKeyAsObj() {
        return this.map.get((Object)QualifierKey.KEY);
    }

    public MetadataQualifierBuilder setKeyAsObj(Object object) {
        this.map.put(QualifierKey.KEY, object);
        return this;
    }

    public Object getValueAsObj() {
        return this.map.get((Object)QualifierKey.VALUE);
    }

    public MetadataQualifierBuilder setValueAsObj(Object object) {
        this.map.put(QualifierKey.VALUE, object);
        return this;
    }

    public Object getSecondValueAsObj() {
        return this.map.get((Object)QualifierKey.SECOND_VALUE);
    }

    public MetadataQualifierBuilder setSecondValueAsObj(Object object) {
        this.map.put(QualifierKey.SECOND_VALUE, object);
        return this;
    }

    @Override
    protected void validate() {
        if (this.getMetadataField() != null) {
            if (this.getField() == null) {
                FilterOperation operation = this.getFilterOperation();
                switch (operation) {
                    case EQ: 
                    case NOTEQ: 
                    case LT: 
                    case LTEQ: 
                    case GT: 
                    case GTEQ: {
                        Assert.isTrue((boolean)(this.getValueAsObj() instanceof Long), (String)(operation.name() + ": value1 is expected to be set as Long"));
                        break;
                    }
                    case BETWEEN: {
                        Assert.isTrue((boolean)(this.getValueAsObj() instanceof Long), (String)"BETWEEN: value1 is expected to be set as Long");
                        Assert.isTrue((boolean)(this.getSecondValueAsObj() instanceof Long), (String)"BETWEEN: value2 is expected to be set as Long");
                        break;
                    }
                    case NOT_IN: 
                    case IN: {
                        Assert.isTrue((this.getValueAsObj() instanceof Collection && !((Collection)this.getValueAsObj()).isEmpty() && ((Collection)this.getValueAsObj()).toArray()[0] instanceof Long ? 1 : 0) != 0, (String)(operation.name() + ": value1 is expected to be a non-empty Collection<Long>"));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Operation " + String.valueOf((Object)operation) + " cannot be applied to metadataField");
                    }
                }
            } else {
                throw new IllegalArgumentException("Either a field or a metadataField must be set, not both");
            }
        }
    }
}

