/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.qualifier;

import com.aerospike.client.Value;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.query.Filter;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.ConjunctionQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.IQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.IdQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.MetadataQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.util.StringUtils;

public class Qualifier
implements CriteriaDefinition,
Map<QualifierKey, Object>,
Serializable {
    private static final long serialVersionUID = -2689196529952712849L;
    protected final Map<QualifierKey, Object> internalMap = new HashMap<QualifierKey, Object>();

    protected Qualifier(IQualifierBuilder builder) {
        if (!builder.getMap().isEmpty()) {
            this.internalMap.putAll(builder.getMap());
        }
    }

    protected Qualifier(Qualifier qualifier) {
        if (!qualifier.getMap().isEmpty()) {
            this.internalMap.putAll(qualifier.getMap());
        }
    }

    @Override
    public Qualifier getCriteriaObject() {
        return this;
    }

    @Override
    public String getCriteriaField() {
        return this.getField();
    }

    private Map<QualifierKey, Object> getMap() {
        return Collections.unmodifiableMap(this.internalMap);
    }

    public static QualifierBuilder builder() {
        return new QualifierBuilder();
    }

    public static MetadataQualifierBuilder metadataBuilder() {
        return new MetadataQualifierBuilder();
    }

    public FilterOperation getOperation() {
        return (FilterOperation)((Object)this.internalMap.get((Object)QualifierKey.OPERATION));
    }

    public String getField() {
        return (String)this.internalMap.get((Object)QualifierKey.FIELD);
    }

    public CriteriaDefinition.AerospikeMetadata getMetadataField() {
        return (CriteriaDefinition.AerospikeMetadata)((Object)this.internalMap.get((Object)QualifierKey.METADATA_FIELD));
    }

    public void setQueryAsFilter(Boolean queryAsFilter) {
        this.internalMap.put(QualifierKey.AS_FILTER, queryAsFilter);
    }

    public Boolean queryAsFilter() {
        return this.internalMap.containsKey((Object)QualifierKey.AS_FILTER) && (Boolean)this.internalMap.get((Object)QualifierKey.AS_FILTER) != false;
    }

    public boolean hasQualifiers() {
        return this.internalMap.get((Object)QualifierKey.QUALIFIERS) != null;
    }

    public boolean hasId() {
        return this.internalMap.get((Object)QualifierKey.SINGLE_ID_FIELD) != null || this.internalMap.get((Object)QualifierKey.MULTIPLE_IDS_FIELD) != null;
    }

    public boolean hasSingleId() {
        return this.internalMap.get((Object)QualifierKey.SINGLE_ID_FIELD) != null;
    }

    public Object getId() {
        return this.hasSingleId() ? this.internalMap.get((Object)QualifierKey.SINGLE_ID_FIELD) : this.internalMap.get((Object)QualifierKey.MULTIPLE_IDS_FIELD);
    }

    public Qualifier[] getQualifiers() {
        return (Qualifier[])this.internalMap.get((Object)QualifierKey.QUALIFIERS);
    }

    public Value getKey() {
        return (Value)this.internalMap.get((Object)QualifierKey.KEY);
    }

    public Value getValue() {
        return (Value)this.internalMap.get((Object)QualifierKey.VALUE);
    }

    public Value getSecondValue() {
        return (Value)this.internalMap.get((Object)QualifierKey.SECOND_VALUE);
    }

    public List<String> getDotPath() {
        return (List)this.internalMap.get((Object)QualifierKey.DOT_PATH);
    }

    public Filter setQueryAsFilter() {
        return FilterOperation.valueOf(this.getOperation().toString()).sIndexFilter(this.internalMap);
    }

    public Exp toFilterExp() {
        return FilterOperation.valueOf(this.getOperation().toString()).filterExp(this.internalMap);
    }

    protected String luaFieldString(String field) {
        return String.format("rec['%s']", field);
    }

    protected String luaValueString(Value value) {
        if (null == value) {
            return null;
        }
        int type = value.getType();
        return switch (type) {
            case 3, 23 -> String.format("'%s'", value);
            default -> value.toString();
        };
    }

    @Override
    public int size() {
        return this.internalMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.internalMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.internalMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.internalMap.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        return this.internalMap.get(key);
    }

    @Override
    public Object put(QualifierKey key, Object value) {
        return this.internalMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.internalMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends QualifierKey, ?> m) {
        this.internalMap.putAll(m);
    }

    @Override
    public void clear() {
        this.internalMap.clear();
    }

    @Override
    public Set<QualifierKey> keySet() {
        return this.internalMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.internalMap.values();
    }

    @Override
    public Set<Map.Entry<QualifierKey, Object>> entrySet() {
        return this.internalMap.entrySet();
    }

    public String toString() {
        if (!StringUtils.hasLength((String)this.getField()) && StringUtils.hasLength((String)this.getMetadataField().toString())) {
            return String.format("%s:%s:%s:%s:%s", new Object[]{this.getField(), this.getOperation(), this.getKey(), this.getValue(), this.getSecondValue()});
        }
        return String.format("(metadata) %s:%s:%s:%s:%s", new Object[]{this.getMetadataField().toString(), this.getOperation(), this.getKey(), this.getValue(), this.getSecondValue()});
    }

    public static Qualifier idEquals(String id) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Short id) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Integer id) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Long id) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Character id) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(Byte id) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idEquals(byte[] id) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setId(id).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(String ... ids) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Short ... ids) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Integer ... ids) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Long ... ids) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Character ... ids) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(Byte ... ids) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier idIn(byte[] ... ids) {
        return new Qualifier((IQualifierBuilder)new IdQualifierBuilder().setIds(ids).setFilterOperation(FilterOperation.EQ));
    }

    public static Qualifier or(Qualifier ... qualifiers) {
        return new Qualifier(((ConjunctionQualifierBuilder)new ConjunctionQualifierBuilder().setFilterOperation(FilterOperation.OR)).setQualifiers(qualifiers));
    }

    public static Qualifier and(Qualifier ... qualifiers) {
        return new Qualifier(((ConjunctionQualifierBuilder)new ConjunctionQualifierBuilder().setFilterOperation(FilterOperation.AND)).setQualifiers(qualifiers));
    }
}

