/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.config;

import java.util.Map;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreator;
import org.springframework.data.keyvalue.repository.config.QueryCreatorType;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;

public abstract class BaseAerospikeRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    protected static final String MAPPING_CONTEXT_BEAN_NAME = "aerospikeMappingContext";
    protected static final String AEROSPIKE_TEMPLATE_BEAN_REF_ATTRIBUTE = "aerospikeTemplateRef";

    private static Class<?> getQueryCreatorType(AnnotationRepositoryConfigurationSource config) {
        AnnotationMetadata metadata = config.getEnableAnnotationMetadata();
        Map queryCreatorFoo = metadata.getAnnotationAttributes(QueryCreatorType.class.getName());
        if (queryCreatorFoo == null) {
            return AerospikeQueryCreator.class;
        }
        AnnotationAttributes queryCreatorAttributes = new AnnotationAttributes(queryCreatorFoo);
        return queryCreatorAttributes.getClass("value");
    }

    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("template", attributes.getString(AEROSPIKE_TEMPLATE_BEAN_REF_ATTRIBUTE));
        builder.addPropertyValue("queryCreator", BaseAerospikeRepositoryConfigurationExtension.getQueryCreatorType(config));
        builder.addPropertyReference("mappingContext", MAPPING_CONTEXT_BEAN_NAME);
    }
}

