/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.AerospikeOperations;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;

public class AerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final AerospikeOperations operations;

    public AerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, AerospikeTemplate operations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextProvider, queryCreator, (AerospikeMappingContext)operations.getMappingContext(), operations.getAerospikeConverter());
        this.operations = operations;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = this.getTargetClass(accessor);
        if (parameters != null && parameters.length > 0) {
            Qualifier criteria = query.getCriteriaObject();
            if (criteria.hasSingleId()) {
                List<Object> ids = TemplateUtils.getIdValue(criteria);
                return this.operations.findByIdsUsingQuery(ids, this.entityClass, targetClass, null);
            }
            Qualifier idQualifier = QualifierUtils.getIdQualifier(criteria);
            if (idQualifier != null) {
                List<Object> ids = TemplateUtils.getIdValue(idQualifier);
                return this.operations.findByIdsUsingQuery(ids, this.entityClass, targetClass, new Query(TemplateUtils.excludeIdQualifier(criteria)));
            }
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            return this.processPaginatedQuery(targetClass, accessor.getPageable(), query);
        }
        if (this.queryMethod.isStreamQuery()) {
            return this.findByQuery(query, targetClass);
        }
        if (this.queryMethod.isCollectionQuery()) {
            return this.findByQuery(query, targetClass).collect(Collectors.toList());
        }
        if (this.queryMethod.isQueryForEntity()) {
            Stream<?> result = this.findByQuery(query, targetClass);
            return result.findFirst().orElse(null);
        }
        throw new UnsupportedOperationException("Query method " + this.queryMethod.getNamedQueryName() + " is not supported");
    }

    private Object processPaginatedQuery(Class<?> targetClass, Pageable pageable, Query query) {
        Stream<?> unprocessedResultsStream = this.operations.findUsingQueryWithoutPostProcessing(this.entityClass, targetClass, query);
        if (this.queryMethod.isSliceQuery()) {
            return this.processSliceQuery(unprocessedResultsStream, pageable, query);
        }
        return this.processPageQuery(unprocessedResultsStream, pageable, query);
    }

    private Object processSliceQuery(Stream<?> unprocessedResultsStream, Pageable pageable, Query query) {
        if (pageable.isUnpaged()) {
            return new SliceImpl(unprocessedResultsStream.toList(), pageable, false);
        }
        Query modifiedQuery = query.limit(pageable.getPageSize() + 1);
        List modifiedResults = this.applyPostProcessing(unprocessedResultsStream, modifiedQuery).collect(Collectors.toList());
        boolean hasNext = modifiedResults.size() > pageable.getPageSize();
        return new SliceImpl(hasNext ? modifiedResults.subList(0, pageable.getPageSize()) : modifiedResults, pageable, hasNext);
    }

    private Object processPageQuery(Stream<?> unprocessedResultsStream, Pageable pageable, Query query) {
        List<?> resultsPage;
        long numberOfAllResults;
        if (this.operations.getQueryMaxRecords() > 0L) {
            List<?> unprocessedResults = unprocessedResultsStream.toList();
            numberOfAllResults = unprocessedResults.size();
            resultsPage = pageable.isUnpaged() ? unprocessedResults : this.applyPostProcessing(unprocessedResults.stream(), query).toList();
        } else {
            numberOfAllResults = this.operations.count(query, this.entityClass);
            resultsPage = pageable.isUnpaged() ? unprocessedResultsStream.toList() : this.applyPostProcessing(unprocessedResultsStream, query).toList();
        }
        return new PageImpl(resultsPage, pageable, numberOfAllResults);
    }

    private Stream<?> findByQuery(Query query, Class<?> targetClass) {
        if (targetClass != null && targetClass != this.entityClass) {
            return this.operations.find(query, this.entityClass, targetClass);
        }
        return this.operations.find(query, this.entityClass);
    }
}

