/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.QueryParam;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.CollectionQueryCreator;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.aerospike.repository.query.IdQueryCreator;
import org.springframework.data.aerospike.repository.query.MapQueryCreator;
import org.springframework.data.aerospike.repository.query.PojoQueryCreator;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.repository.query.SimplePropertyQueryCreator;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.util.StringUtils;

public class AerospikeQueryCreator
extends AbstractQueryCreator<Query, CriteriaDefinition> {
    private static final Logger LOG = LoggerFactory.getLogger(AerospikeQueryCreator.class);
    private final AerospikeMappingContext context;
    private final MappingAerospikeConverter converter;
    private final boolean isCombinedQuery;

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters, AerospikeMappingContext context, MappingAerospikeConverter converter) {
        super(tree, parameters);
        this.context = context;
        this.converter = converter;
        this.isCombinedQuery = tree.getParts().toList().size() > 1;
    }

    protected CriteriaDefinition and(Part part, CriteriaDefinition base, Iterator<Object> iterator) {
        Object criteriaDefinition = this.create(part, (Iterator)iterator);
        if (base == null) {
            return criteriaDefinition;
        }
        return Qualifier.and(base.getCriteriaObject(), criteriaDefinition.getCriteriaObject());
    }

    protected CriteriaDefinition or(CriteriaDefinition base, CriteriaDefinition criteria) {
        return Qualifier.or(base.getCriteriaObject(), criteria.getCriteriaObject());
    }

    protected Query complete(CriteriaDefinition criteria, Sort sort) {
        Query query;
        Query query2 = query = criteria == null ? null : new Query(criteria).with(sort);
        if (LOG.isDebugEnabled() && criteria != null) {
            this.logQualifierDetails(criteria);
        }
        return query;
    }

    protected CriteriaDefinition create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        Iterator<Object> paramIterator = iterator;
        if (this.isCombinedQuery && iterator.hasNext()) {
            Object nextParam = iterator.next();
            if (!(nextParam instanceof QueryParam)) {
                throw new IllegalArgumentException(String.format("%s: expected CombinedQueryParam, instead got %s", part.getProperty(), nextParam.getClass().getSimpleName()));
            }
            paramIterator = Arrays.stream(((QueryParam)nextParam).arguments()).iterator();
        }
        return this.create(part, property, paramIterator);
    }

    private CriteriaDefinition create(Part part, AerospikePersistentProperty property, Iterator<?> parameters) {
        List<Object> queryParameters = this.getQueryParameters(parameters);
        FilterOperation filterOperation = this.getFilterOperation(part.getType());
        IAerospikeQueryCreator queryCreator = this.getQueryCreator(part, property, queryParameters, filterOperation);
        queryCreator.validate();
        return queryCreator.process();
    }

    private IAerospikeQueryCreator getQueryCreator(Part part, AerospikePersistentProperty property, List<Object> queryParameters, FilterOperation filterOperation) {
        PropertyPath nestedProperty;
        String fieldName = AerospikeQueryCreatorUtils.getFieldName(part.getProperty().getSegment(), property);
        IAerospikeQueryCreator queryCreator = property.isIdProperty() ? new IdQueryCreator(queryParameters) : (property.isCollectionLike() ? new CollectionQueryCreator(part, property, fieldName, queryParameters, filterOperation, this.converter) : (property.isMap() ? new MapQueryCreator(part, property, fieldName, queryParameters, filterOperation, this.converter) : (part.getProperty().hasNext() ? (AerospikeQueryCreatorUtils.isPojo((nestedProperty = AerospikeQueryCreatorUtils.getNestedPropertyPath(part.getProperty())).getType()) ? new PojoQueryCreator(part, nestedProperty, property, fieldName, queryParameters, filterOperation, this.converter, true) : new SimplePropertyQueryCreator(part, nestedProperty, property, fieldName, queryParameters, filterOperation, this.converter, true)) : (AerospikeQueryCreatorUtils.isPojo(part.getProperty().getType()) ? new PojoQueryCreator(part, part.getProperty(), property, fieldName, queryParameters, filterOperation, this.converter, false) : new SimplePropertyQueryCreator(part, part.getProperty(), property, fieldName, queryParameters, filterOperation, this.converter, false)))));
        return queryCreator;
    }

    private FilterOperation getFilterOperation(Part.Type type) {
        return switch (type) {
            case Part.Type.AFTER, Part.Type.GREATER_THAN -> FilterOperation.GT;
            case Part.Type.GREATER_THAN_EQUAL -> FilterOperation.GTEQ;
            case Part.Type.BEFORE, Part.Type.LESS_THAN -> FilterOperation.LT;
            case Part.Type.LESS_THAN_EQUAL -> FilterOperation.LTEQ;
            case Part.Type.BETWEEN -> FilterOperation.BETWEEN;
            case Part.Type.LIKE, Part.Type.REGEX -> FilterOperation.LIKE;
            case Part.Type.STARTING_WITH -> FilterOperation.STARTS_WITH;
            case Part.Type.ENDING_WITH -> FilterOperation.ENDS_WITH;
            case Part.Type.CONTAINING -> FilterOperation.CONTAINING;
            case Part.Type.NOT_CONTAINING -> FilterOperation.NOT_CONTAINING;
            case Part.Type.WITHIN -> FilterOperation.GEO_WITHIN;
            case Part.Type.SIMPLE_PROPERTY, Part.Type.TRUE, Part.Type.FALSE -> FilterOperation.EQ;
            case Part.Type.NEGATING_SIMPLE_PROPERTY -> FilterOperation.NOTEQ;
            case Part.Type.IN -> FilterOperation.IN;
            case Part.Type.NOT_IN -> FilterOperation.NOT_IN;
            case Part.Type.EXISTS, Part.Type.IS_NOT_NULL -> FilterOperation.IS_NOT_NULL;
            case Part.Type.IS_NULL -> FilterOperation.IS_NULL;
            default -> throw new IllegalArgumentException(String.format("Unsupported keyword '%s'", type));
        };
    }

    private List<Object> getQueryParameters(Iterator<?> parametersIterator) {
        ArrayList params = new ArrayList();
        parametersIterator.forEachRemaining(param -> params.add(AerospikeQueryCreatorUtils.convertIfNecessary(param, this.converter)));
        return params.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }

    private void logQualifierDetails(CriteriaDefinition criteria) {
        Qualifier qualifier = criteria.getCriteriaObject();
        Qualifier[] qualifiers = qualifier.getQualifiers();
        if (qualifiers != null && qualifiers.length > 0) {
            Arrays.stream(qualifiers).forEach(this::logQualifierDetails);
        }
        String field = StringUtils.hasLength((String)qualifier.getField()) ? qualifier.getField() : "";
        String operation = qualifier.getOperation().toString();
        operation = StringUtils.hasLength((String)operation) ? operation : "N/A";
        Value k = qualifier.getKey();
        String key = this.printValue(k);
        Value val = qualifier.getValue();
        String value = this.printValue(val);
        Value val2 = qualifier.getSecondValue();
        String value2 = this.printValue(val2);
        LOG.debug("Created query: field = {}, operation = {}, key = {}, value = {}, value2 = {}", new Object[]{field, operation, key, value, value2});
    }

    private String printValue(Value value) {
        if (value != null && StringUtils.hasLength((String)value.toString())) {
            return value.toString();
        }
        return value == Value.getAsNull() ? "null" : "";
    }
}

