/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.List;
import java.util.TreeMap;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.Field;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierBuilder;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.utility.Utils;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AerospikeQueryCreatorUtils {
    protected static Qualifier setQualifier(MappingAerospikeConverter converter, QualifierBuilder qb, String fieldName, FilterOperation op, Part part, List<String> dotPath) {
        ((QualifierBuilder)qb.setField(fieldName).setFilterOperation(op)).setIgnoreCase(AerospikeQueryCreatorUtils.ignoreCaseToBoolean(part)).setConverter(converter);
        if (dotPath != null && !qb.hasDotPath()) {
            qb.setDotPath(dotPath);
        }
        return qb.build();
    }

    protected static Object convertNullParameter(Object value) {
        return value == CriteriaDefinition.AerospikeNullQueryCriterion.NULL_PARAM ? Value.getAsNull() : value;
    }

    protected static boolean ignoreCaseToBoolean(Part part) {
        return switch (part.shouldIgnoreCase()) {
            case Part.IgnoreCaseType.WHEN_POSSIBLE -> {
                if (part.getProperty().getType() == String.class) {
                    yield true;
                }
                yield false;
            }
            case Part.IgnoreCaseType.ALWAYS -> true;
            default -> false;
        };
    }

    protected static PropertyPath getNestedPropertyPath(PropertyPath propertyPath) {
        PropertyPath result = null;
        for (PropertyPath current = propertyPath; current != null; current = current.next()) {
            result = current;
        }
        return result;
    }

    protected static Class<?> getCollectionElementsClass(PropertyPath property) {
        if (property.getTypeInformation().getComponentType() == null) {
            return null;
        }
        return property.getTypeInformation().getComponentType().getType();
    }

    protected static Qualifier qualifierAndConcatenated(MappingAerospikeConverter converter, List<Object> params, QualifierBuilder qb, Part part, String fieldName, FilterOperation op, List<String> dotPath) {
        return AerospikeQueryCreatorUtils.qualifierAndConcatenated(converter, params, qb, part, fieldName, op, dotPath, false);
    }

    protected static Qualifier qualifierAndConcatenated(MappingAerospikeConverter converter, List<Object> params, QualifierBuilder qb, Part part, String fieldName, FilterOperation op, List<String> dotPath, boolean containingMapKeyValuePairs) {
        int i;
        Qualifier[] qualifiers;
        if (containingMapKeyValuePairs) {
            qualifiers = new Qualifier[params.size() / 2];
            i = 0;
            int j = 0;
            while (i < params.size()) {
                AerospikeQueryCreatorUtils.setQbValuesForMapByKey(qb, params.get(i), params.get(i + 1));
                qualifiers[j] = AerospikeQueryCreatorUtils.setQualifier(converter, qb, fieldName, op, part, dotPath);
                i += 2;
                ++j;
            }
        }
        qualifiers = new Qualifier[params.size()];
        for (i = 0; i < params.size(); ++i) {
            AerospikeQueryCreatorUtils.setQbValuesForMapByKey(qb, params.get(i), params.get(i));
            qualifiers[i] = AerospikeQueryCreatorUtils.setQualifier(converter, qb, fieldName, op, part, dotPath);
        }
        return Qualifier.and(qualifiers);
    }

    protected static String getFieldName(String segmentName, AerospikePersistentProperty property) {
        Field annotation = (Field)property.findAnnotation(Field.class);
        if (annotation != null && StringUtils.hasText((String)annotation.value())) {
            return annotation.value();
        }
        if (!StringUtils.hasText((String)segmentName)) {
            throw new IllegalStateException("Segment name is null or empty");
        }
        return segmentName;
    }

    protected static void setQbValuesForMapByKey(QualifierBuilder qb, Object key, Object value) {
        qb.setKey(Value.get((Object)value));
        qb.setValue(Value.get((Object)key));
    }

    protected static Object convertIfNecessary(Object obj, MappingAerospikeConverter converter) {
        if (obj == null || obj instanceof CriteriaDefinition.AerospikeQueryCriterion || obj instanceof CriteriaDefinition.AerospikeNullQueryCriterion) {
            return obj;
        }
        TypeInformation valueType = TypeInformation.of(obj.getClass());
        return converter.toWritableValue(obj, valueType);
    }

    protected static Value getValueOfQueryParameter(Object queryParameter) {
        return Value.get((Object)AerospikeQueryCreatorUtils.convertNullParameter(queryParameter));
    }

    protected static void setQualifierBuilderKey(QualifierBuilder qb, Object key) {
        qb.setKey(AerospikeQueryCreatorUtils.getValueOfQueryParameter(key));
    }

    protected static void setQualifierBuilderValue(QualifierBuilder qb, Object value) {
        qb.setValue(AerospikeQueryCreatorUtils.getValueOfQueryParameter(value));
    }

    protected static void setQualifierBuilderSecondValue(QualifierBuilder qb, Object value) {
        qb.setSecondValue(AerospikeQueryCreatorUtils.getValueOfQueryParameter(value));
    }

    protected static FilterOperation getCorrespondingMapValueFilterOperationOrFail(FilterOperation op) {
        try {
            return FilterOperation.valueOf("MAP_VAL_" + String.valueOf((Object)op) + "_BY_KEY");
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find corresponding MAP_VAL_..._BY_KEY FilterOperation for '" + String.valueOf((Object)op) + "'");
        }
    }

    protected static boolean isPojo(Class<?> clazz) {
        TypeInformation type = TypeInformation.of(clazz);
        return !Utils.isSimpleValueType(clazz) && !type.isCollectionLike();
    }

    protected static void validateTypes(MappingAerospikeConverter converter, PropertyPath property, FilterOperation op, List<Object> queryParameters) {
        String queryPartDescription = String.join((CharSequence)" ", property.toString(), op.toString());
        AerospikeQueryCreatorUtils.validateTypes(converter, property, queryParameters, queryPartDescription);
    }

    protected static void validateTypes(MappingAerospikeConverter converter, PropertyPath property, List<Object> queryParameters, String queryPartDescription) {
        AerospikeQueryCreatorUtils.validateTypes(converter, property.getTypeInformation().getType(), queryParameters, queryPartDescription, new String[0]);
    }

    protected static void validateTypes(MappingAerospikeConverter converter, Class<?> propertyType, List<Object> queryParameters, String queryPartDescription, String ... alternativeTypes) {
        if (ClassUtils.isAssignable(Number.class, propertyType) && ClassUtils.isAssignableValue(Number.class, (Object)queryParameters.get(0))) {
            propertyType = Number.class;
        }
        Class<?> clazz = propertyType;
        if (!queryParameters.stream().allMatch(param -> AerospikeQueryCreatorUtils.isAssignableValueOrConverted(clazz, param, converter))) {
            String validTypes = propertyType.getSimpleName();
            if (alternativeTypes.length > 0) {
                validTypes = String.format("one of the following types: %s", propertyType.getSimpleName() + ", " + String.join((CharSequence)", ", alternativeTypes));
            }
            throw new IllegalArgumentException(String.format("%s: Type mismatch, expecting %s", queryPartDescription, validTypes));
        }
    }

    protected static boolean isAssignableValueOrConverted(Class<?> propertyType, Object obj, MappingAerospikeConverter converter) {
        return ClassUtils.isAssignableValue(propertyType, (Object)obj) || converter.getCustomConversions().hasCustomReadTarget(obj.getClass(), propertyType) || AerospikeQueryCreatorUtils.isPojoMap(obj, propertyType);
    }

    protected static boolean isPojoMap(Object object, Class<?> propertyType) {
        if (object instanceof TreeMap) {
            TreeMap treeMap = (TreeMap)object;
            Object classKey = treeMap.get("@_class");
            return classKey != null && classKey.equals(propertyType.getName());
        }
        return false;
    }
}

