/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.lang.reflect.Constructor;
import java.util.Comparator;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.support.PropertyComparator;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.PartTree;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.spel.standard.SpelExpression;
import org.springframework.util.ClassUtils;

public abstract class BaseAerospikePartTreeQuery
implements RepositoryQuery {
    protected final QueryMethod queryMethod;
    protected final Class<?> entityClass;
    private final QueryMethodEvaluationContextProvider evaluationContextProvider;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;
    private final AerospikeMappingContext context;
    private final MappingAerospikeConverter converter;

    protected BaseAerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, Class<? extends AbstractQueryCreator<?, ?>> queryCreator, AerospikeMappingContext context, MappingAerospikeConverter converter) {
        this.queryMethod = queryMethod;
        this.evaluationContextProvider = evalContextProvider;
        this.queryCreator = queryCreator;
        this.entityClass = queryMethod.getEntityInformation().getJavaType();
        this.context = context;
        this.converter = converter;
    }

    public QueryMethod getQueryMethod() {
        return this.queryMethod;
    }

    protected Query prepareQuery(Object[] parameters, ParametersParameterAccessor accessor) {
        PartTree tree = new PartTree(this.queryMethod.getName(), this.entityClass);
        Query baseQuery = this.createQuery(accessor, tree);
        Qualifier criteria = baseQuery.getCriteriaObject();
        Query query = new Query(criteria);
        if (accessor.getPageable().isPaged()) {
            query.setOffset(accessor.getPageable().getOffset());
            query.setRows(accessor.getPageable().getPageSize());
        } else if (tree.isLimiting()) {
            query.limit(tree.getMaxResults());
        } else {
            query.setOffset(-1L);
            query.setRows(-1);
        }
        query.setDistinct(tree.isDistinct());
        if (accessor.getSort().isSorted()) {
            query.setSort(accessor.getSort());
        } else {
            query.setSort(baseQuery.getSort());
        }
        CriteriaDefinition criteriaDefinition = query.getCriteria();
        if (criteriaDefinition instanceof SpelExpression) {
            SpelExpression spelExpression = (SpelExpression)criteriaDefinition;
            EvaluationContext context = this.evaluationContextProvider.getEvaluationContext(this.queryMethod.getParameters(), parameters);
            spelExpression.setEvaluationContext(context);
        }
        return query;
    }

    Class<?> getTargetClass(ParametersParameterAccessor accessor) {
        if (accessor.getParameters().hasDynamicProjection()) {
            return accessor.findDynamicProjection();
        }
        if (this.queryMethod.getReturnedObjectType() != this.queryMethod.getEntityInformation().getJavaType()) {
            return this.queryMethod.getReturnedObjectType();
        }
        return this.queryMethod.getEntityInformation().getJavaType();
    }

    public Query createQuery(ParametersParameterAccessor accessor, PartTree tree) {
        Constructor constructor = ClassUtils.getConstructorIfAvailable(this.queryCreator, (Class[])new Class[]{PartTree.class, ParameterAccessor.class, AerospikeMappingContext.class, MappingAerospikeConverter.class});
        return (Query)((AbstractQueryCreator)BeanUtils.instantiateClass((Constructor)constructor, (Object[])new Object[]{tree, accessor, this.context, this.converter})).createQuery();
    }

    protected <T> Stream<T> applyPostProcessing(Stream<T> results, Query query) {
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator<T> comparator = this.getComparator(query);
            results = results.sorted(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.limit(query.getRows());
        }
        return results;
    }

    protected <T> Comparator<T> getComparator(Query query) {
        return query.getSort().stream().map(this::getPropertyComparator).reduce(Comparator::thenComparing).orElseThrow(() -> new IllegalStateException("Comparator can not be created if sort orders are empty"));
    }

    private <T> Comparator<T> getPropertyComparator(Sort.Order order) {
        boolean ignoreCase = true;
        boolean ascending = order.getDirection().isAscending();
        return new PropertyComparator(order.getProperty(), ignoreCase, ascending);
    }
}

