/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.Collection;
import java.util.List;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierBuilder;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;

public class CollectionQueryCreator
implements IAerospikeQueryCreator {
    private final Part part;
    private final AerospikePersistentProperty property;
    private final String fieldName;
    private final List<Object> queryParameters;
    private final FilterOperation filterOperation;
    private final MappingAerospikeConverter converter;

    public CollectionQueryCreator(Part part, AerospikePersistentProperty property, String fieldName, List<Object> queryParameters, FilterOperation filterOperation, MappingAerospikeConverter converter) {
        this.part = part;
        this.property = property;
        this.fieldName = fieldName;
        this.queryParameters = queryParameters;
        this.filterOperation = filterOperation;
        this.converter = converter;
    }

    @Override
    public void validate() {
        String queryPartDescription = String.join((CharSequence)" ", this.part.getProperty().toString(), this.filterOperation.toString());
        switch (this.filterOperation) {
            case CONTAINING: 
            case NOT_CONTAINING: {
                this.validateCollectionQueryContaining(this.queryParameters, queryPartDescription);
                break;
            }
            case EQ: 
            case NOTEQ: 
            case GT: 
            case GTEQ: 
            case LT: 
            case LTEQ: {
                this.validateCollectionQueryComparison(this.queryParameters, queryPartDescription);
                break;
            }
            case BETWEEN: {
                this.validateCollectionQueryBetween(this.queryParameters, queryPartDescription);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported operation: %s applied to %s", new Object[]{this.filterOperation, this.property}));
            }
        }
    }

    private void validateCollectionQueryContaining(List<Object> queryParameters, String queryPartDescription) {
        if (queryParameters.size() != 1) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one");
        }
        this.validateCollectionContainingTypes(this.part.getProperty(), queryParameters, queryPartDescription);
    }

    private void validateCollectionQueryComparison(List<Object> queryParameters, String queryPartDescription) {
        if (queryParameters.size() != 1) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one");
        }
        if (!(queryParameters.get(0) instanceof Collection)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid argument type, expecting Collection");
        }
        AerospikeQueryCreatorUtils.validateTypes(this.converter, Collection.class, queryParameters, queryPartDescription, new String[0]);
    }

    private void validateCollectionQueryBetween(List<Object> queryParameters, String queryPartDescription) {
        if (queryParameters.size() != 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
        }
        Object value = queryParameters.get(0);
        if (!(value instanceof Collection)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid argument type, expecting Collection");
        }
        AerospikeQueryCreatorUtils.validateTypes(this.converter, Collection.class, queryParameters, queryPartDescription, new String[0]);
        if (!value.getClass().equals(queryParameters.get(1).getClass())) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid arguments type, expecting both to be of the same class");
        }
    }

    private void validateCollectionContainingTypes(PropertyPath property, List<Object> queryParameters, String queryPartDescription) {
        Class<?> componentsClass;
        Object value = queryParameters.get(0);
        if (value instanceof Collection) {
            AerospikeQueryCreatorUtils.validateTypes(this.converter, Collection.class, queryParameters, queryPartDescription, new String[0]);
        } else if (!(value instanceof CriteriaDefinition.AerospikeNullQueryCriterion) && (componentsClass = AerospikeQueryCreatorUtils.getCollectionElementsClass(property)) != null) {
            AerospikeQueryCreatorUtils.validateTypes(this.converter, componentsClass, queryParameters, queryPartDescription, "Collection");
        }
    }

    @Override
    public Qualifier process() {
        QualifierBuilder qb = Qualifier.builder();
        FilterOperation op = this.filterOperation;
        if (this.filterOperation == FilterOperation.BETWEEN || this.filterOperation == FilterOperation.IN || this.filterOperation == FilterOperation.NOT_IN) {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
            if (this.queryParameters.size() >= 2) {
                AerospikeQueryCreatorUtils.setQualifierBuilderSecondValue(qb, this.queryParameters.get(1));
            }
        }
        if (!(this.queryParameters.get(0) instanceof Collection)) {
            op = this.getCorrespondingListFilterOperationOrFail(op);
        }
        AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
        return AerospikeQueryCreatorUtils.setQualifier(this.converter, qb, this.fieldName, op, this.part, null);
    }

    private FilterOperation getCorrespondingListFilterOperationOrFail(FilterOperation op) {
        try {
            return FilterOperation.valueOf("COLLECTION_VAL_" + String.valueOf((Object)op));
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot find corresponding COLLECTION_VAL_... FilterOperation for '" + String.valueOf((Object)op) + "'");
        }
    }
}

