/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.List;
import java.util.Map;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierBuilder;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.TypeInformation;

public class MapQueryCreator
implements IAerospikeQueryCreator {
    private final Part part;
    private final AerospikePersistentProperty property;
    private final String fieldName;
    private final List<Object> queryParameters;
    private final FilterOperation filterOperation;
    private final MappingAerospikeConverter converter;

    public MapQueryCreator(Part part, AerospikePersistentProperty property, String fieldName, List<Object> queryParameters, FilterOperation filterOperation, MappingAerospikeConverter converter) {
        this.part = part;
        this.property = property;
        this.fieldName = fieldName;
        this.queryParameters = queryParameters;
        this.filterOperation = filterOperation;
        this.converter = converter;
    }

    @Override
    public void validate() {
        String queryPartDescription = String.join((CharSequence)" ", this.part.getProperty().toString(), this.filterOperation.toString());
        switch (this.filterOperation) {
            case CONTAINING: 
            case NOT_CONTAINING: {
                this.validateMapQueryContaining(queryPartDescription);
                break;
            }
            case EQ: 
            case NOTEQ: 
            case GT: 
            case GTEQ: 
            case LT: 
            case LTEQ: {
                this.validateMapQueryComparison(queryPartDescription);
                break;
            }
            case BETWEEN: {
                this.validateMapQueryBetween(queryPartDescription);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported operation: %s applied to %s", new Object[]{this.filterOperation, this.property}));
            }
        }
    }

    private void validateMapQueryContaining(String queryPartDescription) {
        if (this.queryParameters.size() < 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, at least two arguments are required");
        }
        Object param1 = this.queryParameters.get(0);
        if (!(param1 instanceof CriteriaDefinition.AerospikeQueryCriterion)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid first argument type, required AerospikeQueryCriterion");
        }
        Object param2 = this.queryParameters.get(1);
        switch ((CriteriaDefinition.AerospikeQueryCriterion)((Object)param1)) {
            case KEY: {
                if (this.queryParameters.size() != 2) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
                }
                if (this.isValidMapKeyTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param2)) break;
                throw new IllegalArgumentException(queryPartDescription + ": invalid map key type at position 2");
            }
            case VALUE: {
                if (this.queryParameters.size() != 2) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
                }
                if (this.isValidMapValueTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param2)) break;
                throw new IllegalArgumentException(queryPartDescription + ": invalid map value type at position 2");
            }
            case KEY_VALUE_PAIR: {
                if (this.queryParameters.size() != 3) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting three");
                }
                if (!this.isValidMapKeyTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param2)) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid map key type at position 2");
                }
                Object param3 = this.queryParameters.get(2);
                if (this.isValidMapValueTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param3)) break;
                throw new IllegalArgumentException(queryPartDescription + ": invalid map value type at position 3");
            }
            default: {
                throw new IllegalStateException(queryPartDescription + ": invalid AerospikeQueryCriterion type of the first argument, expecting KEY, VALUE or KEY_VALUE_PAIR");
            }
        }
    }

    private boolean isValidMapKeyTypeOrUnresolved(TypeInformation<?> typeInformation, Object param) {
        Class mapKeyClass;
        try {
            if (typeInformation.getComponentType() == null) {
                return true;
            }
            mapKeyClass = typeInformation.getComponentType().getType();
        }
        catch (IllegalStateException e) {
            mapKeyClass = null;
        }
        return mapKeyClass == null || AerospikeQueryCreatorUtils.isAssignableValueOrConverted(mapKeyClass, param, this.converter);
    }

    private boolean isValidMapValueTypeOrUnresolved(TypeInformation<?> typeInformation, Object param) {
        Class mapValueClass;
        try {
            if (typeInformation.getRequiredMapValueType() == null) {
                return true;
            }
            mapValueClass = typeInformation.getRequiredMapValueType().getType();
        }
        catch (IllegalStateException e) {
            mapValueClass = null;
        }
        return mapValueClass == null || AerospikeQueryCreatorUtils.isAssignableValueOrConverted(mapValueClass, param, this.converter) || param == CriteriaDefinition.AerospikeNullQueryCriterion.NULL_PARAM;
    }

    private void validateMapQueryComparison(String queryPartDescription) {
        if (this.queryParameters.size() != 1) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one");
        }
        if (!(this.queryParameters.get(0) instanceof Map)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid argument type, expecting Map");
        }
    }

    private void validateMapQueryBetween(String queryPartDescription) {
        if (this.queryParameters.size() != 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
        }
        Object value = this.queryParameters.get(0);
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid argument type, expecting Map");
        }
        if (!value.getClass().equals(this.queryParameters.get(1).getClass())) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid arguments type, expecting both to be of the same class");
        }
    }

    @Override
    public Qualifier process() {
        Qualifier qualifier = null;
        QualifierBuilder qb = Qualifier.builder();
        int paramsSize = this.queryParameters.size();
        if (this.filterOperation == FilterOperation.BETWEEN || this.filterOperation == FilterOperation.IN || this.filterOperation == FilterOperation.NOT_IN) {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
            if (this.queryParameters.size() >= 2) {
                AerospikeQueryCreatorUtils.setQualifierBuilderSecondValue(qb, this.queryParameters.get(1));
            }
            qualifier = AerospikeQueryCreatorUtils.setQualifier(this.converter, qb, this.fieldName, this.filterOperation, this.part, null);
            return qualifier;
        }
        if (paramsSize == 2) {
            qualifier = this.processMapTwoParams(this.part, this.queryParameters, this.filterOperation, this.fieldName);
        } else if (this.queryParameters.size() < 2) {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
            qualifier = AerospikeQueryCreatorUtils.setQualifier(this.converter, qb, this.fieldName, this.filterOperation, this.part, null);
        } else {
            qualifier = this.processMapMultipleParams(this.part, this.queryParameters, this.filterOperation, this.fieldName);
        }
        return qualifier;
    }

    private Qualifier processMapTwoParams(Part part, List<Object> params, FilterOperation op, String fieldName) {
        Qualifier qualifier = op == FilterOperation.CONTAINING ? this.processMapContaining(part, fieldName, FilterOperation.MAP_KEYS_CONTAIN, FilterOperation.MAP_VALUES_CONTAIN, FilterOperation.MAP_VAL_EQ_BY_KEY) : (op == FilterOperation.NOT_CONTAINING ? this.processMapContaining(part, fieldName, FilterOperation.MAP_KEYS_NOT_CONTAIN, FilterOperation.MAP_VALUES_NOT_CONTAIN, FilterOperation.MAP_VAL_NOTEQ_BY_KEY) : this.processMapOtherThanContaining(part, params, op, fieldName));
        return qualifier;
    }

    private Qualifier processMapContaining(Part part, String fieldName, FilterOperation keysOp, FilterOperation valuesOp, FilterOperation byKeyOp) {
        FilterOperation op = byKeyOp;
        QualifierBuilder qb = Qualifier.builder();
        Object object = this.queryParameters.get(0);
        if (object instanceof CriteriaDefinition.AerospikeQueryCriterion) {
            CriteriaDefinition.AerospikeQueryCriterion queryCriterion = (CriteriaDefinition.AerospikeQueryCriterion)((Object)object);
            switch (queryCriterion) {
                case KEY: {
                    op = keysOp;
                    AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(1));
                    break;
                }
                case VALUE: {
                    op = valuesOp;
                    AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(1));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported parameter: " + String.valueOf((Object)queryCriterion));
                }
            }
        }
        return AerospikeQueryCreatorUtils.setQualifier(this.converter, qb, fieldName, op, part, null);
    }

    private Qualifier processMapOtherThanContaining(Part part, List<Object> queryParameters, FilterOperation op, String fieldName) {
        QualifierBuilder qb = Qualifier.builder();
        Object param1 = queryParameters.get(0);
        List<String> dotPath = List.of(part.getProperty().toDotPath(), Value.get((Object)param1).toString());
        if (queryParameters.size() == 3) {
            op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(op);
        }
        AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, queryParameters.get(0));
        AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, queryParameters.get(1));
        return AerospikeQueryCreatorUtils.setQualifier(this.converter, qb, fieldName, op, part, dotPath);
    }

    private Qualifier processMapMultipleParams(Part part, List<Object> params, FilterOperation op, String fieldName) {
        if (op == FilterOperation.CONTAINING || op == FilterOperation.NOT_CONTAINING) {
            return this.processMapMultipleParamsContaining(part, params, op, fieldName);
        }
        return this.processMapOtherThanContaining(part, params, op, fieldName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Qualifier processMapMultipleParamsContaining(Part part, List<Object> params, FilterOperation op, String fieldName) {
        QualifierBuilder qb = Qualifier.builder();
        Object firstParam = params.get(0);
        if (!(firstParam instanceof CriteriaDefinition.AerospikeQueryCriterion)) throw new UnsupportedOperationException(String.format("Unsupported combination of operation %s and the first parameter %s", new Object[]{op, firstParam}));
        CriteriaDefinition.AerospikeQueryCriterion queryCriterion = (CriteriaDefinition.AerospikeQueryCriterion)((Object)params.get(0));
        if (queryCriterion != CriteriaDefinition.AerospikeQueryCriterion.KEY_VALUE_PAIR) throw new UnsupportedOperationException("Unsupported parameter: " + String.valueOf((Object)queryCriterion));
        switch (op) {
            case CONTAINING: 
            case EQ: {
                op = FilterOperation.MAP_VAL_EQ_BY_KEY;
                break;
            }
            case NOTEQ: {
                op = FilterOperation.MAP_VAL_NOTEQ_BY_KEY;
                break;
            }
            case NOT_CONTAINING: {
                op = FilterOperation.MAP_VAL_NOT_CONTAINING_BY_KEY;
            }
        }
        Value key = AerospikeQueryCreatorUtils.getValueOfQueryParameter(params.get(1));
        qb.setKey(key);
        List<String> dotPath = List.of(part.getProperty().toDotPath(), key.toString());
        AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(2));
        if (op != FilterOperation.MAP_VAL_CONTAINING_BY_KEY && op != FilterOperation.MAP_VAL_NOT_CONTAINING_BY_KEY && op != FilterOperation.MAP_VAL_EQ_BY_KEY && op != FilterOperation.MAP_VAL_NOTEQ_BY_KEY) return AerospikeQueryCreatorUtils.qualifierAndConcatenated(this.converter, params, qb, part, fieldName, op, dotPath);
        return AerospikeQueryCreatorUtils.setQualifier(this.converter, qb, fieldName, op, part, dotPath);
    }
}

