/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Stream;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.core.ReactiveAerospikeTemplate;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.BaseAerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.SliceImpl;
import org.springframework.data.repository.query.ParametersParameterAccessor;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodEvaluationContextProvider;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikePartTreeQuery
extends BaseAerospikePartTreeQuery {
    private final ReactiveAerospikeOperations operations;

    public ReactiveAerospikePartTreeQuery(QueryMethod queryMethod, QueryMethodEvaluationContextProvider evalContextProvider, ReactiveAerospikeTemplate operations, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        super(queryMethod, evalContextProvider, queryCreator, (AerospikeMappingContext)operations.getMappingContext(), operations.getAerospikeConverter());
        this.operations = operations;
    }

    public Object execute(Object[] parameters) {
        ParametersParameterAccessor accessor = new ParametersParameterAccessor(this.queryMethod.getParameters(), parameters);
        Query query = this.prepareQuery(parameters, accessor);
        Class<?> targetClass = this.getTargetClass(accessor);
        if (parameters != null && parameters.length > 0) {
            Qualifier criteria = query.getCriteriaObject();
            if (criteria.hasSingleId()) {
                List<Object> ids = TemplateUtils.getIdValue(criteria);
                return this.operations.findByIdsUsingQuery(ids, this.entityClass, targetClass, null);
            }
            Qualifier idQualifier = QualifierUtils.getIdQualifier(criteria);
            if (idQualifier != null) {
                List<Object> ids = TemplateUtils.getIdValue(idQualifier);
                return this.operations.findByIdsUsingQuery(ids, this.entityClass, targetClass, new Query(TemplateUtils.excludeIdQualifier(criteria)));
            }
        }
        if (this.queryMethod.isPageQuery() || this.queryMethod.isSliceQuery()) {
            Pageable pageable = accessor.getPageable();
            Flux<?> unprocessedResults = this.operations.findUsingQueryWithoutPostProcessing(this.entityClass, targetClass, query);
            Mono sizeMono = unprocessedResults.count();
            if (this.operations.getQueryMaxRecords() > 0L) {
                Mono unprocessedResultsListMono = unprocessedResults.collectList();
                return sizeMono.flatMap(size -> unprocessedResultsListMono.map(list -> this.getPage((List<?>)list, (long)size, pageable, query)));
            }
            return sizeMono.map(size -> {
                if (pageable.isUnpaged()) {
                    Mono unprocessedResultsListMono = unprocessedResults.collectList();
                    return unprocessedResultsListMono.map(list -> this.getPage((List<?>)list, (long)size, pageable, query));
                }
                return this.getPage(unprocessedResults, (long)size, pageable, query);
            });
        }
        return this.findByQuery(query, targetClass);
    }

    public Object getPage(List<?> unprocessedResults, long overallSize, Pageable pageable, Query query) {
        if (this.queryMethod.isSliceQuery()) {
            return this.processSliceQuery(unprocessedResults, overallSize, pageable, query);
        }
        return this.processPageQuery(unprocessedResults, overallSize, pageable, query);
    }

    public Object getPage(Flux<?> unprocessedResults, long overallSize, Pageable pageable, Query query) {
        if (this.queryMethod.isSliceQuery()) {
            List<?> resultsPaginated = this.applyPostProcessing(unprocessedResults, query).toList();
            boolean hasNext = overallSize > (long)pageable.getPageSize() * (pageable.getOffset() + 1L);
            return new SliceImpl(resultsPaginated, pageable, hasNext);
        }
        List<?> resultsPaginated = this.applyPostProcessing(unprocessedResults, query).toList();
        return new PageImpl(resultsPaginated, pageable, overallSize);
    }

    private Object processSliceQuery(List<?> unprocessedResults, long overallSize, Pageable pageable, Query query) {
        if (pageable.isUnpaged()) {
            return new SliceImpl(unprocessedResults, pageable, false);
        }
        List resultsPaginated = ((BaseAerospikePartTreeQuery)this).applyPostProcessing(unprocessedResults.stream(), query).toList();
        boolean hasNext = overallSize > (long)pageable.getPageSize() * (pageable.getOffset() + 1L);
        return new SliceImpl(resultsPaginated, pageable, hasNext);
    }

    private Object processPageQuery(List<?> unprocessedResults, long overallSize, Pageable pageable, Query query) {
        if (pageable.isUnpaged()) {
            return new PageImpl(unprocessedResults, pageable, overallSize);
        }
        List resultsPaginated = ((BaseAerospikePartTreeQuery)this).applyPostProcessing(unprocessedResults.stream(), query).toList();
        return new PageImpl(resultsPaginated, pageable, overallSize);
    }

    protected <T> Stream<T> applyPostProcessing(Flux<T> results, Query query) {
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = this.getComparator(query);
            results = results.sort(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.take((long)query.getRows());
        }
        return results.toStream();
    }

    private Flux<?> findByQuery(Query query, Class<?> targetClass) {
        if (targetClass != this.entityClass) {
            return this.operations.find(query, this.entityClass, targetClass);
        }
        return this.operations.find(query, this.entityClass);
    }
}

