/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.Collection;
import java.util.List;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierBuilder;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;

public class SimplePropertyQueryCreator
implements IAerospikeQueryCreator {
    private final Part part;
    private final PropertyPath propertyPath;
    private final AerospikePersistentProperty property;
    private final String fieldName;
    private final List<Object> queryParameters;
    private final FilterOperation filterOperation;
    private final MappingAerospikeConverter converter;
    private final boolean isNested;
    private final boolean isBooleanQuery;

    public SimplePropertyQueryCreator(Part part, PropertyPath propertyPath, AerospikePersistentProperty property, String fieldName, List<Object> queryParameters, FilterOperation filterOperation, MappingAerospikeConverter converter, boolean isNested) {
        this.part = part;
        this.isBooleanQuery = part.getType() == Part.Type.FALSE || part.getType() == Part.Type.TRUE;
        this.propertyPath = propertyPath;
        this.property = property;
        this.fieldName = fieldName;
        this.queryParameters = queryParameters;
        this.filterOperation = filterOperation;
        this.converter = converter;
        this.isNested = isNested;
    }

    @Override
    public void validate() {
        String queryPartDescription = String.join((CharSequence)" ", this.propertyPath.toString(), this.filterOperation.toString());
        switch (this.filterOperation) {
            case CONTAINING: 
            case NOT_CONTAINING: 
            case GT: 
            case GTEQ: 
            case LT: 
            case LTEQ: 
            case LIKE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case EQ: 
            case NOTEQ: {
                this.validateSimplePropertyQueryComparison(queryPartDescription, this.queryParameters);
                AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.queryParameters, queryPartDescription);
                break;
            }
            case IN: 
            case NOT_IN: {
                this.validateSimplePropertyQueryComparison(queryPartDescription, this.queryParameters);
                this.validateSimplePropertyInQueryTypes(queryPartDescription, this.queryParameters);
                break;
            }
            case BETWEEN: {
                this.validateSimplePropertyQueryBetween(queryPartDescription, this.queryParameters);
                AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.queryParameters, queryPartDescription);
                break;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                this.validateSimplePropertyQueryIsNull(queryPartDescription, this.queryParameters);
                AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.queryParameters, queryPartDescription);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("Unsupported operation: %s applied to %s", new Object[]{this.filterOperation, this.property}));
            }
        }
    }

    private void validateSimplePropertyQueryComparison(String queryPartDescription, List<Object> queryParameters) {
        int paramsSize = queryParameters.size();
        if (paramsSize != 1 && !this.isBooleanQuery) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one");
        }
        if (this.isBooleanQuery && paramsSize != 0) {
            throw new IllegalArgumentException(queryPartDescription + ": no arguments expected");
        }
    }

    private void validateSimplePropertyInQueryTypes(String queryPartDescription, List<Object> queryParameters) {
        Object param1 = queryParameters.get(0);
        if (param1 instanceof Collection) {
            AerospikeQueryCreatorUtils.validateTypes(this.converter, Collection.class, queryParameters, queryPartDescription, new String[0]);
        }
    }

    private void validateSimplePropertyQueryBetween(String queryPartDescription, List<Object> queryParameters) {
        if (queryParameters.size() != 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
        }
    }

    private void validateSimplePropertyQueryIsNull(String queryPartDescription, List<Object> queryParameters) {
        if (!queryParameters.isEmpty()) {
            throw new IllegalArgumentException(queryPartDescription + ": expecting no arguments");
        }
    }

    @Override
    public Qualifier process() {
        List<String> dotPath = null;
        QualifierBuilder qb = Qualifier.builder();
        if (this.isBooleanQuery) {
            this.queryParameters.add(Value.get((boolean)this.convertPartTypeToBoolean(this.part.getType())));
        }
        if (this.filterOperation == FilterOperation.BETWEEN) {
            AerospikeQueryCreatorUtils.setQualifierBuilderSecondValue(qb, this.queryParameters.get(1));
        }
        FilterOperation op = this.filterOperation;
        if (this.isNested) {
            if (this.filterOperation == FilterOperation.IS_NOT_NULL || this.filterOperation == FilterOperation.IS_NULL) {
                AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.property.getFieldName());
            }
            op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(op);
            if (!this.queryParameters.isEmpty()) {
                AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
            }
            AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, this.property.getFieldName());
            dotPath = List.of(this.part.getProperty().toDotPath());
        } else {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
        }
        return AerospikeQueryCreatorUtils.setQualifier(this.converter, qb, this.fieldName, op, this.part, dotPath);
    }

    private boolean convertPartTypeToBoolean(Part.Type type) {
        if (type == Part.Type.FALSE) {
            return false;
        }
        if (type == Part.Type.TRUE) {
            return true;
        }
        throw new IllegalStateException("Unexpected Part.Type: not boolean");
    }
}

