/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.support;

import com.aerospike.client.query.IndexType;
import org.reactivestreams.Publisher;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.repository.ReactiveAerospikeRepository;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class SimpleReactiveAerospikeRepository<T, ID>
implements ReactiveAerospikeRepository<T, ID> {
    private final EntityInformation<T, ID> entityInformation;
    private final ReactiveAerospikeOperations operations;

    public <S extends T> Mono<S> save(S entity) {
        Assert.notNull(entity, (String)"Cannot save NULL entity");
        return this.operations.save(entity);
    }

    public <S extends T> Flux<S> saveAll(Iterable<S> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return this.operations.saveAll(entities);
    }

    public <S extends T> Flux<S> saveAll(Publisher<S> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::save);
    }

    public Mono<T> findById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.findById(id, this.entityInformation.getJavaType());
    }

    public Mono<T> findById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given publisher of Id's must not be null!");
        return Mono.from(publisher).flatMap(id -> this.operations.findById(id, this.entityInformation.getJavaType()));
    }

    public Flux<T> findAll() {
        return this.operations.findAll(this.entityInformation.getJavaType());
    }

    public Flux<T> findAllById(Iterable<ID> ids) {
        Assert.notNull(ids, (String)"The given Iterable of Id's must not be null!");
        return this.operations.findByIds(ids, this.entityInformation.getJavaType());
    }

    public Flux<T> findAllById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given publisher of Id's must not be null!");
        return Flux.from(publisher).flatMap(id -> this.operations.findById(id, this.entityInformation.getJavaType()));
    }

    public Mono<Boolean> existsById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.exists(id, this.entityInformation.getJavaType());
    }

    public Mono<Boolean> existsById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given publisher of Id's must not be null!");
        return Mono.from(publisher).flatMap(id -> this.operations.exists(id, this.entityInformation.getJavaType()));
    }

    public Mono<Long> count() {
        return this.operations.count(this.entityInformation.getJavaType());
    }

    public Mono<Void> deleteById(ID id) {
        Assert.notNull(id, (String)"The given id must not be null!");
        return this.operations.deleteById(id, this.entityInformation.getJavaType()).then();
    }

    public Mono<Void> deleteById(Publisher<ID> publisher) {
        Assert.notNull(publisher, (String)"The given publisher of Id's must not be null!");
        return Mono.from(publisher).flatMap(this::deleteById);
    }

    public Mono<Void> delete(T entity) {
        Assert.notNull(entity, (String)"The given entity must not be null!");
        return this.operations.delete(entity).then();
    }

    public Mono<Void> deleteAllById(Iterable<? extends ID> ids) {
        Assert.notNull(ids, (String)"The given ids must not be null!");
        return this.operations.deleteByIds(ids, this.entityInformation.getJavaType());
    }

    public Mono<Void> deleteAll(Iterable<? extends T> entities) {
        Assert.notNull(entities, (String)"The given Iterable of entities must not be null!");
        return this.operations.deleteAll(entities);
    }

    public Mono<Void> deleteAll(Publisher<? extends T> entityStream) {
        Assert.notNull(entityStream, (String)"The given Publisher of entities must not be null!");
        return Flux.from(entityStream).flatMap(this::delete).then();
    }

    public Mono<Void> deleteAll() {
        return this.operations.deleteAll(this.entityInformation.getJavaType());
    }

    public void createIndex(Class<T> domainType, String indexName, String binName, IndexType indexType) {
        this.operations.createIndex(domainType, indexName, binName, indexType);
    }

    public void deleteIndex(Class<T> domainType, String indexName) {
        this.operations.deleteIndex(domainType, indexName);
    }

    @Override
    public Flux<T> findUsingQuery(Query query) {
        return this.operations.find(query, this.entityInformation.getJavaType());
    }

    public SimpleReactiveAerospikeRepository(EntityInformation<T, ID> entityInformation, ReactiveAerospikeOperations operations) {
        this.entityInformation = entityInformation;
        this.operations = operations;
    }
}

