/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.transaction.reactive.AerospikeReactiveTransactionResourceHolder;
import org.springframework.data.aerospike.transaction.sync.AerospikeTransactionResourceHolder;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.transaction.NoTransactionException;
import org.springframework.transaction.reactive.TransactionContextManager;
import org.springframework.transaction.support.TransactionSynchronizationManager;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public final class TemplateUtils {
    public static List<Object> getIdValue(Qualifier qualifier) {
        if (qualifier.hasId()) {
            return TemplateUtils.idObjectToList(qualifier.getId());
        }
        throw new IllegalArgumentException("Id qualifier must contain value");
    }

    private static List<Object> idObjectToList(Object ids) {
        Assert.notNull((Object)ids, (String)"Ids must not be null");
        List<Object> result = ids.getClass().isArray() ? (ids instanceof byte[] ? List.of(ids) : Arrays.stream((Object[])ids).toList()) : (ids instanceof Collection ? new ArrayList<Object>((Collection)ids) : (ids instanceof Iterable ? StreamSupport.stream(((Iterable)ids).spliterator(), false).collect(Collectors.toList()) : List.of(ids)));
        return result;
    }

    public static Qualifier[] excludeIdQualifier(Qualifier[] qualifiers) {
        ArrayList<Qualifier> qualifiersWithoutId = new ArrayList<Qualifier>();
        if (qualifiers != null && qualifiers.length > 0) {
            for (Qualifier qualifier : qualifiers) {
                if (qualifier.hasQualifiers()) {
                    Qualifier[] internalQuals = TemplateUtils.excludeIdQualifier(qualifier.getQualifiers());
                    qualifiersWithoutId.add(TemplateUtils.combineMultipleQualifiers(qualifier.getOperation(), internalQuals));
                    continue;
                }
                if (qualifier.hasId()) continue;
                qualifiersWithoutId.add(qualifier);
            }
            return (Qualifier[])qualifiersWithoutId.toArray(Qualifier[]::new);
        }
        return null;
    }

    public static Qualifier excludeIdQualifier(Qualifier qualifier) {
        ArrayList<Qualifier> qualifiersWithoutId = new ArrayList<Qualifier>();
        if (qualifier != null && qualifier.hasQualifiers()) {
            for (Qualifier innerQual : qualifier.getQualifiers()) {
                if (innerQual.hasQualifiers()) {
                    Qualifier[] internalQuals = TemplateUtils.excludeIdQualifier(innerQual.getQualifiers());
                    qualifiersWithoutId.add(TemplateUtils.combineMultipleQualifiers(innerQual.getOperation(), internalQuals));
                    continue;
                }
                if (innerQual.hasId()) continue;
                qualifiersWithoutId.add(innerQual);
            }
            return TemplateUtils.combineMultipleQualifiers(qualifier.getOperation() != null ? qualifier.getOperation() : FilterOperation.AND, (Qualifier[])qualifiersWithoutId.toArray(Qualifier[]::new));
        }
        if (qualifier != null && qualifier.hasId()) {
            return null;
        }
        return qualifier;
    }

    private static Qualifier combineMultipleQualifiers(FilterOperation operation, Qualifier[] qualifiers) {
        if (operation == FilterOperation.OR) {
            return Qualifier.or(qualifiers);
        }
        if (operation == FilterOperation.AND) {
            return Qualifier.and(qualifiers);
        }
        throw new UnsupportedOperationException("Only OR / AND operations are supported");
    }

    public static String[] getBinNamesFromTargetClass(Class<?> targetClass, MappingContext<BasicAerospikePersistentEntity<?>, AerospikePersistentProperty> mappingContext) {
        AerospikePersistentEntity targetEntity = (AerospikePersistentEntity)mappingContext.getRequiredPersistentEntity(targetClass);
        ArrayList binNamesList = new ArrayList();
        targetEntity.doWithProperties(property -> {
            if (!property.isIdProperty()) {
                binNamesList.add(property.getFieldName());
            }
        });
        return binNamesList.toArray(new String[0]);
    }

    public static Policy enrichPolicyWithTransaction(IAerospikeClient client, Policy policy) {
        if (TransactionSynchronizationManager.hasResource((Object)client)) {
            AerospikeTransactionResourceHolder resourceHolder = (AerospikeTransactionResourceHolder)((Object)TransactionSynchronizationManager.getResource((Object)client));
            if (resourceHolder != null) {
                policy.txn = resourceHolder.getTransaction();
            }
            return policy;
        }
        return policy;
    }

    private static Policy getPolicyFilterExp(IAerospikeClient client, QueryEngine queryEngine, Query query) {
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            Policy policy = client.copyReadPolicyDefault();
            Qualifier qualifier = query.getCriteriaObject();
            policy.filterExp = queryEngine.getFilterExpressionsBuilder().build(qualifier);
            return policy;
        }
        return null;
    }

    static Policy getPolicyFilterExpOrDefault(IAerospikeClient client, QueryEngine queryEngine, Query query) {
        Policy policy = TemplateUtils.getPolicyFilterExp(client, queryEngine, query);
        return policy != null ? policy : client.copyReadPolicyDefault();
    }

    static Mono<Policy> enrichPolicyWithTransaction(IAerospikeReactorClient reactorClient, Policy policy) {
        return TransactionContextManager.currentContext().map(ctx -> {
            AerospikeReactiveTransactionResourceHolder resourceHolder = (AerospikeReactiveTransactionResourceHolder)((Object)((Object)ctx.getResources().get(reactorClient)));
            if (resourceHolder != null) {
                policy.txn = resourceHolder.getTransaction();
                return policy;
            }
            return policy;
        }).onErrorResume(NoTransactionException.class, ignored -> Mono.just((Object)policy));
    }

    @Generated
    private TemplateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

