/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.exp.Expression;
import com.aerospike.client.policy.GenerationPolicy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import org.springframework.util.Assert;

public class WritePolicyBuilder {
    private final WritePolicy policy;

    private WritePolicyBuilder(WritePolicy policy) {
        this.policy = policy;
    }

    public static WritePolicyBuilder builder(WritePolicy policy) {
        Assert.notNull((Object)policy, (String)"Policy must not be null!");
        return new WritePolicyBuilder(new WritePolicy(policy));
    }

    public WritePolicyBuilder expiration(int expiration) {
        this.policy.expiration = expiration;
        return this;
    }

    public WritePolicyBuilder sendKey(boolean sendKey) {
        this.policy.sendKey = sendKey;
        return this;
    }

    public WritePolicyBuilder recordExistsAction(RecordExistsAction recordExistsAction) {
        this.policy.recordExistsAction = recordExistsAction;
        return this;
    }

    public WritePolicyBuilder generationPolicy(GenerationPolicy generationPolicy) {
        this.policy.generationPolicy = generationPolicy;
        return this;
    }

    public WritePolicyBuilder generation(int generation) {
        this.policy.generation = generation;
        return this;
    }

    public WritePolicyBuilder failOnFilteredOut(boolean failOnFilteredOut) {
        this.policy.failOnFilteredOut = failOnFilteredOut;
        return this;
    }

    public WritePolicyBuilder filterExp(Expression expression) {
        this.policy.filterExp = expression;
        return this;
    }

    public WritePolicy build() {
        this.validate();
        return new WritePolicy(this.policy);
    }

    private void validate() {
        Assert.notNull((Object)this.policy.commitLevel, (String)"Field 'commitLevel' must not be null");
        Assert.notNull((Object)this.policy.recordExistsAction, (String)"Field 'recordExistsAction' must not be null");
        Assert.notNull((Object)this.policy.generationPolicy, (String)"Field 'generationPolicy' must not be null");
        Assert.state((this.policy.generation <= 0 || this.policy.generationPolicy != GenerationPolicy.NONE ? 1 : 0) != 0, (String)"Field 'generationPolicy' must not be 'NONE' when 'generation' is set");
    }
}

