/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.Collection;
import java.util.List;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;

public class IdQueryCreator
implements IAerospikeQueryCreator {
    private final List<Object> queryParameters;

    public IdQueryCreator(List<Object> queryParameters) {
        this.queryParameters = queryParameters;
    }

    @Override
    public void validate() {
    }

    @Override
    public Qualifier process() {
        Object value1 = this.queryParameters.get(0);
        if (value1 instanceof Collection) {
            List ids = ((Collection)value1).stream().toList();
            return this.getIdInQualifier(ids);
        }
        return this.getIdEqualsQualifier(value1);
    }

    private Qualifier getIdInQualifier(List<?> ids) {
        Qualifier qualifier;
        Object firstId = ids.get(0);
        if (firstId instanceof String) {
            qualifier = Qualifier.idIn((String[])ids.toArray(String[]::new));
        } else if (firstId instanceof Long) {
            qualifier = Qualifier.idIn((Long[])ids.toArray(Long[]::new));
        } else if (firstId instanceof Integer) {
            qualifier = Qualifier.idIn((Integer[])ids.toArray(Integer[]::new));
        } else if (firstId instanceof Short) {
            qualifier = Qualifier.idIn((Short[])ids.toArray(Short[]::new));
        } else if (firstId instanceof Byte) {
            qualifier = Qualifier.idIn((Byte[])ids.toArray(Byte[]::new));
        } else if (firstId instanceof Character) {
            qualifier = Qualifier.idIn((Character[])ids.toArray(Character[]::new));
        } else if (firstId instanceof byte[]) {
            qualifier = Qualifier.idIn((byte[][])ids.toArray(x$0 -> new byte[x$0][]));
        } else {
            throw new IllegalArgumentException("Invalid ID argument type: expected String, Number or byte[]");
        }
        return qualifier;
    }

    private Qualifier getIdEqualsQualifier(Object value1) {
        Qualifier qualifier;
        if (value1 instanceof String) {
            qualifier = Qualifier.idEquals((String)value1);
        } else if (value1 instanceof Long) {
            qualifier = Qualifier.idEquals((Long)value1);
        } else if (value1 instanceof Integer) {
            qualifier = Qualifier.idEquals((Integer)value1);
        } else if (value1 instanceof Short) {
            qualifier = Qualifier.idEquals((Short)value1);
        } else if (value1 instanceof Byte) {
            qualifier = Qualifier.idEquals((Byte)value1);
        } else if (value1 instanceof Character) {
            qualifier = Qualifier.idEquals((Character)value1);
        } else if (value1 instanceof byte[]) {
            qualifier = Qualifier.idEquals((byte[])value1);
        } else {
            throw new IllegalArgumentException("Invalid ID argument type: expected String, Number or byte[]");
        }
        return qualifier;
    }
}

