/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.util;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.exp.Exp;
import java.io.File;
import java.net.InetAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.ZoneId;
import java.time.temporal.Temporal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.springframework.core.env.Environment;
import org.springframework.dao.InvalidDataAccessResourceUsageException;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.util.InfoCommandUtils;
import org.springframework.data.aerospike.util.InfoResponseUtils;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public final class Utils {
    public static int getReplicationFactor(IAerospikeClient client, Node[] nodes, String namespace) {
        Node randomNode = Utils.getRandomNode(nodes);
        String response = InfoCommandUtils.request(client, randomNode, "get-config:context=namespace;id=" + namespace);
        if (response.equalsIgnoreCase("ns_type=unknown")) {
            throw new InvalidDataAccessResourceUsageException("Namespace: " + namespace + " does not exist");
        }
        return InfoResponseUtils.getPropertyFromConfigResponse(response, "replication-factor", Integer::parseInt);
    }

    public static Node getRandomNode(Node[] nodes) {
        if (nodes.length == 0) {
            throw new AerospikeException(-8, "Command failed because cluster is empty.");
        }
        int offset = ThreadLocalRandom.current().nextInt(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            int index = (offset + i) % nodes.length;
            Node node = nodes[index];
            if (!node.isActive()) continue;
            return node;
        }
        throw new AerospikeException.InvalidNode("Command failed because no active nodes found.");
    }

    public static long getObjectsCount(IAerospikeClient client, Node node, String namespace, String setName) {
        String infoString = InfoCommandUtils.request(client, node, "sets/" + namespace + "/" + setName);
        if (infoString.isEmpty()) {
            return 0L;
        }
        return InfoResponseUtils.getPropertyFromInfoResponse(infoString, "objects", Long::parseLong);
    }

    public static Exp getExpValOrFail(Value value, String errMsg) {
        return switch (value.getType()) {
            case 1 -> Exp.val((long)value.toLong());
            case 17 -> Exp.val((boolean)((Boolean)value.getObject()));
            case 3 -> Exp.val((String)value.toString());
            case 20 -> Exp.val((List)((List)value.getObject()));
            case 19 -> Exp.val((Map)((Map)value.getObject()));
            case 0 -> Exp.nil();
            default -> throw new UnsupportedOperationException(errMsg);
        };
    }

    public static Exp.Type getExpType(Value value) {
        return switch (value.getType()) {
            case 1 -> Exp.Type.INT;
            case 2 -> Exp.Type.FLOAT;
            case 17 -> Exp.Type.BOOL;
            case 3 -> Exp.Type.STRING;
            case 20 -> Exp.Type.LIST;
            case 19 -> Exp.Type.MAP;
            case 0 -> Exp.Type.NIL;
            default -> throw new UnsupportedOperationException("Unsupported Value type: " + value.getType());
        };
    }

    public static boolean isSimpleValueType(Class<?> type) {
        return Void.class != type && Void.TYPE != type && (ClassUtils.isPrimitiveOrWrapper(type) || Enum.class.isAssignableFrom(type) || CharSequence.class.isAssignableFrom(type) || Number.class.isAssignableFrom(type) || Date.class.isAssignableFrom(type) || Temporal.class.isAssignableFrom(type) || ZoneId.class.isAssignableFrom(type) || TimeZone.class.isAssignableFrom(type) || File.class.isAssignableFrom(type) || Path.class.isAssignableFrom(type) || Charset.class.isAssignableFrom(type) || Currency.class.isAssignableFrom(type) || InetAddress.class.isAssignableFrom(type) || URI.class == type || URL.class == type || UUID.class == type || Locale.class == type || Pattern.class == type || Class.class == type);
    }

    public static String ctxArrToString(CTX[] ctxArr) {
        return Arrays.stream(ctxArr).map(ctx -> ctx.value.toString()).collect(Collectors.joining("."));
    }

    public static void logQualifierDetails(CriteriaDefinition criteria, Logger logger) {
        String operation;
        if (criteria == null || !logger.isDebugEnabled()) {
            return;
        }
        Qualifier qualifier = criteria.getCriteriaObject();
        Qualifier[] qualifiers = qualifier.getQualifiers();
        if (qualifiers != null && qualifiers.length > 0) {
            Arrays.stream(qualifiers).forEach(innerQualifier -> Utils.logQualifierDetails(innerQualifier, logger));
        }
        operation = StringUtils.hasLength((String)(operation = qualifier.getOperation().toString())) ? operation : "N/A";
        String values = "";
        String value = Utils.valueToString(qualifier.getValue());
        String value2 = Utils.valueToString(qualifier.getSecondValue());
        values = StringUtils.hasLength((String)value) ? String.format(", value = %s", value) : "";
        values = StringUtils.hasLength((String)value2) ? String.format("%s, value2 = %s", values, value2) : values;
        Object path = "";
        if (Utils.isBinQualifier(qualifier)) {
            Object object = path = StringUtils.hasLength((String)qualifier.getBinName()) ? String.format(" path = %s,", qualifier.getBinName()) : "";
            if (qualifier.getCtxArray() != null && qualifier.getCtxArray().length > 0) {
                path = (String)path + "." + Utils.ctxArrToString(qualifier.getCtxArray());
            }
            if (qualifier.getKey() != null && StringUtils.hasLength((String)qualifier.getKey().getObject().toString())) {
                path = (String)path + "." + qualifier.getKey().getObject().toString();
            }
        } else if (Utils.isMetadataQualifier(qualifier)) {
            path = qualifier.getMetadataField().toString();
        }
        String qualifiersStr = qualifier.getQualifiers() != null && qualifier.getQualifiers().length > 0 ? String.format(", qualifiers = %s,", Utils.qualifiersHashesToString(qualifier.getQualifiers())) : "";
        logger.debug("Created qualifier #{}:{} operation = {}{}{}", new Object[]{qualifier.hashCode(), path, operation, values, qualifiersStr});
    }

    private static String qualifiersHashesToString(@NonNull Qualifier[] qualifiers) {
        if (qualifiers == null) {
            throw new NullPointerException("qualifiers is marked non-null but is null");
        }
        return "[" + String.join((CharSequence)",", Arrays.stream(qualifiers).map(qualifier -> String.valueOf(qualifier.hashCode())).toList()) + "]";
    }

    private static boolean isBinQualifier(Qualifier qualifier) {
        return qualifier.getBinName() != null;
    }

    private static boolean isMetadataQualifier(Qualifier qualifier) {
        return qualifier.getMetadataField() != null;
    }

    public static String valueToString(Value value) {
        if (value != null && StringUtils.hasLength((String)value.toString())) {
            return value.toString();
        }
        return value == Value.getAsNull() ? "null" : "";
    }

    public static <T> List<T> iterableToList(Iterable<T> iterable) {
        return StreamSupport.stream(iterable.spliterator(), false).collect(Collectors.toList());
    }

    public static List<String> getInDifferentFormats(String input) {
        if (!StringUtils.hasText((String)input)) {
            return List.of();
        }
        ArrayList<String> variants = new ArrayList<String>();
        variants.add(input);
        variants.add(input.replaceAll("([a-z])([A-Z])", "$1-$2").toLowerCase());
        variants.add(input.replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase());
        variants.add(input.replaceAll("([a-z])([A-Z])", "$1_$2").toUpperCase());
        variants.add(input.substring(0, 1).toUpperCase() + input.substring(1));
        return variants;
    }

    public static String getProperty(Environment environment, String prefix, String propertyName) {
        for (String string : Utils.getInDifferentFormats(propertyName)) {
            String string2 = prefix + "." + string;
            if (!environment.containsProperty(string2)) continue;
            return environment.getProperty(string2);
        }
        return null;
    }

    public static void setStringFromConfig(Consumer<String> setter, Environment environment, String prefix, String propertyName) {
        String value = Utils.getProperty(environment, prefix, propertyName);
        if (value != null) {
            setter.accept(value);
        }
    }

    public static void setBoolFromConfig(Consumer<Boolean> setter, Environment environment, String prefix, String propertyName) {
        String value = Utils.getProperty(environment, prefix, propertyName);
        if (value != null) {
            setter.accept(Boolean.parseBoolean(value));
        }
    }

    public static void setIntFromConfig(Consumer<Integer> setter, Environment environment, String prefix, String propertyName) {
        String value = Utils.getProperty(environment, prefix, propertyName);
        if (value != null) {
            setter.accept(Integer.parseInt(value));
        }
    }

    @Generated
    private Utils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

