/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

import lombok.Generated;
import org.springframework.core.env.Environment;
import org.springframework.data.aerospike.util.Utils;

public class AerospikeDataSettings {
    String namespace;
    boolean scansEnabled = false;
    boolean createIndexesOnStartup = true;
    int indexCacheRefreshSeconds = 3600;
    int serverVersionRefreshSeconds = 3600;
    long queryMaxRecords = 10000L;
    int batchWriteSize = 100;
    boolean keepOriginalKeyTypes = false;
    boolean writeSortedMaps = true;
    private String classKey = "@_class";
    private String fieldNamingStrategy;

    public AerospikeDataSettings(Environment environment) {
        if (environment != null) {
            Utils.setStringFromConfig(this::setNamespace, environment, "spring.data.aerospike", "namespace");
            Utils.setBoolFromConfig(this::setScansEnabled, environment, "spring.data.aerospike", "scansEnabled");
            Utils.setBoolFromConfig(this::setCreateIndexesOnStartup, environment, "spring.data.aerospike", "createIndexesOnStartup");
            Utils.setIntFromConfig(this::setIndexCacheRefreshSeconds, environment, "spring.data.aerospike", "indexCacheRefreshSeconds");
            Utils.setIntFromConfig(this::setServerVersionRefreshSeconds, environment, "spring.data.aerospike", "serverVersionRefreshSeconds");
            Utils.setIntFromConfig(this::setQueryMaxRecords, environment, "spring.data.aerospike", "queryMaxRecords");
            Utils.setIntFromConfig(this::setBatchWriteSize, environment, "spring.data.aerospike", "batchWriteSize");
            Utils.setBoolFromConfig(this::setKeepOriginalKeyTypes, environment, "spring.data.aerospike", "keepOriginalKeyTypes");
            Utils.setBoolFromConfig(this::setWriteSortedMaps, environment, "spring.data.aerospike", "writeSortedMaps");
            Utils.setStringFromConfig(this::setClassKey, environment, "spring.data.aerospike", "classKey");
            Utils.setStringFromConfig(this::setFieldNamingStrategy, environment, "spring.data.aerospike", "fieldNamingStrategy");
        }
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    @Generated
    public void setCreateIndexesOnStartup(boolean createIndexesOnStartup) {
        this.createIndexesOnStartup = createIndexesOnStartup;
    }

    @Generated
    public void setIndexCacheRefreshSeconds(int indexCacheRefreshSeconds) {
        this.indexCacheRefreshSeconds = indexCacheRefreshSeconds;
    }

    @Generated
    public void setServerVersionRefreshSeconds(int serverVersionRefreshSeconds) {
        this.serverVersionRefreshSeconds = serverVersionRefreshSeconds;
    }

    @Generated
    public void setQueryMaxRecords(long queryMaxRecords) {
        this.queryMaxRecords = queryMaxRecords;
    }

    @Generated
    public void setBatchWriteSize(int batchWriteSize) {
        this.batchWriteSize = batchWriteSize;
    }

    @Generated
    public void setKeepOriginalKeyTypes(boolean keepOriginalKeyTypes) {
        this.keepOriginalKeyTypes = keepOriginalKeyTypes;
    }

    @Generated
    public void setWriteSortedMaps(boolean writeSortedMaps) {
        this.writeSortedMaps = writeSortedMaps;
    }

    @Generated
    public void setClassKey(String classKey) {
        this.classKey = classKey;
    }

    @Generated
    public void setFieldNamingStrategy(String fieldNamingStrategy) {
        this.fieldNamingStrategy = fieldNamingStrategy;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public boolean isScansEnabled() {
        return this.scansEnabled;
    }

    @Generated
    public boolean isCreateIndexesOnStartup() {
        return this.createIndexesOnStartup;
    }

    @Generated
    public int getIndexCacheRefreshSeconds() {
        return this.indexCacheRefreshSeconds;
    }

    @Generated
    public int getServerVersionRefreshSeconds() {
        return this.serverVersionRefreshSeconds;
    }

    @Generated
    public long getQueryMaxRecords() {
        return this.queryMaxRecords;
    }

    @Generated
    public int getBatchWriteSize() {
        return this.batchWriteSize;
    }

    @Generated
    public boolean isKeepOriginalKeyTypes() {
        return this.keepOriginalKeyTypes;
    }

    @Generated
    public boolean isWriteSortedMaps() {
        return this.writeSortedMaps;
    }

    @Generated
    public String getClassKey() {
        return this.classKey;
    }

    @Generated
    public String getFieldNamingStrategy() {
        return this.fieldNamingStrategy;
    }
}

