/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.RecordSet;
import java.io.Closeable;
import java.util.Iterator;

public class KeyRecordIterator
implements Iterator<KeyRecord>,
Closeable {
    private final String namespace;
    private final Object closeLock = 0;
    private RecordSet recordSet;
    private Iterator<KeyRecord> recordSetIterator;
    private KeyRecord singleRecord;

    public KeyRecordIterator(String namespace) {
        this.namespace = namespace;
    }

    public KeyRecordIterator(String namespace, KeyRecord singleRecord) {
        this(namespace);
        this.singleRecord = singleRecord;
    }

    public KeyRecordIterator(String namespace, RecordSet recordSet) {
        this(namespace);
        this.recordSet = recordSet;
        this.recordSetIterator = recordSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.recordSet != null) {
                this.recordSet.close();
            }
            if (this.singleRecord != null) {
                this.singleRecord = null;
            }
        }
    }

    @Override
    public boolean hasNext() {
        if (this.recordSetIterator != null) {
            return this.recordSetIterator.hasNext();
        }
        return this.singleRecord != null;
    }

    @Override
    public KeyRecord next() {
        KeyRecord keyRecord = null;
        if (this.recordSetIterator != null) {
            keyRecord = this.recordSetIterator.next();
        } else if (this.singleRecord != null) {
            keyRecord = this.singleRecord;
            this.singleRecord = null;
        }
        return keyRecord;
    }

    @Override
    public void remove() {
    }

    public String toString() {
        return this.namespace;
    }
}

