/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query.qualifier;

import java.util.Collection;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.BaseQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.util.Assert;

public class MetadataQualifierBuilder
extends BaseQualifierBuilder<MetadataQualifierBuilder> {
    MetadataQualifierBuilder() {
    }

    public CriteriaDefinition.AerospikeMetadata getMetadataField() {
        return (CriteriaDefinition.AerospikeMetadata)((Object)this.map.get((Object)QualifierKey.METADATA_FIELD));
    }

    public MetadataQualifierBuilder setMetadataField(CriteriaDefinition.AerospikeMetadata metadataField) {
        this.map.put(QualifierKey.METADATA_FIELD, metadataField);
        return this;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void validate() {
        if (this.getMetadataField() == null) throw new IllegalArgumentException("Expecting metadataField parameter to be provided");
        if (this.getPath() != null) throw new IllegalArgumentException("Unexpected parameter for metadata query: path");
        if (this.getValue() == null) {
            throw new IllegalArgumentException("Expecting value parameter to be provided");
        }
        this.validateValues();
    }

    private void validateValues() {
        FilterOperation operation = this.getFilterOperation();
        switch (operation) {
            case EQ: 
            case NOTEQ: 
            case LT: 
            case LTEQ: 
            case GT: 
            case GTEQ: {
                Assert.isTrue((boolean)(this.getValue().getObject() instanceof Long), (String)(operation.name() + ": value is expected to be set as Long"));
                break;
            }
            case BETWEEN: {
                Assert.isTrue((this.getSecondValue() != null ? 1 : 0) != 0, (String)"BETWEEN: expecting secondValue to be provided");
                Assert.isTrue((boolean)(this.getValue().getObject() instanceof Long), (String)"BETWEEN: value is expected to be set as Long");
                Assert.isTrue((boolean)(this.getSecondValue().getObject() instanceof Long), (String)"BETWEEN: secondValue is expected to be set as Long");
                break;
            }
            case NOT_IN: 
            case IN: {
                Object obj = this.getValue().getObject();
                Assert.isTrue((obj instanceof Collection && !((Collection)obj).isEmpty() && ((Collection)obj).toArray()[0] instanceof Long ? 1 : 0) != 0, (String)(operation.name() + ": value1 is expected to be a non-empty Collection<Long>"));
                break;
            }
            default: {
                throw new IllegalArgumentException("Operation " + operation + " cannot be applied to metadataField");
            }
        }
    }
}

