/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.QueryParam;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.CollectionQueryCreator;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.aerospike.repository.query.IdQueryCreator;
import org.springframework.data.aerospike.repository.query.MapQueryCreator;
import org.springframework.data.aerospike.repository.query.PojoQueryCreator;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.repository.query.SimplePropertyQueryCreator;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.domain.Sort;
import org.springframework.data.mapping.PersistentPropertyPath;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.ParameterAccessor;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.repository.query.parser.PartTree;

public class AerospikeQueryCreator
extends AbstractQueryCreator<Query, CriteriaDefinition> {
    private final AerospikeMappingContext context;
    private final MappingAerospikeConverter converter;
    private final ServerVersionSupport versionSupport;
    private final boolean isCombinedQuery;

    public AerospikeQueryCreator(PartTree tree, ParameterAccessor parameters, AerospikeMappingContext context, MappingAerospikeConverter converter, ServerVersionSupport versionSupport) {
        super(tree, parameters);
        this.context = context;
        this.converter = converter;
        this.versionSupport = versionSupport;
        this.isCombinedQuery = tree.getParts().toList().size() > 1;
    }

    protected CriteriaDefinition and(Part part, CriteriaDefinition base, Iterator<Object> iterator) {
        Object criteriaDefinition = this.create(part, (Iterator)iterator);
        if (base == null) {
            return criteriaDefinition;
        }
        return Qualifier.and(base.getCriteriaObject(), criteriaDefinition.getCriteriaObject());
    }

    protected CriteriaDefinition or(CriteriaDefinition base, CriteriaDefinition criteria) {
        return Qualifier.or(base.getCriteriaObject(), criteria.getCriteriaObject());
    }

    protected Query complete(CriteriaDefinition criteria, Sort sort) {
        Query query = criteria == null ? null : new Query(criteria).with(sort);
        return query;
    }

    protected CriteriaDefinition create(Part part, Iterator<Object> iterator) {
        PersistentPropertyPath path = this.context.getPersistentPropertyPath(part.getProperty());
        AerospikePersistentProperty property = (AerospikePersistentProperty)path.getLeafProperty();
        Iterator<Object> paramIterator = iterator;
        if (this.isCombinedQuery && iterator.hasNext()) {
            Object nextParam = iterator.next();
            if (!(nextParam instanceof QueryParam)) {
                throw new IllegalArgumentException(String.format("%s: expected CombinedQueryParam, instead got %s", part.getProperty(), nextParam.getClass().getSimpleName()));
            }
            paramIterator = Arrays.stream(((QueryParam)nextParam).arguments()).iterator();
        }
        return this.create(part, property, paramIterator);
    }

    private CriteriaDefinition create(Part part, AerospikePersistentProperty property, Iterator<?> parameters) {
        FilterOperation filterOperation = this.getFilterOperation(part.getType());
        List<Object> queryParameters = this.getQueryParameters(parameters, filterOperation);
        IAerospikeQueryCreator queryCreator = this.getQueryCreator(part, property, queryParameters, filterOperation);
        queryCreator.validate();
        return queryCreator.process();
    }

    private IAerospikeQueryCreator getQueryCreator(Part part, AerospikePersistentProperty property, List<Object> queryParameters, FilterOperation filterOperation) {
        IAerospikeQueryCreator queryCreator;
        String fieldName = AerospikeQueryCreatorUtils.getFieldName(part.getProperty().getSegment(), property);
        if (property.isIdProperty()) {
            queryCreator = new IdQueryCreator(queryParameters);
        } else if (property.isCollectionLike()) {
            if (part.getProperty().hasNext()) {
                PropertyPath nestedProperty = AerospikeQueryCreatorUtils.getNestedPropertyPath(part.getProperty());
                queryCreator = new CollectionQueryCreator(part, nestedProperty, property, fieldName, queryParameters, filterOperation, this.converter, true, this.versionSupport);
            } else {
                queryCreator = new CollectionQueryCreator(part, part.getProperty(), property, fieldName, queryParameters, filterOperation, this.converter, false, this.versionSupport);
            }
        } else if (property.isMap()) {
            if (part.getProperty().hasNext()) {
                PropertyPath nestedProperty = AerospikeQueryCreatorUtils.getNestedPropertyPath(part.getProperty());
                queryCreator = new MapQueryCreator(part, nestedProperty, property, fieldName, queryParameters, filterOperation, this.converter, this.versionSupport, true);
            } else {
                queryCreator = new MapQueryCreator(part, part.getProperty(), property, fieldName, queryParameters, filterOperation, this.converter, this.versionSupport, false);
            }
        } else {
            PropertyPath nestedProperty;
            queryCreator = part.getProperty().hasNext() ? (AerospikeQueryCreatorUtils.isPojo((nestedProperty = AerospikeQueryCreatorUtils.getNestedPropertyPath(part.getProperty())).getType()) ? new PojoQueryCreator(part, nestedProperty, property, fieldName, queryParameters, filterOperation, this.converter, true, this.versionSupport) : new SimplePropertyQueryCreator(part, nestedProperty, property, fieldName, queryParameters, filterOperation, this.converter, true, this.versionSupport)) : (AerospikeQueryCreatorUtils.isPojo(part.getProperty().getType()) ? new PojoQueryCreator(part, part.getProperty(), property, fieldName, queryParameters, filterOperation, this.converter, false, this.versionSupport) : new SimplePropertyQueryCreator(part, part.getProperty(), property, fieldName, queryParameters, filterOperation, this.converter, false, this.versionSupport));
        }
        return queryCreator;
    }

    private FilterOperation getFilterOperation(Part.Type type) {
        return switch (type) {
            case Part.Type.AFTER, Part.Type.GREATER_THAN -> FilterOperation.GT;
            case Part.Type.GREATER_THAN_EQUAL -> FilterOperation.GTEQ;
            case Part.Type.BEFORE, Part.Type.LESS_THAN -> FilterOperation.LT;
            case Part.Type.LESS_THAN_EQUAL -> FilterOperation.LTEQ;
            case Part.Type.BETWEEN -> FilterOperation.BETWEEN;
            case Part.Type.LIKE, Part.Type.REGEX -> FilterOperation.LIKE;
            case Part.Type.STARTING_WITH -> FilterOperation.STARTS_WITH;
            case Part.Type.ENDING_WITH -> FilterOperation.ENDS_WITH;
            case Part.Type.CONTAINING -> FilterOperation.CONTAINING;
            case Part.Type.NOT_CONTAINING -> FilterOperation.NOT_CONTAINING;
            case Part.Type.WITHIN -> FilterOperation.GEO_WITHIN;
            case Part.Type.SIMPLE_PROPERTY, Part.Type.TRUE, Part.Type.FALSE -> FilterOperation.EQ;
            case Part.Type.NEGATING_SIMPLE_PROPERTY -> FilterOperation.NOTEQ;
            case Part.Type.IN -> FilterOperation.IN;
            case Part.Type.NOT_IN -> FilterOperation.NOT_IN;
            case Part.Type.EXISTS, Part.Type.IS_NOT_NULL -> FilterOperation.IS_NOT_NULL;
            case Part.Type.IS_NULL -> FilterOperation.IS_NULL;
            default -> throw new IllegalArgumentException(String.format("Unsupported keyword '%s'", type));
        };
    }

    private List<Object> getQueryParameters(Iterator<?> parametersIterator, FilterOperation filterOperation) {
        ArrayList params = new ArrayList();
        parametersIterator.forEachRemaining(param -> params.add(AerospikeQueryCreatorUtils.convertIfNecessary(param, this.converter)));
        return params.stream().filter(Objects::nonNull).collect(Collectors.toList());
    }
}

