/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.aerospike.repository.query.QueryQualifierBuilder;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.StringUtils;

public class MapQueryCreator
implements IAerospikeQueryCreator {
    private final Part part;
    private final AerospikePersistentProperty property;
    private final PropertyPath propertyPath;
    private final String fieldName;
    private final List<Object> queryParameters;
    private final FilterOperation filterOperation;
    private final MappingAerospikeConverter converter;
    private final ServerVersionSupport versionSupport;
    private final boolean isNested;

    public MapQueryCreator(Part part, PropertyPath propertyPath, AerospikePersistentProperty property, String fieldName, List<Object> queryParameters, FilterOperation filterOperation, MappingAerospikeConverter converter, ServerVersionSupport versionSupport, boolean isNested) {
        this.part = part;
        this.propertyPath = propertyPath;
        this.property = property;
        this.fieldName = fieldName;
        this.queryParameters = queryParameters;
        this.filterOperation = filterOperation;
        this.converter = converter;
        this.isNested = isNested;
        this.versionSupport = versionSupport;
    }

    @Override
    public void validate() {
        String queryPartDescription = String.join((CharSequence)" ", this.propertyPath.toString(), this.filterOperation.toString());
        switch (this.filterOperation) {
            case CONTAINING: 
            case NOT_CONTAINING: {
                this.validateMapQueryContaining(queryPartDescription);
                break;
            }
            case EQ: 
            case NOTEQ: 
            case GT: 
            case GTEQ: 
            case LT: 
            case LTEQ: {
                this.validateMapQueryComparison(queryPartDescription);
                AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.filterOperation, this.queryParameters);
                break;
            }
            case BETWEEN: {
                this.validateMapQueryBetween(queryPartDescription);
                AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.filterOperation, this.queryParameters);
                break;
            }
            case IN: 
            case NOT_IN: {
                AerospikeQueryCreatorUtils.validateQueryIn(this.queryParameters, queryPartDescription);
                AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.filterOperation, this.queryParameters);
                break;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                AerospikeQueryCreatorUtils.validateQueryIsNull(this.queryParameters, queryPartDescription);
                AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.filterOperation, this.queryParameters);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation: " + queryPartDescription);
            }
        }
    }

    private void validateMapQueryContaining(String queryPartDescription) {
        if (this.queryParameters.size() < 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, at least two arguments are required");
        }
        Object param1 = this.queryParameters.get(0);
        if (!(param1 instanceof CriteriaDefinition.AerospikeQueryCriterion)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid first argument type, required AerospikeQueryCriterion");
        }
        Object param2 = this.queryParameters.get(1);
        switch ((CriteriaDefinition.AerospikeQueryCriterion)((Object)param1)) {
            case KEY: {
                if (this.queryParameters.size() != 2) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
                }
                if (!StringUtils.hasText((String)this.converter.getAerospikeDataSettings().getClassKey())) {
                    return;
                }
                if (this.isValidMapKeyTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param2)) break;
                throw new IllegalArgumentException(queryPartDescription + ": invalid map key type at position 2");
            }
            case VALUE: {
                if (this.queryParameters.size() != 2) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
                }
                if (!StringUtils.hasText((String)this.converter.getAerospikeDataSettings().getClassKey())) {
                    return;
                }
                if (this.isValidMapValueTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param2)) break;
                throw new IllegalArgumentException(queryPartDescription + ": invalid map value type at position 2");
            }
            case KEY_VALUE_PAIR: {
                if (this.queryParameters.size() != 3) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting three");
                }
                if (!StringUtils.hasText((String)this.converter.getAerospikeDataSettings().getClassKey())) {
                    return;
                }
                if (!this.isValidMapKeyTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param2)) {
                    throw new IllegalArgumentException(queryPartDescription + ": invalid map key type at position 2");
                }
                Object param3 = this.queryParameters.get(2);
                if (this.isValidMapValueTypeOrUnresolved(this.part.getProperty().getTypeInformation(), param3)) break;
                throw new IllegalArgumentException(queryPartDescription + ": invalid map value type at position 3");
            }
            default: {
                throw new IllegalStateException(queryPartDescription + ": invalid AerospikeQueryCriterion type of the first argument, expecting KEY, VALUE or KEY_VALUE_PAIR");
            }
        }
    }

    private boolean isValidMapKeyTypeOrUnresolved(TypeInformation<?> typeInformation, Object param) {
        Class mapKeyClass;
        try {
            if (typeInformation.getComponentType() == null) {
                return true;
            }
            mapKeyClass = typeInformation.getComponentType().getType();
        }
        catch (IllegalStateException e) {
            mapKeyClass = null;
        }
        return mapKeyClass == null || AerospikeQueryCreatorUtils.isAssignableValueOrConverted(mapKeyClass, param, this.converter);
    }

    private boolean isValidMapValueTypeOrUnresolved(TypeInformation<?> typeInformation, Object param) {
        Class mapValueClass;
        try {
            if (typeInformation.getRequiredMapValueType() == null) {
                return true;
            }
            mapValueClass = typeInformation.getRequiredMapValueType().getType();
        }
        catch (IllegalStateException e) {
            mapValueClass = null;
        }
        return mapValueClass == null || AerospikeQueryCreatorUtils.isAssignableValueOrConverted(mapValueClass, param, this.converter) || param == CriteriaDefinition.AerospikeNullQueryCriterion.NULL_PARAM;
    }

    private void validateMapQueryComparison(String queryPartDescription) {
        if (this.queryParameters.size() != 1) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one");
        }
        if (!(this.queryParameters.get(0) instanceof Map)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid argument type, expecting Map");
        }
    }

    private void validateMapQueryBetween(String queryPartDescription) {
        if (this.queryParameters.size() != 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
        }
        Object value = this.queryParameters.get(0);
        if (!(value instanceof Map)) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid argument type, expecting Map");
        }
        if (!value.getClass().equals(this.queryParameters.get(1).getClass())) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid arguments type, expecting both to be of the same class");
        }
    }

    @Override
    public Qualifier process() {
        Qualifier qualifier = null;
        QueryQualifierBuilder qb = new QueryQualifierBuilder();
        int paramsSize = this.queryParameters.size();
        List<String> dotPath = null;
        FilterOperation op = this.filterOperation;
        if (this.filterOperation == FilterOperation.BETWEEN || this.filterOperation == FilterOperation.IN || this.filterOperation == FilterOperation.NOT_IN) {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
            if (this.queryParameters.size() == 2) {
                AerospikeQueryCreatorUtils.setQualifierBuilderSecondValue(qb, this.queryParameters.get(1));
            }
            if (this.isNested) {
                AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, this.property.getFieldName());
                dotPath = List.of(this.part.getProperty().toDotPath());
                op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(this.filterOperation);
            }
            qualifier = AerospikeQueryCreatorUtils.setQualifier(qb, this.fieldName, op, this.part, dotPath, this.versionSupport);
            return qualifier;
        }
        if (this.isNested && (op == FilterOperation.CONTAINING || op == FilterOperation.NOT_CONTAINING)) {
            qb.setNestedType(19);
        }
        if (this.queryParameters.size() < 2) {
            if (this.queryParameters.isEmpty() && (this.filterOperation == FilterOperation.IS_NOT_NULL || this.filterOperation == FilterOperation.IS_NULL)) {
                AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.property.getFieldName());
            } else {
                AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
                if (this.isNested) {
                    AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, this.property.getFieldName());
                }
            }
            if (this.isNested) {
                op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(this.filterOperation);
                dotPath = List.of(this.part.getProperty().toDotPath());
            }
            qualifier = AerospikeQueryCreatorUtils.setQualifier(qb, this.fieldName, op, this.part, dotPath, this.versionSupport);
        }
        if (paramsSize == 2) {
            if (this.isNested) {
                AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, this.property.getFieldName());
            }
            qualifier = this.processMapTwoParams(qb, this.part, this.queryParameters, this.filterOperation, this.fieldName);
        }
        if (this.queryParameters.size() > 2) {
            qualifier = this.processMapMultipleParams(qb);
        }
        return qualifier;
    }

    private Qualifier processMapTwoParams(QueryQualifierBuilder qb, Part part, List<Object> params, FilterOperation op, String fieldName) {
        Qualifier qualifier = op == FilterOperation.CONTAINING ? this.processMapContaining(qb, part, fieldName, FilterOperation.MAP_KEYS_CONTAIN, FilterOperation.MAP_VALUES_CONTAIN, FilterOperation.MAP_VAL_EQ_BY_KEY) : (op == FilterOperation.NOT_CONTAINING ? this.processMapContaining(qb, part, fieldName, FilterOperation.MAP_KEYS_NOT_CONTAIN, FilterOperation.MAP_VALUES_NOT_CONTAIN, FilterOperation.MAP_VAL_NOTEQ_BY_KEY) : this.processMapOtherThanContaining(qb, part, params, op, fieldName));
        return qualifier;
    }

    private Qualifier processMapContaining(QueryQualifierBuilder qb, Part part, String fieldName, FilterOperation keysOp, FilterOperation valuesOp, FilterOperation byKeyOp) {
        FilterOperation op = byKeyOp;
        ArrayList<String> dotPath = new ArrayList<String>();
        dotPath.add(part.getProperty().toDotPath());
        Object object = this.queryParameters.get(0);
        if (object instanceof CriteriaDefinition.AerospikeQueryCriterion) {
            CriteriaDefinition.AerospikeQueryCriterion queryCriterion = (CriteriaDefinition.AerospikeQueryCriterion)((Object)object);
            switch (queryCriterion) {
                case KEY: {
                    op = keysOp;
                    AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(1));
                    qb.setMapKeyPlaceholder();
                    break;
                }
                case VALUE: {
                    op = valuesOp;
                    AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(1));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported parameter: " + queryCriterion);
                }
            }
        }
        return AerospikeQueryCreatorUtils.setQualifier(qb, fieldName, op, part, dotPath, this.versionSupport);
    }

    private Qualifier processMapOtherThanContaining(QueryQualifierBuilder qb, Part part, List<Object> queryParameters, FilterOperation op, String fieldName) {
        Object param1 = queryParameters.get(0);
        List<String> dotPath = List.of(part.getProperty().toDotPath(), Value.get((Object)param1).toString());
        if (queryParameters.size() == 3) {
            op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(op);
        }
        AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, queryParameters.get(0));
        AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, queryParameters.get(1));
        return AerospikeQueryCreatorUtils.setQualifier(qb, fieldName, op, part, dotPath, this.versionSupport);
    }

    private Qualifier processMapMultipleParams(QueryQualifierBuilder qb) {
        if (this.filterOperation == FilterOperation.CONTAINING || this.filterOperation == FilterOperation.NOT_CONTAINING) {
            return this.processMapMultipleParamsContaining(qb, this.part, this.queryParameters, this.filterOperation, this.fieldName, this.isNested);
        }
        return this.processMapOtherThanContaining(qb, this.part, this.queryParameters, this.filterOperation, this.fieldName);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Qualifier processMapMultipleParamsContaining(QueryQualifierBuilder qb, Part part, List<Object> params, FilterOperation op, String fieldName, boolean isNested) {
        Value key;
        Object firstParam = params.get(0);
        if (!(firstParam instanceof CriteriaDefinition.AerospikeQueryCriterion)) throw new UnsupportedOperationException(String.format("Unsupported combination of operation %s and the first parameter %s", new Object[]{op, firstParam}));
        CriteriaDefinition.AerospikeQueryCriterion queryCriterion = (CriteriaDefinition.AerospikeQueryCriterion)((Object)firstParam);
        if (queryCriterion != CriteriaDefinition.AerospikeQueryCriterion.KEY_VALUE_PAIR) throw new UnsupportedOperationException("Unsupported parameter: " + queryCriterion);
        if (isNested) {
            switch (op) {
                case CONTAINING: 
                case EQ: {
                    op = FilterOperation.MAP_VAL_CONTAINING_BY_KEY;
                    break;
                }
                case NOT_CONTAINING: 
                case NOTEQ: {
                    op = FilterOperation.MAP_VAL_NOT_CONTAINING_BY_KEY;
                }
            }
            key = AerospikeQueryCreatorUtils.getValueOfQueryParameter(this.property.getFieldName());
            AerospikeQueryCreatorUtils.setQualifierBuilderSecondKey(qb, params.get(1));
        } else {
            switch (op) {
                case CONTAINING: 
                case EQ: {
                    op = FilterOperation.MAP_VAL_EQ_BY_KEY;
                    break;
                }
                case NOT_CONTAINING: 
                case NOTEQ: {
                    op = FilterOperation.MAP_VAL_NOTEQ_BY_KEY;
                }
            }
            key = AerospikeQueryCreatorUtils.getValueOfQueryParameter(params.get(1));
        }
        qb.setKey(key);
        List<String> dotPath = List.of(part.getProperty().toDotPath(), key.toString());
        AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, params.get(2));
        if (op != FilterOperation.MAP_VAL_CONTAINING_BY_KEY && op != FilterOperation.MAP_VAL_NOT_CONTAINING_BY_KEY && op != FilterOperation.MAP_VAL_EQ_BY_KEY && op != FilterOperation.MAP_VAL_NOTEQ_BY_KEY) return AerospikeQueryCreatorUtils.qualifierAndConcatenated(this.versionSupport, params, qb, part, fieldName, op, dotPath);
        return AerospikeQueryCreatorUtils.setQualifier(qb, fieldName, op, part, dotPath, this.versionSupport);
    }
}

