/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.query;

import com.aerospike.client.Value;
import java.util.Collection;
import java.util.List;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.IAerospikeQueryCreator;
import org.springframework.data.aerospike.repository.query.QueryQualifierBuilder;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.mapping.PropertyPath;
import org.springframework.data.repository.query.parser.Part;

public class SimplePropertyQueryCreator
implements IAerospikeQueryCreator {
    private final Part part;
    private final PropertyPath propertyPath;
    private final AerospikePersistentProperty property;
    private final String fieldName;
    private final List<Object> queryParameters;
    private final FilterOperation filterOperation;
    private final MappingAerospikeConverter converter;
    private final boolean isNested;
    private ServerVersionSupport versionSupport;
    private final boolean isBooleanQuery;

    public SimplePropertyQueryCreator(Part part, PropertyPath propertyPath, AerospikePersistentProperty property, String fieldName, List<Object> queryParameters, FilterOperation filterOperation, MappingAerospikeConverter converter, boolean isNested, ServerVersionSupport versionSupport) {
        this.part = part;
        this.isBooleanQuery = part.getType() == Part.Type.FALSE || part.getType() == Part.Type.TRUE;
        this.propertyPath = propertyPath;
        this.property = property;
        this.fieldName = fieldName;
        this.queryParameters = queryParameters;
        this.filterOperation = filterOperation;
        this.converter = converter;
        this.isNested = isNested;
        this.versionSupport = versionSupport;
    }

    @Override
    public void validate() {
        String queryPartDescription = String.join((CharSequence)" ", this.propertyPath.toString(), this.filterOperation.toString());
        switch (this.filterOperation) {
            case CONTAINING: 
            case NOT_CONTAINING: 
            case GT: 
            case GTEQ: 
            case LT: 
            case LTEQ: 
            case LIKE: 
            case STARTS_WITH: 
            case ENDS_WITH: 
            case EQ: 
            case NOTEQ: {
                this.validateSimplePropertyQueryComparison(queryPartDescription, this.queryParameters);
                this.validateSimplePropertyContaining(queryPartDescription, this.queryParameters, this.filterOperation, this.propertyPath);
                break;
            }
            case IN: 
            case NOT_IN: {
                this.validateSimplePropertyQueryComparison(queryPartDescription, this.queryParameters);
                break;
            }
            case BETWEEN: {
                this.validateSimplePropertyQueryBetween(queryPartDescription, this.queryParameters);
                break;
            }
            case IS_NOT_NULL: 
            case IS_NULL: {
                AerospikeQueryCreatorUtils.validateQueryIsNull(this.queryParameters, queryPartDescription);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported operation: " + queryPartDescription);
            }
        }
        AerospikeQueryCreatorUtils.validateTypes(this.converter, this.propertyPath, this.queryParameters, this.filterOperation, queryPartDescription);
    }

    private void validateSimplePropertyContaining(String queryPartDescription, List<Object> queryParameters, FilterOperation filterOperation, PropertyPath propertyPath) {
        if (!(filterOperation != FilterOperation.CONTAINING && filterOperation != FilterOperation.NOT_CONTAINING || propertyPath.getType().equals(String.class) && queryParameters.get(0) instanceof String)) {
            throw new IllegalArgumentException(queryPartDescription + ": expecting both property and argument to be a String");
        }
    }

    private void validateSimplePropertyQueryComparison(String queryPartDescription, List<Object> queryParameters) {
        int paramsSize = queryParameters.size();
        if (paramsSize != 1 && !this.isBooleanQuery) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting one");
        }
        if (this.isBooleanQuery && paramsSize != 0) {
            throw new IllegalArgumentException(queryPartDescription + ": no arguments expected");
        }
    }

    private void validateSimplePropertyInQueryTypes(String queryPartDescription, List<Object> queryParameters) {
        Object param1 = queryParameters.get(0);
        if (param1 instanceof Collection) {
            AerospikeQueryCreatorUtils.validateTypes(this.converter, Collection.class, queryParameters, this.filterOperation, queryPartDescription, new String[0]);
        }
    }

    private void validateSimplePropertyQueryBetween(String queryPartDescription, List<Object> queryParameters) {
        if (queryParameters.size() != 2) {
            throw new IllegalArgumentException(queryPartDescription + ": invalid number of arguments, expecting two");
        }
    }

    @Override
    public Qualifier process() {
        QueryQualifierBuilder qb = new QueryQualifierBuilder();
        if (this.isBooleanQuery) {
            this.queryParameters.add(Value.get((boolean)this.convertPartTypeToBoolean(this.part.getType())));
        }
        if (this.filterOperation == FilterOperation.BETWEEN) {
            AerospikeQueryCreatorUtils.setQualifierBuilderSecondValue(qb, this.queryParameters.get(1));
        }
        if (this.filterOperation == FilterOperation.CONTAINING || this.filterOperation == FilterOperation.NOT_CONTAINING) {
            qb.setNestedType(3);
        }
        List<String> dotPath = null;
        FilterOperation op = this.filterOperation;
        if (this.isNested) {
            op = AerospikeQueryCreatorUtils.getCorrespondingMapValueFilterOperationOrFail(op);
            dotPath = List.of(this.part.getProperty().toDotPath());
        }
        if (this.queryParameters.isEmpty() && (this.filterOperation == FilterOperation.IS_NOT_NULL || this.filterOperation == FilterOperation.IS_NULL)) {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.property.getFieldName());
        } else {
            AerospikeQueryCreatorUtils.setQualifierBuilderValue(qb, this.queryParameters.get(0));
            if (this.isNested) {
                AerospikeQueryCreatorUtils.setQualifierBuilderKey(qb, this.property.getFieldName());
            }
        }
        return AerospikeQueryCreatorUtils.setQualifier(qb, this.fieldName, op, this.part, dotPath, this.versionSupport);
    }

    private boolean convertPartTypeToBoolean(Part.Type type) {
        if (type == Part.Type.FALSE) {
            return false;
        }
        if (type == Part.Type.TRUE) {
            return true;
        }
        throw new IllegalStateException("Unexpected Part.Type: not boolean");
    }
}

