/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.util;

import lombok.Generated;
import org.springframework.data.aerospike.query.FilterOperation;

public final class FilterOperationRegexpBuilder {
    private static final Character BACKSLASH = Character.valueOf('\\');
    private static final Character DOT = Character.valueOf('.');
    private static final Character ASTERISK = Character.valueOf('*');
    private static final Character DOLLAR = Character.valueOf('$');
    private static final Character OPEN_BRACKET = Character.valueOf('[');
    private static final Character CIRCUMFLEX = Character.valueOf('^');

    public static String escapeBRERegexp(String base) {
        StringBuilder builder = new StringBuilder();
        for (char stringChar : base.toCharArray()) {
            if (stringChar == BACKSLASH.charValue() || stringChar == DOT.charValue() || stringChar == ASTERISK.charValue() || stringChar == DOLLAR.charValue() || stringChar == OPEN_BRACKET.charValue() || stringChar == CIRCUMFLEX.charValue()) {
                builder.append(BACKSLASH);
            }
            builder.append(stringChar);
        }
        return builder.toString();
    }

    private static String getRegexp(String base, FilterOperation op) {
        String escapedBase = FilterOperationRegexpBuilder.escapeBRERegexp(base);
        return switch (op) {
            case FilterOperation.STARTS_WITH -> "^" + escapedBase;
            case FilterOperation.ENDS_WITH -> escapedBase + "$";
            case FilterOperation.EQ -> "^" + escapedBase + "$";
            default -> escapedBase;
        };
    }

    public static String getStartsWith(String base) {
        return FilterOperationRegexpBuilder.getRegexp(base, FilterOperation.STARTS_WITH);
    }

    public static String getEndsWith(String base) {
        return FilterOperationRegexpBuilder.getRegexp(base, FilterOperation.ENDS_WITH);
    }

    public static String getContaining(String base) {
        return FilterOperationRegexpBuilder.getRegexp(base, FilterOperation.CONTAINING);
    }

    public static String getNotContaining(String base) {
        return FilterOperationRegexpBuilder.getRegexp(base, FilterOperation.NOT_CONTAINING);
    }

    public static String getStringEquals(String base) {
        return FilterOperationRegexpBuilder.getRegexp(base, FilterOperation.EQ);
    }

    @Generated
    private FilterOperationRegexpBuilder() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

