/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.util;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.listener.InfoListener;
import com.aerospike.client.policy.InfoPolicy;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.TimeUnit;
import lombok.Generated;

public final class InfoCommandUtils {
    public static String request(IAerospikeClient client, Node node, String command) {
        return InfoCommandUtils.request(client, client.getInfoPolicyDefault(), node, command);
    }

    public static String request(IAerospikeClient client, InfoPolicy infoPolicy, Node node, final String command) {
        String value;
        InfoListenerWithStringValue listener = new InfoListenerWithStringValue(){
            private final CompletableFuture<String> stringValueFuture = new CompletableFuture();

            @Override
            public CompletableFuture<String> getValueFuture() {
                return this.stringValueFuture;
            }

            public void onSuccess(Map<String, String> map) {
                try {
                    this.stringValueFuture.complete(map.get(command));
                }
                catch (Exception e) {
                    this.stringValueFuture.completeExceptionally(InfoCommandUtils.commandFailed(command, e));
                }
            }

            public void onFailure(AerospikeException ae) {
                this.stringValueFuture.completeExceptionally(ae);
            }
        };
        try {
            client.info(client.getCluster().eventLoops.next(), (InfoListener)listener, infoPolicy, node, new String[]{command});
        }
        catch (AerospikeException ae) {
            throw InfoCommandUtils.commandFailed(command, ae);
        }
        try {
            value = listener.getValueFuture().orTimeout(infoPolicy.timeout, TimeUnit.MILLISECONDS).join();
        }
        catch (CompletionException ce) {
            throw InfoCommandUtils.commandFailed(command, ce.getCause());
        }
        return value == null ? "" : value;
    }

    private static AerospikeException commandFailed(String command, Throwable t) {
        return new AerospikeException(String.format("Info command %s failed", command), t);
    }

    @Generated
    private InfoCommandUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static interface InfoListenerWithStringValue
    extends InfoListener {
        public CompletableFuture<String> getValueFuture();
    }
}

