/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.index.BaseAerospikePersistenceEntityIndexCreator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;

public class AerospikePersistenceEntityIndexCreator
extends BaseAerospikePersistenceEntityIndexCreator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AerospikePersistenceEntityIndexCreator.class);
    private final ObjectProvider<AerospikeTemplate> template;

    public AerospikePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> mappingContext, boolean createIndexesOnStartup, AerospikeIndexResolver aerospikeIndexResolver, ObjectProvider<AerospikeTemplate> template) {
        super(mappingContext, createIndexesOnStartup, aerospikeIndexResolver);
        this.template = template;
    }

    @Override
    protected void installIndexes(Set<AerospikeIndexDefinition> indexes) {
        indexes.forEach(this::installIndex);
    }

    private void installIndex(AerospikeIndexDefinition index) {
        log.debug("Installing aerospike index: {}...", (Object)index);
        try {
            if (index.getCtx() == null) {
                ((AerospikeTemplate)this.template.getIfUnique()).createIndex(index.getEntityClass(), index.getName(), index.getBin(), index.getType(), index.getCollectionType());
            } else {
                ((AerospikeTemplate)this.template.getIfUnique()).createIndex(index.getEntityClass(), index.getName(), index.getBin(), index.getType(), index.getCollectionType(), index.getCtx());
            }
            log.info("Installed aerospike index: {} successfully.", (Object)index);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to install aerospike index: " + index, e);
        }
    }
}

