/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.mapping;

import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.Document;
import org.springframework.data.mapping.MappingException;
import org.springframework.data.mapping.PersistentProperty;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class BasicAerospikePersistentEntity<T>
extends BasicPersistentEntity<T, AerospikePersistentProperty>
implements AerospikePersistentEntity<T>,
EnvironmentAware {
    static final int DEFAULT_EXPIRATION = 0;
    private final Lazy<String> setName = Lazy.of(() -> {
        Class type = this.getType();
        Document annotation = type.getAnnotation(Document.class);
        if (annotation != null && !annotation.collection().isEmpty()) {
            Assert.notNull((Object)this.environment, (String)"Environment must be set to use 'collection'");
            return this.environment.resolveRequiredPlaceholders(annotation.collection());
        }
        return type.getSimpleName();
    });
    private final Lazy<Integer> expiration = Lazy.of(() -> {
        Document annotation = this.getType().getAnnotation(Document.class);
        if (annotation == null) {
            return 0;
        }
        int expirationValue = this.getExpirationValue(annotation);
        if (expirationValue <= 0) {
            return expirationValue;
        }
        return (int)annotation.expirationUnit().toSeconds(expirationValue);
    });
    private final Lazy<Boolean> isTouchOnRead = Lazy.of(() -> {
        Document annotation = this.getType().getAnnotation(Document.class);
        return annotation != null && annotation.touchOnRead();
    });
    private AerospikePersistentProperty expirationProperty;
    private Environment environment;

    public BasicAerospikePersistentEntity(TypeInformation<T> information) {
        super(information);
    }

    public void addPersistentProperty(AerospikePersistentProperty property) {
        super.addPersistentProperty((PersistentProperty)property);
        if (property.isExpirationProperty()) {
            if (this.expirationProperty != null) {
                String message = String.format("Attempt to add expiration property %s but already have property %s registered as expiration. Check your mapping configuration!", property.getField(), this.expirationProperty.getField());
                throw new MappingException(message);
            }
            this.expirationProperty = property;
        }
    }

    @Override
    public String getSetName() {
        return (String)this.setName.get();
    }

    @Override
    public int getExpiration() {
        return (Integer)this.expiration.get();
    }

    @Override
    public boolean isTouchOnRead() {
        return (Boolean)this.isTouchOnRead.get();
    }

    @Override
    public AerospikePersistentProperty getExpirationProperty() {
        return this.expirationProperty;
    }

    @Override
    public boolean hasExpirationProperty() {
        return this.expirationProperty != null;
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private int getExpirationValue(Document annotation) {
        int expiration = annotation.expiration();
        String expressionString = annotation.expirationExpression();
        if (StringUtils.hasLength((String)expressionString)) {
            Assert.state((expiration == 0 ? 1 : 0) != 0, (String)"Both 'expiration' and 'expirationExpression' are set");
            Assert.notNull((Object)this.environment, (String)"Environment must be set to use 'expirationExpression'");
            String resolvedExpression = this.environment.resolveRequiredPlaceholders(expressionString);
            try {
                return Integer.parseInt(resolvedExpression);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid Integer value for expiration expression: " + resolvedExpression);
            }
        }
        return expiration;
    }
}

