/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import com.aerospike.client.exp.ListExp;
import com.aerospike.client.exp.MapExp;
import com.aerospike.client.query.Filter;
import com.aerospike.client.query.IndexCollectionType;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import org.springframework.data.aerospike.config.AerospikeDataSettings;
import org.springframework.data.aerospike.query.qualifier.MetadataQualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.query.qualifier.QualifierBuilder;
import org.springframework.data.aerospike.query.qualifier.QualifierKey;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreatorUtils;
import org.springframework.data.aerospike.repository.query.CriteriaDefinition;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.aerospike.util.FilterOperationRegexpBuilder;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.data.util.Pair;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum FilterOperation {
    AND{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Qualifier[] qs = (Qualifier[])qualifierMap.get((Object)QualifierKey.QUALIFIERS);
            if (qs == null || qs.length <= 0) {
                throw new IllegalArgumentException("Expecting qualifiers not to be null with AND filter operation");
            }
            Exp[] childrenExp = new Exp[qs.length];
            if (qs.length > 1) {
                for (int i = 0; i < qs.length; ++i) {
                    childrenExp[i] = qs[i].getFilterExp();
                }
            } else {
                return qs[0].getFilterExp();
            }
            return Exp.and((Exp[])childrenExp);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    OR{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Qualifier[] qs = (Qualifier[])qualifierMap.get((Object)QualifierKey.QUALIFIERS);
            if (qs == null || qs.length <= 0) {
                throw new IllegalArgumentException("Expecting qualifiers not to be null with OR filter operation");
            }
            Exp[] childrenExp = new Exp[qs.length];
            if (qs.length > 1) {
                for (int i = 0; i < qs.length; ++i) {
                    childrenExp[i] = qs[i].getFilterExp();
                }
            } else {
                return qs[0].getFilterExp();
            }
            return Exp.or((Exp[])childrenExp);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    IN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Collection<?> collection = FilterOperation.getValueAsCollectionOrFail(qualifierMap);
                Exp[] arrElementsExp = (Exp[])collection.stream().map(item -> ((QualifierBuilder)((QualifierBuilder)Qualifier.builder().setPath(3.getBinName(qualifierMap)).setFilterOperation(EQ)).setValue(item)).build().getFilterExp()).toArray(Exp[]::new);
                return arrElementsExp.length > 1 ? Exp.or((Exp[])arrElementsExp) : arrElementsExp[0];
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    NOT_IN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Collection<?> collection = FilterOperation.getValueAsCollectionOrFail(qualifierMap);
                Exp[] arrElementsExp = (Exp[])collection.stream().map(item -> ((QualifierBuilder)((QualifierBuilder)Qualifier.builder().setPath(4.getBinName(qualifierMap)).setFilterOperation(NOTEQ)).setValue(item)).build().getFilterExp()).toArray(Exp[]::new);
                return arrElementsExp.length > 1 ? Exp.and((Exp[])arrElementsExp) : arrElementsExp[0];
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    EQ{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Value value = 5.getValue(qualifierMap);
                return switch (value.getType()) {
                    case 1 -> Exp.eq((Exp)Exp.intBin((String)5.getBinName(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                    case 3 -> {
                        if (5.ignoreCase(qualifierMap).booleanValue()) {
                            String equalsRegexp = FilterOperationRegexpBuilder.getStringEquals(value.toString());
                            yield Exp.regexCompare((String)equalsRegexp, (int)2, (Exp)Exp.stringBin((String)5.getBinName(qualifierMap)));
                        }
                        yield Exp.eq((Exp)Exp.stringBin((String)5.getBinName(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                    }
                    case 17 -> Exp.eq((Exp)Exp.boolBin((String)5.getBinName(qualifierMap)), (Exp)Exp.val((boolean)((Boolean)value.getObject())));
                    case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 5.getBinName(qualifierMap), Exp::eq, Exp::mapBin);
                    case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 5.getBinName(qualifierMap), Exp::eq, Exp::listBin);
                    case 4 -> Exp.eq((Exp)Exp.blobBin((String)5.getBinName(qualifierMap)), (Exp)Exp.val((byte[])((byte[])value.getObject())));
                    default -> throw new IllegalArgumentException("EQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
                };
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            Value value = 5.getValue(qualifierMap);
            return switch (value.getType()) {
                case 1 -> Filter.equal((String)5.getBinName(qualifierMap), (long)value.toLong(), (CTX[])new CTX[0]);
                case 3 -> {
                    if (5.ignoreCase(qualifierMap).booleanValue()) {
                        yield null;
                    }
                    yield Filter.equal((String)5.getBinName(qualifierMap), (String)value.toString(), (CTX[])new CTX[0]);
                }
                case 4 -> {
                    if (!FilterOperation.getServerVersionSupport(qualifierMap).isServerVersionGtOrEq7()) {
                        yield null;
                    }
                    yield Filter.equal((String)5.getBinName(qualifierMap), (byte[])((byte[])value.getObject()), (CTX[])new CTX[0]);
                }
                default -> null;
            };
        }
    }
    ,
    NOTEQ{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Value value = 6.getValue(qualifierMap);
                Exp ne = switch (value.getType()) {
                    case 1 -> Exp.ne((Exp)Exp.intBin((String)6.getBinName(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                    case 3 -> {
                        if (6.ignoreCase(qualifierMap).booleanValue()) {
                            String equalsRegexp = FilterOperationRegexpBuilder.getStringEquals(value.toString());
                            yield Exp.not((Exp)Exp.regexCompare((String)equalsRegexp, (int)2, (Exp)Exp.stringBin((String)6.getBinName(qualifierMap))));
                        }
                        yield Exp.ne((Exp)Exp.stringBin((String)6.getBinName(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                    }
                    case 17 -> Exp.ne((Exp)Exp.boolBin((String)6.getBinName(qualifierMap)), (Exp)Exp.val((boolean)((Boolean)value.getObject())));
                    case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 6.getBinName(qualifierMap), Exp::ne, Exp::mapBin);
                    case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 6.getBinName(qualifierMap), Exp::ne, Exp::listBin);
                    default -> throw new IllegalArgumentException("NOTEQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
                };
                return Exp.or((Exp[])new Exp[]{Exp.not((Exp)Exp.binExists((String)6.getBinName(qualifierMap))), ne});
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    GT{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Value value = 7.getValue(qualifierMap);
                return switch (value.getType()) {
                    case 1 -> Exp.gt((Exp)Exp.intBin((String)7.getBinName(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                    case 3 -> Exp.gt((Exp)Exp.stringBin((String)7.getBinName(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                    case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 7.getBinName(qualifierMap), Exp::gt, Exp::mapBin);
                    case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 7.getBinName(qualifierMap), Exp::gt, Exp::listBin);
                    default -> throw new IllegalArgumentException("GT FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
                };
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (7.getValue(qualifierMap).getType() != 1 || 7.getValue(qualifierMap).toLong() == Long.MAX_VALUE) {
                return null;
            }
            return Filter.range((String)7.getBinName(qualifierMap), (long)(7.getValue(qualifierMap).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    GTEQ{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Value value = 8.getValue(qualifierMap);
                return switch (value.getType()) {
                    case 1 -> Exp.ge((Exp)Exp.intBin((String)8.getBinName(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                    case 3 -> Exp.ge((Exp)Exp.stringBin((String)8.getBinName(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                    case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 8.getBinName(qualifierMap), Exp::ge, Exp::mapBin);
                    case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 8.getBinName(qualifierMap), Exp::ge, Exp::listBin);
                    default -> throw new IllegalArgumentException("GTEQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
                };
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (8.getValue(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)8.getBinName(qualifierMap), (long)8.getValue(qualifierMap).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    LT{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Value value = 9.getValue(qualifierMap);
                return switch (value.getType()) {
                    case 1 -> Exp.lt((Exp)Exp.intBin((String)9.getBinName(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                    case 3 -> Exp.lt((Exp)Exp.stringBin((String)9.getBinName(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                    case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 9.getBinName(qualifierMap), Exp::lt, Exp::mapBin);
                    case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 9.getBinName(qualifierMap), Exp::lt, Exp::listBin);
                    default -> throw new IllegalArgumentException("LT FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
                };
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (9.getValue(qualifierMap).getType() != 1 || 9.getValue(qualifierMap).toLong() == Long.MIN_VALUE) {
                return null;
            }
            return Filter.range((String)9.getBinName(qualifierMap), (long)Long.MIN_VALUE, (long)(9.getValue(qualifierMap).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    LTEQ{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> {
                Value value = 10.getValue(qualifierMap);
                return switch (value.getType()) {
                    case 1 -> Exp.le((Exp)Exp.intBin((String)10.getBinName(qualifierMap)), (Exp)Exp.val((long)value.toLong()));
                    case 3 -> Exp.le((Exp)Exp.stringBin((String)10.getBinName(qualifierMap)), (Exp)Exp.val((String)value.toString()));
                    case 19 -> FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 10.getBinName(qualifierMap), Exp::le, Exp::mapBin);
                    case 20 -> FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 10.getBinName(qualifierMap), Exp::le, Exp::listBin);
                    default -> throw new IllegalArgumentException("LTEQ FilterExpression unsupported particle type: " + value.getClass().getSimpleName());
                };
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (10.getValue(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)10.getBinName(qualifierMap), (long)Long.MIN_VALUE, (long)10.getValue(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    BETWEEN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Value value = 11.getValue(qualifierMap);
            Value value2 = 11.getSecondValue(qualifierMap);
            return FilterOperation.getMetadataExp(qualifierMap).orElseGet(() -> switch (value.getType()) {
                case 1 -> Exp.and((Exp[])new Exp[]{Exp.ge((Exp)Exp.intBin((String)11.getBinName(qualifierMap)), (Exp)Exp.val((long)value.toLong())), Exp.lt((Exp)Exp.intBin((String)11.getBinName(qualifierMap)), (Exp)Exp.val((long)value2.toLong()))});
                case 3 -> Exp.and((Exp[])new Exp[]{Exp.ge((Exp)Exp.stringBin((String)11.getBinName(qualifierMap)), (Exp)Exp.val((String)value.toString())), Exp.lt((Exp)Exp.stringBin((String)11.getBinName(qualifierMap)), (Exp)Exp.val((String)value2.toString()))});
                case 19 -> Exp.and((Exp[])new Exp[]{FilterOperation.getFilterExp(Exp.val((Map)((Map)value.getObject())), 11.getBinName(qualifierMap), Exp::ge, Exp::mapBin), FilterOperation.getFilterExp(Exp.val((Map)((Map)value2.getObject())), 11.getBinName(qualifierMap), Exp::lt, Exp::mapBin)});
                case 20 -> Exp.and((Exp[])new Exp[]{FilterOperation.getFilterExp(Exp.val((List)((List)value.getObject())), 11.getBinName(qualifierMap), Exp::ge, Exp::listBin), FilterOperation.getFilterExp(Exp.val((List)((List)value2.getObject())), 11.getBinName(qualifierMap), Exp::lt, Exp::listBin)});
                default -> throw new IllegalArgumentException("BETWEEN: unexpected value of type " + value.getClass().getSimpleName());
            });
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (11.getValue(qualifierMap).getType() != 1 || 11.getSecondValue(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)11.getBinName(qualifierMap), (long)11.getValue(qualifierMap).toLong(), (long)11.getSecondValue(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    STARTS_WITH{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String startWithRegexp = FilterOperationRegexpBuilder.getStartsWith(12.getValue(qualifierMap).toString());
            return Exp.regexCompare((String)startWithRegexp, (int)12.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)12.getBinName(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    ENDS_WITH{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String endWithRegexp = FilterOperationRegexpBuilder.getEndsWith(13.getValue(qualifierMap).toString());
            return Exp.regexCompare((String)endWithRegexp, (int)13.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)13.getBinName(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    CONTAINING{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String containingRegexp = FilterOperationRegexpBuilder.getContaining(14.getValue(qualifierMap).toString());
            return Exp.regexCompare((String)containingRegexp, (int)14.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)14.getBinName(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    NOT_CONTAINING{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String notContainingRegexp = FilterOperationRegexpBuilder.getNotContaining(15.getValue(qualifierMap).toString());
            return Exp.or((Exp[])new Exp[]{Exp.not((Exp)Exp.binExists((String)15.getBinName(qualifierMap))), Exp.not((Exp)Exp.regexCompare((String)notContainingRegexp, (int)15.regexFlags(qualifierMap), (Exp)Exp.stringBin((String)15.getBinName(qualifierMap))))});
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    LIKE{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            int flags = 1;
            if (16.ignoreCase(qualifierMap).booleanValue()) {
                flags = 3;
            }
            if (16.hasId(qualifierMap)) {
                return Exp.regexCompare((String)16.getValue(qualifierMap).toString(), (int)flags, (Exp)Exp.key((Exp.Type)Exp.Type.STRING));
            }
            return Exp.regexCompare((String)16.getValue(qualifierMap).toString(), (int)flags, (Exp)Exp.stringBin((String)16.getBinName(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_EQ_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValEqOrFail(qualifierMap, Exp::eq);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return switch (17.getValue(qualifierMap).getType()) {
                case 3 -> {
                    if (17.ignoreCase(qualifierMap).booleanValue()) {
                        yield null;
                    }
                    yield Filter.contains((String)17.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (String)17.getValue(qualifierMap).toString(), (CTX[])17.getCtxArr(qualifierMap));
                }
                case 1 -> Filter.range((String)17.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)17.getValue(qualifierMap).toLong(), (long)17.getValue(qualifierMap).toLong(), (CTX[])17.getCtxArr(qualifierMap));
                default -> null;
            };
        }
    }
    ,
    MAP_VAL_NOTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Exp binIsNull = Exp.not((Exp)Exp.binExists((String)18.getBinName(qualifierMap)));
            String errMsg = "MAP_VAL_NOTEQ_BY_KEY FilterExpression unsupported type: got " + 18.getKey(qualifierMap).getClass().getSimpleName();
            Exp keyIsNull = FilterOperation.mapKeysCountComparedToZero(qualifierMap, Exp::eq, 18.getKey(qualifierMap), errMsg);
            return Exp.or((Exp[])new Exp[]{binIsNull, keyIsNull, FilterOperation.getFilterExpMapValNotEqOrFail(qualifierMap, Exp::ne)});
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_IN_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Collection<?> collection = FilterOperation.getValueAsCollectionOrFail(qualifierMap);
            Object pathPart = 19.getKey(qualifierMap).toString();
            if (19.getCtxArr(qualifierMap) != null) {
                pathPart = 19.getCtxArrAsString(qualifierMap) + (String)pathPart;
            }
            String path = String.join((CharSequence)".", new CharSequence[]{19.getBinName(qualifierMap), pathPart});
            Exp[] arrElementsExp = (Exp[])collection.stream().map(item -> ((QualifierBuilder)((QualifierBuilder)Qualifier.builder().setFilterOperation(MAP_VAL_EQ_BY_KEY)).setPath(path).setValue(item)).build().getFilterExp()).toArray(Exp[]::new);
            return Exp.or((Exp[])arrElementsExp);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_NOT_IN_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Collection<?> collection = FilterOperation.getValueAsCollectionOrFail(qualifierMap);
            Object pathPart = 20.getKey(qualifierMap).toString();
            if (20.getCtxArr(qualifierMap) != null) {
                pathPart = 20.getCtxArrAsString(qualifierMap) + (String)pathPart;
            }
            String path = String.join((CharSequence)".", new CharSequence[]{20.getBinName(qualifierMap), pathPart});
            Exp[] arrElementsExp = (Exp[])collection.stream().map(item -> ((QualifierBuilder)((QualifierBuilder)Qualifier.builder().setFilterOperation(MAP_VAL_NOTEQ_BY_KEY)).setPath(path).setValue(item)).build().getFilterExp()).toArray(Exp[]::new);
            return Exp.and((Exp[])arrElementsExp);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_GT_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::gt, "MAP_VAL_GT_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (21.getKey(qualifierMap).getType() != 1 || 21.getKey(qualifierMap).toLong() == Long.MAX_VALUE) {
                return null;
            }
            return Filter.range((String)21.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)(21.getKey(qualifierMap).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])21.getCtxArr(qualifierMap));
        }
    }
    ,
    MAP_VAL_GTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::ge, "MAP_VAL_GTEQ_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (22.getKey(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)22.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)22.getKey(qualifierMap).toLong(), (long)Long.MAX_VALUE, (CTX[])22.getCtxArr(qualifierMap));
        }
    }
    ,
    MAP_VAL_LT_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::lt, "MAP_VAL_LT_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (23.getKey(qualifierMap).getType() != 1 || 23.getKey(qualifierMap).toLong() == Long.MIN_VALUE) {
                return null;
            }
            return Filter.range((String)23.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)Long.MIN_VALUE, (long)(23.getKey(qualifierMap).toLong() - 1L), (CTX[])23.getCtxArr(qualifierMap));
        }
    }
    ,
    MAP_VAL_LTEQ_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.getFilterExpMapValOrFail(qualifierMap, Exp::le, "MAP_VAL_LTEQ_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (24.getValue(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)24.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)Long.MIN_VALUE, (long)24.getValue(qualifierMap).toLong(), (CTX[])24.getCtxArr(qualifierMap));
        }
    }
    ,
    MAP_VAL_BETWEEN_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Exp upperLimit;
            Exp lowerLimit;
            CTX[] ctxArr = 25.getCtxArr(qualifierMap);
            return FilterOperation.mapValBetweenByKey(qualifierMap, ctxArr, switch (25.getValue(qualifierMap).getType()) {
                case 1 -> {
                    lowerLimit = Exp.val((long)25.getValue(qualifierMap).toLong());
                    upperLimit = Exp.val((long)25.getSecondValue(qualifierMap).toLong());
                    yield Exp.Type.INT;
                }
                case 3 -> {
                    lowerLimit = Exp.val((String)25.getValue(qualifierMap).toString());
                    upperLimit = Exp.val((String)25.getSecondValue(qualifierMap).toString());
                    yield Exp.Type.STRING;
                }
                case 20 -> {
                    lowerLimit = Exp.val((List)((List)25.getValue(qualifierMap).getObject()));
                    upperLimit = Exp.val((List)((List)25.getSecondValue(qualifierMap).getObject()));
                    yield Exp.Type.LIST;
                }
                case 19 -> {
                    lowerLimit = Exp.val((Map)((Map)25.getValue(qualifierMap).getObject()));
                    upperLimit = Exp.val((Map)((Map)25.getSecondValue(qualifierMap).getObject()));
                    yield Exp.Type.MAP;
                }
                default -> throw new IllegalArgumentException("MAP_VAL_BETWEEN_BY_KEY FilterExpression unsupported type: got " + 25.getValue(qualifierMap).getClass().getSimpleName());
            }, lowerLimit, upperLimit);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (25.getValue(qualifierMap).getType() != 1 || 25.getSecondValue(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)25.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.MAPVALUES, (long)25.getValue(qualifierMap).toLong(), (long)25.getSecondValue(qualifierMap).toLong(), (CTX[])25.getCtxArr(qualifierMap));
        }
    }
    ,
    MAP_VAL_STARTS_WITH_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String startWithRegexp = FilterOperationRegexpBuilder.getStartsWith(26.getValue(qualifierMap).toString());
            return Exp.regexCompare((String)startWithRegexp, (int)26.regexFlags(qualifierMap), (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)26.getKey(qualifierMap).toString()), (Exp)Exp.mapBin((String)26.getBinName(qualifierMap)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_LIKE_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            int flags = 1;
            if (27.ignoreCase(qualifierMap).booleanValue()) {
                flags = 3;
            }
            return Exp.regexCompare((String)27.getValue(qualifierMap).toString(), (int)flags, (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)27.getKey(qualifierMap).toString()), (Exp)Exp.mapBin((String)27.getBinName(qualifierMap)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_ENDS_WITH_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String endWithRegexp = FilterOperationRegexpBuilder.getEndsWith(28.getKey(qualifierMap).toString());
            return Exp.regexCompare((String)endWithRegexp, (int)28.regexFlags(qualifierMap), (Exp)MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)28.getValue(qualifierMap).toString()), (Exp)Exp.mapBin((String)28.getBinName(qualifierMap)), (CTX[])new CTX[0]));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_CONTAINING_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Integer nestedType = FilterOperation.getNestedType(qualifierMap);
            if (nestedType == null) {
                throw new IllegalStateException("Expecting valid nestedType, got null");
            }
            switch (nestedType) {
                case 3: {
                    String containingRegexp = FilterOperationRegexpBuilder.getContaining(29.getValue(qualifierMap).toString());
                    Exp nestedString = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)29.getKey(qualifierMap).toString()), (Exp)Exp.mapBin((String)29.getBinName(qualifierMap)), (CTX[])new CTX[0]);
                    return Exp.regexCompare((String)containingRegexp, (int)29.regexFlags(qualifierMap), (Exp)nestedString);
                }
                case 20: {
                    Exp value = FilterOperation.getExpOrFail(29.getValue(qualifierMap), "MAP_VAL_CONTAINING_BY_KEY");
                    Exp key = FilterOperation.getExpOrFail(29.getKey(qualifierMap), "MAP_VAL_CONTAINING_BY_KEY");
                    Exp nestedList = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.LIST, (Exp)key, (Exp)Exp.mapBin((String)29.getBinName(qualifierMap)), (CTX[])new CTX[0]);
                    return Exp.gt((Exp)ListExp.getByValue((int)5, (Exp)value, (Exp)nestedList, (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                }
                case 19: {
                    Value val = 29.getValue(qualifierMap);
                    Exp value = FilterOperation.getExpOrFail(val, "MAP_VAL_CONTAINING_BY_KEY");
                    Exp key = FilterOperation.getExpOrFail(29.getKey(qualifierMap), "MAP_VAL_CONTAINING_BY_KEY");
                    Exp secondKey = FilterOperation.getExpOrFail(29.getNestedKey(qualifierMap), "MAP_VAL_CONTAINING_BY_KEY");
                    Exp nestedMap = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.MAP, (Exp)key, (Exp)Exp.mapBin((String)29.getBinName(qualifierMap)), (CTX[])new CTX[0]);
                    return Exp.eq((Exp)MapExp.getByKey((int)7, (Exp.Type)Utils.getExpType(val), (Exp)secondKey, (Exp)nestedMap, (CTX[])new CTX[0]), (Exp)value);
                }
            }
            throw new UnsupportedOperationException("Unsupported nested type: " + nestedType);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_NOT_CONTAINING_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Integer nestedType = 30.getNestedType(qualifierMap);
            Exp mapBinDoesNotExist = Exp.not((Exp)Exp.binExists((String)30.getBinName(qualifierMap)));
            Exp key = FilterOperation.getExpOrFail(30.getKey(qualifierMap), "MAP_VAL_NOT_CONTAINING_BY_KEY");
            Exp mapNotContainingKey = Exp.eq((Exp)MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)key, (Exp)Exp.mapBin((String)30.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            if (nestedType == null) {
                throw new IllegalStateException("Expecting valid nestedType, got null");
            }
            switch (nestedType) {
                case 3: {
                    String containingRegexp = FilterOperationRegexpBuilder.getContaining(30.getValue(qualifierMap).toString());
                    Exp nestedString = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.STRING, (Exp)Exp.val((String)30.getKey(qualifierMap).toString()), (Exp)Exp.mapBin((String)30.getBinName(qualifierMap)), (CTX[])new CTX[0]);
                    return Exp.or((Exp[])new Exp[]{mapBinDoesNotExist, mapNotContainingKey, Exp.not((Exp)Exp.regexCompare((String)containingRegexp, (int)30.regexFlags(qualifierMap), (Exp)nestedString))});
                }
                case 20: {
                    Exp value = FilterOperation.getExpOrFail(30.getValue(qualifierMap), "MAP_VAL_NOT_CONTAINING_BY_KEY");
                    Exp nestedList = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.LIST, (Exp)key, (Exp)Exp.mapBin((String)30.getBinName(qualifierMap)), (CTX[])new CTX[0]);
                    Exp nestedListNotContainingValue = Exp.eq((Exp)ListExp.getByValue((int)5, (Exp)value, (Exp)nestedList, (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
                    return Exp.or((Exp[])new Exp[]{mapBinDoesNotExist, mapNotContainingKey, nestedListNotContainingValue});
                }
                case 19: {
                    Value val = 30.getValue(qualifierMap);
                    Exp value = FilterOperation.getExpOrFail(val, "MAP_VAL_NOT_CONTAINING_BY_KEY");
                    Exp secondKey = FilterOperation.getExpOrFail(30.getNestedKey(qualifierMap), "MAP_VAL_NOT_CONTAINING_BY_KEY");
                    Exp nestedMap = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.MAP, (Exp)key, (Exp)Exp.mapBin((String)30.getBinName(qualifierMap)), (CTX[])new CTX[0]);
                    Exp nestedMapNotContainingValueByKey = Exp.ne((Exp)MapExp.getByKey((int)7, (Exp.Type)Utils.getExpType(val), (Exp)secondKey, (Exp)nestedMap, (CTX[])new CTX[0]), (Exp)value);
                    return Exp.or((Exp[])new Exp[]{mapBinDoesNotExist, mapNotContainingKey, nestedMapNotContainingValueByKey});
                }
            }
            throw new UnsupportedOperationException("Unsupported value type: " + nestedType);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_EXISTS_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.mapKeysContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_NOT_EXISTS_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.mapKeysNotContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_IS_NOT_NULL_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String[] dotPathArray = AerospikeQueryCreatorUtils.getDotPathArray(33.getDotPath(qualifierMap));
            if (dotPathArray != null && dotPathArray.length > 1) {
                return FilterOperation.mapKeysContain(qualifierMap);
            }
            return FilterOperation.getMapValEqOrFail(qualifierMap, Exp::eq, "MAP_VAL_IS_NOT_NULL_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VAL_IS_NULL_BY_KEY{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            String[] dotPathArray = AerospikeQueryCreatorUtils.getDotPathArray(34.getDotPath(qualifierMap));
            if (dotPathArray != null && dotPathArray.length > 1) {
                return FilterOperation.mapKeysNotContain(qualifierMap);
            }
            return FilterOperation.getMapValEqOrFail(qualifierMap, Exp::eq, "MAP_VAL_IS_NULL_BY_KEY");
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_KEYS_CONTAIN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.mapKeysContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return this.cdtContains(IndexCollectionType.MAPKEYS, qualifierMap);
        }
    }
    ,
    MAP_KEYS_NOT_CONTAIN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.mapKeysNotContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_VALUES_CONTAIN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.mapValuesContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return this.cdtContains(IndexCollectionType.MAPVALUES, qualifierMap);
        }
    }
    ,
    MAP_VALUES_NOT_CONTAIN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return FilterOperation.mapValuesNotContain(qualifierMap);
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    MAP_KEYS_BETWEEN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Pair twoValues = switch (39.getValue(qualifierMap).getType()) {
                case 1 -> Pair.of((Object)Exp.val((long)39.getValue(qualifierMap).toLong()), (Object)Exp.val((long)39.getSecondValue(qualifierMap).toLong()));
                case 3 -> Pair.of((Object)Exp.val((String)39.getValue(qualifierMap).toString()), (Object)Exp.val((String)39.getSecondValue(qualifierMap).toString()));
                case 20 -> Pair.of((Object)Exp.val((List)((List)39.getValue(qualifierMap).getObject())), (Object)Exp.val((List)((List)39.getSecondValue(qualifierMap).getObject())));
                case 19 -> Pair.of((Object)Exp.val((Map)((Map)39.getValue(qualifierMap).getObject())), (Object)Exp.val((Map)((Map)39.getSecondValue(qualifierMap).getObject())));
                default -> throw new UnsupportedOperationException("MAP_KEYS_BETWEEN FilterExpression unsupported type: got " + 39.getValue(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)MapExp.getByKeyRange((int)5, (Exp)((Exp)twoValues.getFirst()), (Exp)((Exp)twoValues.getSecond()), (Exp)Exp.mapBin((String)39.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return this.collectionRange(IndexCollectionType.MAPKEYS, qualifierMap);
        }
    }
    ,
    MAP_VAL_BETWEEN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Pair twoValues = switch (40.getValue(qualifierMap).getType()) {
                case 1 -> Pair.of((Object)Exp.val((long)40.getValue(qualifierMap).toLong()), (Object)Exp.val((long)40.getSecondValue(qualifierMap).toLong()));
                case 3 -> Pair.of((Object)Exp.val((String)40.getValue(qualifierMap).toString()), (Object)Exp.val((String)40.getSecondValue(qualifierMap).toString()));
                case 20 -> Pair.of((Object)Exp.val((List)((List)40.getValue(qualifierMap).getObject())), (Object)Exp.val((List)((List)40.getSecondValue(qualifierMap).getObject())));
                case 19 -> Pair.of((Object)Exp.val((Map)((Map)40.getValue(qualifierMap).getObject())), (Object)Exp.val((Map)((Map)40.getSecondValue(qualifierMap).getObject())));
                default -> throw new UnsupportedOperationException("MAP_VAL_BETWEEN FilterExpression unsupported type: got " + 40.getValue(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)MapExp.getByValueRange((int)5, (Exp)((Exp)twoValues.getFirst()), (Exp)((Exp)twoValues.getSecond()), (Exp)Exp.mapBin((String)40.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (40.getValue(qualifierMap).getType() != 1 || 40.getSecondValue(qualifierMap).getType() != 1) {
                return null;
            }
            return this.collectionRange(IndexCollectionType.MAPVALUES, qualifierMap);
        }
    }
    ,
    GEO_WITHIN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return Exp.geoCompare((Exp)Exp.geoBin((String)41.getBinName(qualifierMap)), (Exp)Exp.geo((String)41.getValue(qualifierMap).toString()));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return this.geoWithinRadius(IndexCollectionType.DEFAULT, qualifierMap);
        }
    }
    ,
    COLLECTION_VAL_CONTAINING{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Value val = 42.getValue(qualifierMap);
            if (val instanceof Value.BoolIntValue) {
                qualifierMap.put(QualifierKey.VALUE, new Value.BooleanValue(((Boolean)42.getValue(qualifierMap).getObject()).booleanValue()));
            }
            String errMsg = "COLLECTION_VAL_CONTAINING FilterExpression unsupported type: got " + val.getClass().getSimpleName();
            Exp value = Utils.getExpValOrFail(val, errMsg);
            return Exp.gt((Exp)ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)42.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (42.getValue(qualifierMap).getType() != 3 && 42.getValue(qualifierMap).getType() != 1) {
                return null;
            }
            return this.cdtContains(IndexCollectionType.LIST, qualifierMap);
        }
    }
    ,
    COLLECTION_VAL_NOT_CONTAINING{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Value val = 43.getValue(qualifierMap);
            if (val instanceof Value.BoolIntValue) {
                qualifierMap.put(QualifierKey.VALUE, new Value.BooleanValue(((Boolean)43.getKey(qualifierMap).getObject()).booleanValue()));
            }
            String errMsg = "COLLECTION_VAL_NOT_CONTAINING FilterExpression unsupported type: got " + val.getClass().getSimpleName();
            Exp value = Utils.getExpValOrFail(val, errMsg);
            Exp binIsNull = Exp.not((Exp)Exp.binExists((String)43.getBinName(qualifierMap)));
            Exp listNotContaining = Exp.eq((Exp)ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)43.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            return Exp.or((Exp[])new Exp[]{binIsNull, listNotContaining});
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    COLLECTION_VAL_GT{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            if (44.getValue(qualifierMap).getType() == 1) {
                if (44.getValue(qualifierMap).toLong() == Long.MAX_VALUE) {
                    throw new IllegalArgumentException("COLLECTION_VAL_GT FilterExpression unsupported value: expected [Long.MIN_VALUE..Long.MAX_VALUE-1]");
                }
                return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)(44.getValue(qualifierMap).toLong() + 1L)), null, (Exp)Exp.listBin((String)44.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            }
            Exp value = switch (44.getValue(qualifierMap).getType()) {
                case 3 -> Exp.val((String)44.getValue(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)44.getValue(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)44.getValue(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("COLLECTION_VAL_GT FilterExpression unsupported type: got " + 44.getValue(qualifierMap).getClass().getSimpleName());
            };
            Exp rangeIncludingValue = ListExp.getByValueRange((int)5, (Exp)value, null, (Exp)Exp.listBin((String)44.getBinName(qualifierMap)), (CTX[])new CTX[0]);
            Exp valueOnly = ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)44.getBinName(qualifierMap)), (CTX[])new CTX[0]);
            return Exp.gt((Exp)Exp.sub((Exp[])new Exp[]{rangeIncludingValue, valueOnly}), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (44.getValue(qualifierMap).getType() != 1 || 44.getValue(qualifierMap).toLong() == Long.MAX_VALUE) {
                return null;
            }
            return Filter.range((String)44.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)(44.getValue(qualifierMap).toLong() + 1L), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    COLLECTION_VAL_GTEQ{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Exp value = switch (45.getValue(qualifierMap).getType()) {
                case 1 -> Exp.val((long)45.getValue(qualifierMap).toLong());
                case 3 -> Exp.val((String)45.getValue(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)45.getValue(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)45.getValue(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("COLLECTION_VAL_GTEQ FilterExpression unsupported type: got " + 45.getValue(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)value, null, (Exp)Exp.listBin((String)45.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (45.getValue(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)45.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)45.getValue(qualifierMap).toLong(), (long)Long.MAX_VALUE, (CTX[])new CTX[0]);
        }
    }
    ,
    COLLECTION_VAL_LT{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Exp value = switch (46.getValue(qualifierMap).getType()) {
                case 1 -> {
                    if (46.getValue(qualifierMap).toLong() == Long.MIN_VALUE) {
                        throw new UnsupportedOperationException("COLLECTION_VAL_LT FilterExpression unsupported value: expected [Long.MIN_VALUE+1..Long.MAX_VALUE]");
                    }
                    yield Exp.val((long)46.getValue(qualifierMap).toLong());
                }
                case 3 -> Exp.val((String)46.getValue(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)46.getValue(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)46.getValue(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("COLLECTION_VAL_GTEQ FilterExpression unsupported type: got " + 46.getValue(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, null, (Exp)value, (Exp)Exp.listBin((String)46.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (46.getValue(qualifierMap).getType() != 1 || 46.getValue(qualifierMap).toLong() == Long.MIN_VALUE) {
                return null;
            }
            return Filter.range((String)46.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)Long.MIN_VALUE, (long)(46.getValue(qualifierMap).toLong() - 1L), (CTX[])new CTX[0]);
        }
    }
    ,
    COLLECTION_VAL_LTEQ{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            if (47.getValue(qualifierMap).getType() == 1) {
                Exp upperLimit = 47.getValue(qualifierMap).toLong() == Long.MAX_VALUE ? Exp.inf() : Exp.val((long)(47.getValue(qualifierMap).toLong() + 1L));
                return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)Exp.val((long)Long.MIN_VALUE), (Exp)upperLimit, (Exp)Exp.listBin((String)47.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
            }
            Exp value = switch (47.getValue(qualifierMap).getType()) {
                case 3 -> Exp.val((String)47.getValue(qualifierMap).toString());
                case 20 -> Exp.val((List)((List)47.getValue(qualifierMap).getObject()));
                case 19 -> Exp.val((Map)((Map)47.getValue(qualifierMap).getObject()));
                default -> throw new UnsupportedOperationException("COLLECTION_VAL_LTEQ FilterExpression unsupported type: got " + 47.getValue(qualifierMap).getClass().getSimpleName());
            };
            Exp rangeIncludingValue = ListExp.getByValueRange((int)5, null, (Exp)value, (Exp)Exp.listBin((String)47.getBinName(qualifierMap)), (CTX[])new CTX[0]);
            Exp valueOnly = ListExp.getByValue((int)5, (Exp)value, (Exp)Exp.listBin((String)47.getBinName(qualifierMap)), (CTX[])new CTX[0]);
            return Exp.gt((Exp)Exp.add((Exp[])new Exp[]{rangeIncludingValue, valueOnly}), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (47.getValue(qualifierMap).getType() != 1) {
                return null;
            }
            return Filter.range((String)47.getBinName(qualifierMap), (IndexCollectionType)IndexCollectionType.LIST, (long)Long.MIN_VALUE, (long)47.getValue(qualifierMap).toLong(), (CTX[])new CTX[0]);
        }
    }
    ,
    COLLECTION_VAL_BETWEEN{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            Pair twoValues = switch (48.getValue(qualifierMap).getType()) {
                case 1 -> Pair.of((Object)Exp.val((long)48.getValue(qualifierMap).toLong()), (Object)Exp.val((long)48.getSecondValue(qualifierMap).toLong()));
                case 3 -> Pair.of((Object)Exp.val((String)48.getValue(qualifierMap).toString()), (Object)Exp.val((String)48.getSecondValue(qualifierMap).toString()));
                case 20 -> Pair.of((Object)Exp.val((List)((List)48.getValue(qualifierMap).getObject())), (Object)Exp.val((List)((List)48.getSecondValue(qualifierMap).getObject())));
                case 19 -> Pair.of((Object)Exp.val((Map)((Map)48.getValue(qualifierMap).getObject())), (Object)Exp.val((Map)((Map)48.getSecondValue(qualifierMap).getObject())));
                default -> throw new UnsupportedOperationException("COLLECTION_VAL_BETWEEN FilterExpression unsupported type: got " + 48.getValue(qualifierMap).getClass().getSimpleName());
            };
            return Exp.gt((Exp)ListExp.getByValueRange((int)5, (Exp)((Exp)twoValues.getFirst()), (Exp)((Exp)twoValues.getSecond()), (Exp)Exp.listBin((String)48.getBinName(qualifierMap)), (CTX[])new CTX[0]), (Exp)Exp.val((long)0L));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            if (48.getValue(qualifierMap).getType() != 1 || 48.getSecondValue(qualifierMap).getType() != 1) {
                return null;
            }
            return this.collectionRange(IndexCollectionType.LIST, qualifierMap);
        }
    }
    ,
    IS_NOT_NULL{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return Exp.binExists((String)49.getBinName(qualifierMap));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    IS_NULL{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return Exp.not((Exp)Exp.binExists((String)50.getBinName(qualifierMap)));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    }
    ,
    NOT_NULL{

        @Override
        public Exp filterExp(Map<QualifierKey, Object> qualifierMap) {
            return Exp.binExists((String)51.getBinName(qualifierMap));
        }

        @Override
        public Filter sIndexFilter(Map<QualifierKey, Object> qualifierMap) {
            return null;
        }
    };

    protected static final List<FilterOperation> dualFilterOperations;

    private static Exp processMetadataFieldInOrNot(Map<QualifierKey, Object> qualifierMap, boolean notIn) {
        Collection listOfLongs;
        FilterOperation filterOperation = notIn ? NOTEQ : EQ;
        Object obj = FilterOperation.getValue(qualifierMap).getObject();
        try {
            listOfLongs = (Collection)obj;
        }
        catch (Exception e) {
            String operation = notIn ? "NOT_IN" : "IN";
            throw new IllegalStateException("FilterOperation." + operation + " metadata query: expecting value as a Collection<Long>");
        }
        Exp[] listElementsExp = (Exp[])listOfLongs.stream().map(item -> ((MetadataQualifierBuilder)((MetadataQualifierBuilder)Qualifier.metadataBuilder().setMetadataField(FilterOperation.getMetadataField(qualifierMap)).setFilterOperation(filterOperation)).setValue(item)).build().getFilterExp()).toArray(Exp[]::new);
        return notIn ? Exp.and((Exp[])listElementsExp) : Exp.or((Exp[])listElementsExp);
    }

    private static Exp processMetadataFieldIn(Map<QualifierKey, Object> qualifierMap) {
        return FilterOperation.processMetadataFieldInOrNot(qualifierMap, false);
    }

    private static Exp processMetadataFieldNotIn(Map<QualifierKey, Object> qualifierMap) {
        return FilterOperation.processMetadataFieldInOrNot(qualifierMap, true);
    }

    private static Exp getExpOrFail(Value value, String filterOpName) {
        String errMsg = String.format("%s FilterExpression unsupported value type: got %s", filterOpName, value.getClass().getSimpleName());
        return Utils.getExpValOrFail(value, errMsg);
    }

    private static Collection<?> getValueAsCollectionOrFail(Map<QualifierKey, Object> qualifierMap) {
        Value value = FilterOperation.getValue(qualifierMap);
        String errMsg = "FilterOperation.IN expects argument with type Collection, instead got: " + value.getObject().getClass().getSimpleName();
        if (value.getType() != 20 || !(value.getObject() instanceof Collection)) {
            throw new IllegalArgumentException(errMsg);
        }
        return (Collection)value.getObject();
    }

    private static Optional<Exp> getMetadataExp(Map<QualifierKey, Object> qualifierMap) {
        CriteriaDefinition.AerospikeMetadata metadataField = FilterOperation.getMetadataField(qualifierMap);
        String binName = FilterOperation.getBinName(qualifierMap);
        if (metadataField != null && (binName == null || binName.isEmpty())) {
            FilterOperation operation = FilterOperation.getOperation(qualifierMap);
            switch (operation) {
                case EQ: 
                case NOTEQ: 
                case LT: 
                case LTEQ: 
                case GT: 
                case GTEQ: {
                    BinaryOperator<Exp> operationFunction = FilterOperation.mapOperation(operation);
                    return Optional.of((Exp)operationFunction.apply(FilterOperation.mapMetadataExp(metadataField, FilterOperation.getServerVersionSupport(qualifierMap)), Exp.val((long)FilterOperation.getValue(qualifierMap).toLong())));
                }
                case BETWEEN: {
                    Exp metadata = FilterOperation.mapMetadataExp(metadataField, FilterOperation.getServerVersionSupport(qualifierMap));
                    Exp value = Exp.val((long)FilterOperation.getValue(qualifierMap).toLong());
                    Exp secondValue = Exp.val((long)FilterOperation.getSecondValue(qualifierMap).toLong());
                    return Optional.of(Exp.and((Exp[])new Exp[]{Exp.ge((Exp)metadata, (Exp)value), Exp.lt((Exp)metadata, (Exp)secondValue)}));
                }
                case IN: {
                    return Optional.of(FilterOperation.processMetadataFieldIn(qualifierMap));
                }
                case NOT_IN: {
                    return Optional.of(FilterOperation.processMetadataFieldNotIn(qualifierMap));
                }
            }
            throw new IllegalStateException("Unsupported FilterOperation " + operation);
        }
        return Optional.empty();
    }

    private static Exp mapMetadataExp(CriteriaDefinition.AerospikeMetadata metadataField, ServerVersionSupport versionSupport) {
        return switch (metadataField) {
            case CriteriaDefinition.AerospikeMetadata.SINCE_UPDATE_TIME -> Exp.sinceUpdate();
            case CriteriaDefinition.AerospikeMetadata.LAST_UPDATE_TIME -> Exp.lastUpdate();
            case CriteriaDefinition.AerospikeMetadata.VOID_TIME -> Exp.voidTime();
            case CriteriaDefinition.AerospikeMetadata.TTL -> Exp.ttl();
            case CriteriaDefinition.AerospikeMetadata.RECORD_SIZE_ON_DISK -> {
                if (versionSupport.isServerVersionGtOrEq7()) {
                    yield Exp.recordSize();
                }
                yield Exp.deviceSize();
            }
            case CriteriaDefinition.AerospikeMetadata.RECORD_SIZE_IN_MEMORY -> {
                if (versionSupport.isServerVersionGtOrEq7()) {
                    yield Exp.recordSize();
                }
                yield Exp.memorySize();
            }
            default -> throw new IllegalStateException("Cannot map metadata Expression to " + metadataField);
        };
    }

    private static BinaryOperator<Exp> mapOperation(FilterOperation operation) {
        return switch (operation) {
            case EQ -> Exp::eq;
            case NOTEQ -> Exp::ne;
            case GT -> Exp::gt;
            case GTEQ -> Exp::ge;
            case LT -> Exp::lt;
            case LTEQ -> Exp::le;
            default -> throw new IllegalStateException("Cannot map FilterOperation from " + operation);
        };
    }

    private static Exp mapValBetweenByKey(Map<QualifierKey, Object> qualifierMap, CTX[] ctxArr, Exp.Type type, Exp lowerLimit, Exp upperLimit) {
        Exp mapExp = ctxArr != null && ctxArr.length > 0 ? MapExp.getByKey((int)7, (Exp.Type)type, (Exp)Exp.val((String)FilterOperation.getKey(qualifierMap).toString()), (Exp)Exp.mapBin((String)FilterOperation.getBinName(qualifierMap)), (CTX[])ctxArr) : MapExp.getByKey((int)7, (Exp.Type)type, (Exp)Exp.val((String)FilterOperation.getKey(qualifierMap).toString()), (Exp)Exp.mapBin((String)FilterOperation.getBinName(qualifierMap)), (CTX[])new CTX[0]);
        return Exp.and((Exp[])new Exp[]{Exp.ge((Exp)mapExp, (Exp)lowerLimit), Exp.lt((Exp)mapExp, (Exp)upperLimit)});
    }

    private static Exp mapKeysNotContain(Map<QualifierKey, Object> qualifierMap) {
        String errMsg = "MAP_KEYS_NOT_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getKey(qualifierMap).getClass().getSimpleName();
        Exp mapKeysNotContain = FilterOperation.mapKeysCountComparedToZero(qualifierMap, Exp::eq, FilterOperation.getValue(qualifierMap), errMsg);
        Exp binDoesNotExist = Exp.not((Exp)Exp.binExists((String)FilterOperation.getBinName(qualifierMap)));
        return Exp.or((Exp[])new Exp[]{binDoesNotExist, mapKeysNotContain});
    }

    private static Exp mapKeysContain(Map<QualifierKey, Object> qualifierMap) {
        String errMsg = "MAP_KEYS_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getValue(qualifierMap).getClass().getSimpleName();
        String[] dotPathArray = AerospikeQueryCreatorUtils.getDotPathArray(FilterOperation.getDotPath(qualifierMap));
        if (FilterOperation.hasMapKeyPlaceholder(qualifierMap) && dotPathArray != null && dotPathArray.length > 1) {
            List<String> ctxList = AerospikeQueryCreatorUtils.convertToStringListExclStart(dotPathArray);
            qualifierMap.put(QualifierKey.CTX_ARRAY, AerospikeQueryCreatorUtils.resolveCtxList(ctxList));
        }
        return FilterOperation.mapKeysCountComparedToZero(qualifierMap, Exp::gt, FilterOperation.getValue(qualifierMap), errMsg);
    }

    private static Exp mapValuesNotContain(Map<QualifierKey, Object> qualifierMap) {
        String errMsg = "MAP_VALUES_NOT_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getValue(qualifierMap).getClass().getSimpleName();
        Exp binDoesNotExist = Exp.not((Exp)Exp.binExists((String)FilterOperation.getBinName(qualifierMap)));
        Exp mapValuesNotContain = FilterOperation.mapValuesCountComparedToZero(qualifierMap, Exp::eq, errMsg);
        return Exp.or((Exp[])new Exp[]{binDoesNotExist, mapValuesNotContain});
    }

    private static Exp mapValuesContain(Map<QualifierKey, Object> qualifierMap) {
        String errMsg = "MAP_VALUES_CONTAIN FilterExpression unsupported type: got " + FilterOperation.getValue(qualifierMap).getClass().getSimpleName();
        return FilterOperation.mapValuesCountComparedToZero(qualifierMap, Exp::gt, errMsg);
    }

    private static Exp mapKeysCountComparedToZero(Map<QualifierKey, Object> qualifierMap, BinaryOperator<Exp> operator, Object mapKey, String errMsg) {
        Exp key = Utils.getExpValOrFail(Value.get((Object)mapKey), errMsg);
        Exp map = Exp.mapBin((String)FilterOperation.getBinName(qualifierMap));
        CTX[] ctxArr = FilterOperation.getCtxArr(qualifierMap);
        return (Exp)operator.apply(MapExp.getByKey((int)5, (Exp.Type)Exp.Type.INT, (Exp)key, (Exp)map, (CTX[])ctxArr), Exp.val((long)0L));
    }

    private static Exp mapValuesCountComparedToZero(Map<QualifierKey, Object> qualifierMap, BinaryOperator<Exp> operator, String errMsg) {
        Exp value = Utils.getExpValOrFail(FilterOperation.getValue(qualifierMap), errMsg);
        Exp map = Exp.mapBin((String)FilterOperation.getBinName(qualifierMap));
        Value mapBinKey = FilterOperation.getKey(qualifierMap);
        if (!mapBinKey.equals(Value.NullValue.INSTANCE)) {
            String err = "MAP_VAL_NOT_CONTAINING_BY_KEY FilterExpression unsupported type: got " + mapBinKey.getClass().getSimpleName();
            Exp nestedMapKey = Utils.getExpValOrFail(mapBinKey, err);
            map = MapExp.getByKey((int)7, (Exp.Type)Exp.Type.MAP, (Exp)nestedMapKey, (Exp)Exp.mapBin((String)FilterOperation.getBinName(qualifierMap)), (CTX[])new CTX[0]);
        }
        return (Exp)operator.apply(MapExp.getByValue((int)5, (Exp)value, (Exp)map, (CTX[])new CTX[0]), Exp.val((long)0L));
    }

    private static Exp getFilterExpMapValOrFail(Map<QualifierKey, Object> qualifierMap, BinaryOperator<Exp> operator, String opName) {
        CTX[] ctxArr = FilterOperation.getCtxArr(qualifierMap);
        return switch (FilterOperation.getValue(qualifierMap).getType()) {
            case 1 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, ctxArr, Exp.Type.INT), Exp.val((long)FilterOperation.getValue(qualifierMap).toLong()));
            case 3 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, ctxArr, Exp.Type.STRING), Exp.val((String)FilterOperation.getValue(qualifierMap).toString()));
            case 20 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, ctxArr, Exp.Type.LIST), Exp.val((List)((List)FilterOperation.getValue(qualifierMap).getObject())));
            case 19 -> (Exp)operator.apply(FilterOperation.getMapExp(qualifierMap, ctxArr, Exp.Type.MAP), Exp.val((Map)((Map)FilterOperation.getValue(qualifierMap).getObject())));
            default -> throw new UnsupportedOperationException(opName + " FilterExpression unsupported type: " + FilterOperation.getValue(qualifierMap).getClass().getSimpleName());
        };
    }

    private static Exp getMapExp(Map<QualifierKey, Object> qualifierMap, CTX[] ctxArr, Exp.Type expType) {
        Exp mapKeyExp = FilterOperation.getMapKeyExp(FilterOperation.getKey(qualifierMap).getObject(), FilterOperation.keepOriginalKeyTypes(qualifierMap));
        if (ctxArr != null) {
            return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)mapKeyExp, (Exp)Exp.mapBin((String)FilterOperation.getBinName(qualifierMap)), (CTX[])ctxArr);
        }
        return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)mapKeyExp, (Exp)Exp.mapBin((String)FilterOperation.getBinName(qualifierMap)), (CTX[])new CTX[0]);
    }

    private static Exp getMapKeyExp(Object mapKey, boolean keepOriginalKeyTypes) {
        if (keepOriginalKeyTypes) {
            Exp res = mapKey instanceof Byte || mapKey instanceof Short || mapKey instanceof Integer || mapKey instanceof Long ? Exp.val((long)((Number)mapKey).longValue()) : (mapKey instanceof Float || mapKey instanceof Double ? Exp.val((double)((Number)mapKey).doubleValue()) : (mapKey instanceof byte[] ? Exp.val((byte[])((byte[])mapKey)) : (Value.get((Object)mapKey) instanceof Value.NullValue ? Exp.nil() : Exp.val((String)Value.get((Object)mapKey).toString()))));
            return res;
        }
        return Exp.val((String)Value.get((Object)mapKey).toString());
    }

    private static boolean keepOriginalKeyTypes(Map<QualifierKey, Object> qualifierMap) {
        Object dataSettings = qualifierMap.get((Object)QualifierKey.DATA_SETTINGS);
        if (dataSettings == null) {
            throw new IllegalStateException("Expecting AerospikeDataSettings in qualifier map with the key " + QualifierKey.DATA_SETTINGS);
        }
        return ((AerospikeDataSettings)dataSettings).isKeepOriginalKeyTypes();
    }

    private static Exp getFilterExpMapValEqOrFail(Map<QualifierKey, Object> qualifierMap, BinaryOperator<Exp> operator) {
        return FilterOperation.getMapValEqOrFail(qualifierMap, operator, "MAP_VAL_EQ_BY_KEY");
    }

    private static Exp getFilterExpMapValNotEqOrFail(Map<QualifierKey, Object> qualifierMap, BinaryOperator<Exp> operator) {
        return FilterOperation.getMapValEqOrFail(qualifierMap, operator, "MAP_VAL_NOTEQ_BY_KEY");
    }

    private static Exp getMapValEqOrFail(Map<QualifierKey, Object> qualifierMap, BinaryOperator<Exp> operator, String opName) {
        CTX[] ctxArr = FilterOperation.getCtxArr(qualifierMap);
        if (FilterOperation.getValue(qualifierMap) instanceof Value.BoolIntValue) {
            qualifierMap.put(QualifierKey.VALUE, new Value.BooleanValue(((Boolean)FilterOperation.getValue(qualifierMap).getObject()).booleanValue()));
        }
        Value value = FilterOperation.getValue(qualifierMap);
        return switch (value.getType()) {
            case 1 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.INT, value.toLong(), ctxArr, operator);
            case 3 -> {
                if (FilterOperation.ignoreCase(qualifierMap).booleanValue()) {
                    throw new UnsupportedOperationException(opName + " FilterExpression: case insensitive comparison is not supported");
                }
                yield FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.STRING, value.toString(), ctxArr, operator);
            }
            case 17 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.BOOL, value.getObject(), ctxArr, operator);
            case 20 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.LIST, value.getObject(), ctxArr, operator);
            case 19 -> FilterOperation.getMapValEqExp(qualifierMap, Exp.Type.MAP, value.getObject(), ctxArr, operator);
            default -> throw new UnsupportedOperationException(opName + " FilterExpression unsupported type: " + value.getClass().getSimpleName());
        };
    }

    private static Exp getMapValEqExp(Map<QualifierKey, Object> qualifierMap, Exp.Type expType, Object value, CTX[] ctxArr, BinaryOperator<Exp> operator) {
        Exp mapExp = FilterOperation.getMapValEq(qualifierMap, expType, ctxArr);
        return (Exp)operator.apply(mapExp, FilterOperation.toExp(value));
    }

    private static Exp getMapValEq(Map<QualifierKey, Object> qualifierMap, Exp.Type expType, CTX[] ctxArr) {
        Exp bin = FilterOperation.getBin(FilterOperation.getBinName(qualifierMap), FilterOperation.getBinType(qualifierMap), "MAP_VAL_EQ");
        if (ctxArr != null && ctxArr.length > 0) {
            return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)Utils.getExpValOrFail(FilterOperation.getKey(qualifierMap), "MAP_VAL_EQ: unsupported type"), (Exp)bin, (CTX[])ctxArr);
        }
        return MapExp.getByKey((int)7, (Exp.Type)expType, (Exp)Utils.getExpValOrFail(FilterOperation.getKey(qualifierMap), "MAP_VAL_EQ: unsupported type"), (Exp)bin, (CTX[])new CTX[0]);
    }

    private static Exp getBin(String binName, Exp.Type binType, String filterOperation) {
        if (binType == null) {
            return Exp.mapBin((String)binName);
        }
        return switch (binType) {
            case Exp.Type.INT -> Exp.intBin((String)binName);
            case Exp.Type.STRING -> Exp.stringBin((String)binName);
            case Exp.Type.BOOL -> Exp.boolBin((String)binName);
            case Exp.Type.LIST -> Exp.listBin((String)binName);
            default -> Exp.mapBin((String)binName);
        };
    }

    private static Exp getFilterExp(Exp exp, String field, BinaryOperator<Exp> operator, Function<String, Exp> binExp) {
        return (Exp)operator.apply(binExp.apply(field), exp);
    }

    private static Exp toExp(Object value) {
        Exp res;
        if (value instanceof Byte || value instanceof Short || value instanceof Integer || value instanceof Long) {
            res = Exp.val((long)((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            res = Exp.val((double)((Number)value).doubleValue());
        } else if (value instanceof String) {
            res = Exp.val((String)((String)value));
        } else if (value instanceof Boolean) {
            res = Exp.val((boolean)((Boolean)value));
        } else if (value instanceof Map) {
            res = Exp.val((Map)((Map)value));
        } else if (value instanceof List) {
            res = Exp.val((List)((List)value));
        } else if (value instanceof byte[]) {
            res = Exp.val((byte[])((byte[])value));
        } else if (value instanceof Calendar) {
            res = Exp.val((Calendar)((Calendar)value));
        } else if (value instanceof Value.NullValue) {
            res = Exp.nil();
        } else {
            throw new UnsupportedOperationException("Unsupported type for converting: " + value.getClass().getCanonicalName());
        }
        return res;
    }

    protected static String getBinName(Map<QualifierKey, Object> qualifierMap) {
        return (String)qualifierMap.get((Object)QualifierKey.BIN_NAME);
    }

    protected static Exp.Type getBinType(Map<QualifierKey, Object> qualifierMap) {
        return (Exp.Type)qualifierMap.get((Object)QualifierKey.BIN_TYPE);
    }

    protected static CriteriaDefinition.AerospikeMetadata getMetadataField(Map<QualifierKey, Object> qualifierMap) {
        return (CriteriaDefinition.AerospikeMetadata)((Object)qualifierMap.get((Object)QualifierKey.METADATA_FIELD));
    }

    protected static FilterOperation getOperation(Map<QualifierKey, Object> qualifierMap) {
        return (FilterOperation)((Object)qualifierMap.get((Object)QualifierKey.FILTER_OPERATION));
    }

    protected static Boolean ignoreCase(Map<QualifierKey, Object> qualifierMap) {
        return (Boolean)qualifierMap.getOrDefault((Object)QualifierKey.IGNORE_CASE, false);
    }

    protected static int regexFlags(Map<QualifierKey, Object> qualifierMap) {
        return FilterOperation.ignoreCase(qualifierMap) != false ? 2 : 0;
    }

    protected static Value getKey(Map<QualifierKey, Object> qualifierMap) {
        return Value.get((Object)qualifierMap.get((Object)QualifierKey.KEY));
    }

    protected static Value getNestedKey(Map<QualifierKey, Object> qualifierMap) {
        return Value.get((Object)qualifierMap.get((Object)QualifierKey.NESTED_KEY));
    }

    protected static Value getValue(Map<QualifierKey, Object> qualifierMap) {
        return Value.get((Object)qualifierMap.get((Object)QualifierKey.VALUE));
    }

    protected static Value getSecondValue(Map<QualifierKey, Object> qualifierMap) {
        return Value.get((Object)qualifierMap.get((Object)QualifierKey.SECOND_VALUE));
    }

    protected static Integer getNestedType(Map<QualifierKey, Object> qualifierMap) {
        Object fieldType = qualifierMap.get((Object)QualifierKey.NESTED_TYPE);
        return fieldType != null ? Integer.valueOf((Integer)fieldType) : null;
    }

    protected static boolean hasId(Map<QualifierKey, Object> qualifierMap) {
        return qualifierMap.containsKey((Object)QualifierKey.IS_ID_EXPR) && (Boolean)qualifierMap.get((Object)QualifierKey.IS_ID_EXPR) != false;
    }

    protected static CTX[] getCtxArr(Map<QualifierKey, Object> qualifierMap) {
        return (CTX[])qualifierMap.get((Object)QualifierKey.CTX_ARRAY);
    }

    protected static String getCtxArrAsString(Map<QualifierKey, Object> qualifierMap) {
        CTX[] ctxArr = (CTX[])qualifierMap.get((Object)QualifierKey.CTX_ARRAY);
        return Utils.ctxArrToString(ctxArr);
    }

    protected static ServerVersionSupport getServerVersionSupport(Map<QualifierKey, Object> qualifierMap) {
        return (ServerVersionSupport)qualifierMap.get((Object)QualifierKey.SERVER_VERSION_SUPPORT);
    }

    public abstract Exp filterExp(Map<QualifierKey, Object> var1);

    public abstract Filter sIndexFilter(Map<QualifierKey, Object> var1);

    protected Filter cdtContains(IndexCollectionType collectionType, Map<QualifierKey, Object> qualifierMap) {
        Value val = FilterOperation.getValue(qualifierMap);
        int valType = val.getType();
        String[] dotPathArray = AerospikeQueryCreatorUtils.getDotPathArray(FilterOperation.getDotPath(qualifierMap));
        if (dotPathArray != null && dotPathArray.length > 1) {
            List<String> ctxList = AerospikeQueryCreatorUtils.convertToStringListExclStart(dotPathArray);
            qualifierMap.put(QualifierKey.CTX_ARRAY, AerospikeQueryCreatorUtils.resolveCtxList(ctxList));
        }
        return switch (valType) {
            case 1 -> Filter.contains((String)FilterOperation.getBinName(qualifierMap), (IndexCollectionType)collectionType, (long)val.toLong(), (CTX[])FilterOperation.getCtxArr(qualifierMap));
            case 3 -> Filter.contains((String)FilterOperation.getBinName(qualifierMap), (IndexCollectionType)collectionType, (String)val.toString(), (CTX[])FilterOperation.getCtxArr(qualifierMap));
            case 4 -> Filter.contains((String)FilterOperation.getBinName(qualifierMap), (IndexCollectionType)collectionType, (byte[])((byte[])val.getObject()), (CTX[])FilterOperation.getCtxArr(qualifierMap));
            default -> null;
        };
    }

    protected static List<String> getDotPath(Map<QualifierKey, Object> qualifierMap) {
        return (List)qualifierMap.get((Object)QualifierKey.DOT_PATH);
    }

    protected Filter collectionRange(IndexCollectionType collectionType, Map<QualifierKey, Object> qualifierMap) {
        return Filter.range((String)FilterOperation.getBinName(qualifierMap), (IndexCollectionType)collectionType, (long)FilterOperation.getValue(qualifierMap).toLong(), (long)FilterOperation.getSecondValue(qualifierMap).toLong(), (CTX[])new CTX[0]);
    }

    protected Filter geoWithinRadius(IndexCollectionType collectionType, Map<QualifierKey, Object> qualifierMap) {
        return Filter.geoContains((String)FilterOperation.getBinName(qualifierMap), (String)FilterOperation.getValue(qualifierMap).toString(), (CTX[])new CTX[0]);
    }

    private static boolean hasMapKeyPlaceholder(Map<QualifierKey, Object> qualifierMap) {
        return (Boolean)qualifierMap.getOrDefault((Object)QualifierKey.MAP_KEY_PLACEHOLDER, false);
    }

    static {
        dualFilterOperations = Arrays.asList(MAP_VAL_EQ_BY_KEY, MAP_VAL_GT_BY_KEY, MAP_VAL_GTEQ_BY_KEY, MAP_VAL_LT_BY_KEY, MAP_VAL_LTEQ_BY_KEY, MAP_VAL_BETWEEN_BY_KEY, MAP_KEYS_BETWEEN, MAP_VAL_BETWEEN);
    }
}

