/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.repository.support;

import java.lang.reflect.Method;
import java.util.Optional;
import org.springframework.data.aerospike.core.AerospikeTemplate;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.repository.query.AerospikePartTreeQuery;
import org.springframework.data.aerospike.repository.query.AerospikeQueryCreator;
import org.springframework.data.aerospike.repository.support.SimpleAerospikeRepository;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.data.querydsl.QuerydslUtils;
import org.springframework.data.repository.core.EntityInformation;
import org.springframework.data.repository.core.NamedQueries;
import org.springframework.data.repository.core.RepositoryInformation;
import org.springframework.data.repository.core.RepositoryMetadata;
import org.springframework.data.repository.core.support.PersistentEntityInformation;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.data.repository.query.QueryLookupStrategy;
import org.springframework.data.repository.query.QueryMethod;
import org.springframework.data.repository.query.QueryMethodValueEvaluationContextAccessor;
import org.springframework.data.repository.query.RepositoryQuery;
import org.springframework.data.repository.query.ValueExpressionDelegate;
import org.springframework.data.repository.query.parser.AbstractQueryCreator;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class AerospikeRepositoryFactory
extends RepositoryFactorySupport {
    private static final Class<AerospikeQueryCreator> DEFAULT_QUERY_CREATOR = AerospikeQueryCreator.class;
    private final AerospikeTemplate template;
    private final MappingContext<? extends AerospikePersistentEntity<?>, AerospikePersistentProperty> context;
    private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

    public AerospikeRepositoryFactory(AerospikeTemplate aerospikeTemplate) {
        this(aerospikeTemplate, DEFAULT_QUERY_CREATOR);
    }

    public AerospikeRepositoryFactory(AerospikeTemplate aerospikeTemplate, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
        Assert.notNull((Object)aerospikeTemplate, (String)"AerospikeTemplate must not be null!");
        Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
        this.queryCreator = queryCreator;
        this.template = aerospikeTemplate;
        this.context = this.template.getMappingContext();
    }

    private static boolean isQueryDslRepository(Class<?> repositoryInterface) {
        return QuerydslUtils.QUERY_DSL_PRESENT && QuerydslPredicateExecutor.class.isAssignableFrom(repositoryInterface);
    }

    public <T, ID> EntityInformation<T, ID> getEntityInformation(Class<T> domainClass) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.context.getRequiredPersistentEntity(domainClass);
        return new PersistentEntityInformation((PersistentEntity)entity);
    }

    protected Object getTargetRepository(RepositoryInformation repositoryInformation) {
        EntityInformation entityInformation = this.getEntityInformation(repositoryInformation.getDomainType());
        return super.getTargetRepositoryViaReflection(repositoryInformation, new Object[]{entityInformation, this.template});
    }

    protected Class<?> getRepositoryBaseClass(RepositoryMetadata metadata) {
        return SimpleAerospikeRepository.class;
    }

    protected Optional<QueryLookupStrategy> getQueryLookupStrategy(@Nullable QueryLookupStrategy.Key key, ValueExpressionDelegate valueExpressionDelegate) {
        return Optional.of(new AerospikeQueryLookupStrategy(valueExpressionDelegate.getEvaluationContextAccessor(), this.template, this.queryCreator));
    }

    private static class AerospikeQueryLookupStrategy
    implements QueryLookupStrategy {
        private final QueryMethodValueEvaluationContextAccessor evaluationContextAccessor;
        private final AerospikeTemplate aerospikeTemplate;
        private final Class<? extends AbstractQueryCreator<?, ?>> queryCreator;

        public AerospikeQueryLookupStrategy(QueryMethodValueEvaluationContextAccessor evaluationContextAccessor, AerospikeTemplate aerospikeTemplate, Class<? extends AbstractQueryCreator<?, ?>> queryCreator) {
            Assert.notNull((Object)evaluationContextAccessor, (String)"QueryMethodEvaluationContextAccessor must not be null!");
            Assert.notNull((Object)aerospikeTemplate, (String)"AerospikeTemplate must not be null!");
            Assert.notNull(queryCreator, (String)"Query creator type must not be null!");
            this.evaluationContextAccessor = evaluationContextAccessor;
            this.aerospikeTemplate = aerospikeTemplate;
            this.queryCreator = queryCreator;
        }

        public RepositoryQuery resolveQuery(Method method, RepositoryMetadata metadata, ProjectionFactory projectionFactory, NamedQueries namedQueries) {
            QueryMethod queryMethod = new QueryMethod(method, metadata, projectionFactory);
            return new AerospikePartTreeQuery(queryMethod, this.evaluationContextAccessor, this.aerospikeTemplate, this.queryCreator);
        }
    }
}

