/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.transaction.reactive;

import com.aerospike.client.AbortStatus;
import com.aerospike.client.CommitStatus;
import org.springframework.data.aerospike.transaction.reactive.AerospikeReactiveTransactionResourceHolder;
import org.springframework.lang.Nullable;
import org.springframework.transaction.support.SmartTransactionObject;
import org.springframework.util.Assert;
import reactor.core.publisher.Mono;

public class AerospikeReactiveTransaction
implements SmartTransactionObject {
    @Nullable
    private AerospikeReactiveTransactionResourceHolder resourceHolder;

    AerospikeReactiveTransaction(@Nullable AerospikeReactiveTransactionResourceHolder resourceHolder) {
        this.resourceHolder = resourceHolder;
    }

    final boolean hasResourceHolder() {
        return this.resourceHolder != null;
    }

    AerospikeReactiveTransactionResourceHolder getRequiredResourceHolder() {
        Assert.state((boolean)this.hasResourceHolder(), (String)"Reactive resourceHolder is required to be not null");
        return this.resourceHolder;
    }

    void setResourceHolder(@Nullable AerospikeReactiveTransactionResourceHolder resourceHolder) {
        this.resourceHolder = resourceHolder;
    }

    private Mono<AerospikeReactiveTransactionResourceHolder> getResourceHolder() {
        return Mono.fromCallable(() -> {
            if (!this.hasResourceHolder()) {
                throw new IllegalStateException("Error: expecting transaction to exist");
            }
            return this.resourceHolder;
        });
    }

    public Mono<CommitStatus> commitTransaction() {
        return this.getResourceHolder().flatMap(h -> h.getClient().commit(h.getTransaction()));
    }

    public Mono<AbortStatus> abortTransaction() {
        return this.getResourceHolder().flatMap(h -> h.getClient().abort(h.getTransaction()));
    }

    public boolean isRollbackOnly() {
        return this.hasResourceHolder() && this.resourceHolder.isRollbackOnly();
    }

    public void flush() {
        throw new UnsupportedOperationException("Currently flush() is not supported for a reactive transaction");
    }
}

