/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.config;

import com.aerospike.client.IAerospikeClient;
import com.aerospike.client.policy.ClientPolicy;
import com.aerospike.client.reactor.AerospikeReactorClient;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.aerospike.config.AerospikeDataConfigurationSupport;
import org.springframework.data.aerospike.config.AerospikeSettings;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.ReactiveAerospikeTemplate;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.index.ReactiveAerospikePersistenceEntityIndexCreator;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.ReactorQueryEngine;
import org.springframework.data.aerospike.query.StatementBuilder;
import org.springframework.data.aerospike.query.cache.IndexInfoParser;
import org.springframework.data.aerospike.query.cache.IndexesCacheUpdater;
import org.springframework.data.aerospike.query.cache.InternalIndexOperations;
import org.springframework.data.aerospike.query.cache.ReactorIndexRefresher;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;

@Configuration
public abstract class AbstractReactiveAerospikeDataConfiguration
extends AerospikeDataConfigurationSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractReactiveAerospikeDataConfiguration.class);

    @Bean(name={"reactiveAerospikeTemplate"})
    public ReactiveAerospikeTemplate reactiveAerospikeTemplate(MappingAerospikeConverter mappingAerospikeConverter, AerospikeMappingContext aerospikeMappingContext, AerospikeExceptionTranslator aerospikeExceptionTranslator, IAerospikeReactorClient aerospikeReactorClient, ReactorQueryEngine reactorQueryEngine, ReactorIndexRefresher reactorIndexRefresher, ServerVersionSupport serverVersionSupport, AerospikeSettings settings) {
        return new ReactiveAerospikeTemplate(aerospikeReactorClient, settings.getDataSettings().getNamespace(), mappingAerospikeConverter, aerospikeMappingContext, aerospikeExceptionTranslator, reactorQueryEngine, reactorIndexRefresher, serverVersionSupport);
    }

    @Bean(name={"reactiveAerospikeQueryEngine"})
    public ReactorQueryEngine reactorQueryEngine(IAerospikeReactorClient aerospikeReactorClient, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder, AerospikeSettings settings) {
        ReactorQueryEngine queryEngine = new ReactorQueryEngine(aerospikeReactorClient, statementBuilder, filterExpressionsBuilder, settings.getDataSettings());
        boolean scansEnabled = settings.getDataSettings().isScansEnabled();
        queryEngine.setScansEnabled(scansEnabled);
        log.info("AerospikeDataSettings.scansEnabled: {}", (Object)scansEnabled);
        long queryMaxRecords = settings.getDataSettings().getQueryMaxRecords();
        log.info("AerospikeDataSettings.queryMaxRecords: {}", (Object)queryMaxRecords);
        queryEngine.setQueryMaxRecords(queryMaxRecords);
        if (!settings.getDataSettings().isWriteSortedMaps()) {
            log.info("AerospikeDataSettings.writeSortedMaps is set to false, Maps and POJOs will be written as unsorted Maps (degrades performance of Map-related operations, does not allow comparing Maps)");
        }
        return queryEngine;
    }

    @Bean(name={"reactiveAerospikeIndexRefresher"})
    public ReactorIndexRefresher reactorIndexRefresher(IAerospikeReactorClient aerospikeReactorClient, IndexesCacheUpdater indexesCacheUpdater, ServerVersionSupport serverVersionSupport) {
        ReactorIndexRefresher refresher = new ReactorIndexRefresher(aerospikeReactorClient, aerospikeReactorClient.getInfoPolicyDefault(), new InternalIndexOperations(new IndexInfoParser()), indexesCacheUpdater, serverVersionSupport);
        refresher.refreshIndexes().block();
        return refresher;
    }

    @Bean(name={"aerospikeReactorClient"})
    public IAerospikeReactorClient aerospikeReactorClient(IAerospikeClient aerospikeClient) {
        return new AerospikeReactorClient(aerospikeClient);
    }

    @Override
    protected ClientPolicy getClientPolicy() {
        ClientPolicy clientPolicy = super.getClientPolicy();
        return clientPolicy;
    }

    @Bean(name={"reactiveAerospikePersistenceEntityIndexCreator"})
    public ReactiveAerospikePersistenceEntityIndexCreator aerospikeReactivePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> aerospikeMappingContext, AerospikeIndexResolver aerospikeIndexResolver, ObjectProvider<ReactiveAerospikeTemplate> template, AerospikeSettings settings) {
        boolean indexesOnStartup = settings.getDataSettings().isCreateIndexesOnStartup();
        log.info("AerospikeDataSettings.indexesOnStartup: {}", (Object)indexesOnStartup);
        return new ReactiveAerospikePersistenceEntityIndexCreator(aerospikeMappingContext, indexesOnStartup, aerospikeIndexResolver, template);
    }
}

