/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Currency;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.util.NumberUtils;
import org.springframework.util.StringUtils;

abstract class AerospikeConverters {
    private AerospikeConverters() {
    }

    static Collection<Object> getConvertersToRegister() {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.add((Object)BigDecimalToStringConverter.INSTANCE);
        converters.add((Object)StringToBigDecimalConverter.INSTANCE);
        converters.add((Object)BigIntegerToStringConverter.INSTANCE);
        converters.add((Object)StringToBigIntegerConverter.INSTANCE);
        converters.add((Object)LongToBooleanConverter.INSTANCE);
        converters.add((Object)EnumToStringConverter.INSTANCE);
        converters.add((Object)URLToStringConverter.INSTANCE);
        converters.add((Object)StringToURLConverter.INSTANCE);
        converters.add((Object)AtomicIntegerToIntegerConverter.INSTANCE);
        converters.add((Object)IntegerToAtomicIntegerConverter.INSTANCE);
        converters.add((Object)AtomicLongToLongConverter.INSTANCE);
        converters.add((Object)LongToAtomicLongConverter.INSTANCE);
        converters.add((Object)CurrencyToStringConverter.INSTANCE);
        converters.add((Object)StringToCurrencyConverter.INSTANCE);
        converters.add((Object)UuidToStringConverter.INSTANCE);
        converters.add((Object)StringToUuidConverter.INSTANCE);
        return converters;
    }

    @WritingConverter
    public static enum BigDecimalToStringConverter implements Converter<BigDecimal, String>
    {
        INSTANCE;


        public String convert(BigDecimal source) {
            return source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToBigDecimalConverter implements Converter<String, BigDecimal>
    {
        INSTANCE;


        public BigDecimal convert(String source) {
            return StringUtils.hasText((String)source) ? new BigDecimal(source) : null;
        }
    }

    @WritingConverter
    public static enum BigIntegerToStringConverter implements Converter<BigInteger, String>
    {
        INSTANCE;


        public String convert(BigInteger source) {
            return source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToBigIntegerConverter implements Converter<String, BigInteger>
    {
        INSTANCE;


        public BigInteger convert(String source) {
            return new BigInteger(source);
        }
    }

    @ReadingConverter
    public static enum LongToBooleanConverter implements Converter<Long, Boolean>
    {
        INSTANCE;


        public Boolean convert(Long source) {
            return source != 0L;
        }
    }

    @WritingConverter
    public static enum EnumToStringConverter implements Converter<Enum<?>, String>
    {
        INSTANCE;


        public String convert(Enum<?> source) {
            return source.name();
        }
    }

    @WritingConverter
    static enum URLToStringConverter implements Converter<URL, String>
    {
        INSTANCE;


        public String convert(URL source) {
            return source.toString();
        }
    }

    @ReadingConverter
    static enum StringToURLConverter implements Converter<String, URL>
    {
        INSTANCE;

        private static final TypeDescriptor source;
        private static final TypeDescriptor target;

        public URL convert(String source) {
            try {
                return new URL(source);
            }
            catch (MalformedURLException e) {
                throw new ConversionFailedException(StringToURLConverter.source, target, (Object)source, (Throwable)e);
            }
        }

        static {
            source = TypeDescriptor.valueOf(String.class);
            target = TypeDescriptor.valueOf(URL.class);
        }
    }

    @WritingConverter
    static enum AtomicIntegerToIntegerConverter implements Converter<AtomicInteger, Integer>
    {
        INSTANCE;


        public Integer convert(AtomicInteger source) {
            return (Integer)NumberUtils.convertNumberToTargetClass((Number)source, Integer.class);
        }
    }

    @ReadingConverter
    static enum IntegerToAtomicIntegerConverter implements Converter<Integer, AtomicInteger>
    {
        INSTANCE;


        public AtomicInteger convert(Integer source) {
            return new AtomicInteger(source);
        }
    }

    @WritingConverter
    static enum AtomicLongToLongConverter implements Converter<AtomicLong, Long>
    {
        INSTANCE;


        public Long convert(AtomicLong source) {
            return (Long)NumberUtils.convertNumberToTargetClass((Number)source, Long.class);
        }
    }

    @ReadingConverter
    static enum LongToAtomicLongConverter implements Converter<Long, AtomicLong>
    {
        INSTANCE;


        public AtomicLong convert(Long source) {
            return new AtomicLong(source);
        }
    }

    @WritingConverter
    static enum CurrencyToStringConverter implements Converter<Currency, String>
    {
        INSTANCE;


        public String convert(Currency source) {
            return source.getCurrencyCode();
        }
    }

    @ReadingConverter
    static enum StringToCurrencyConverter implements Converter<String, Currency>
    {
        INSTANCE;


        public Currency convert(String source) {
            return StringUtils.hasText((String)source) ? Currency.getInstance(source) : null;
        }
    }

    @WritingConverter
    public static enum UuidToStringConverter implements Converter<UUID, String>
    {
        INSTANCE;


        public String convert(UUID source) {
            return source == null ? null : source.toString();
        }
    }

    @ReadingConverter
    public static enum StringToUuidConverter implements Converter<String, UUID>
    {
        INSTANCE;


        public UUID convert(String source) {
            return source == null ? null : UUID.fromString(source);
        }
    }
}

