/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.util.Map;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.mapping.Alias;
import org.springframework.util.StringUtils;

public class AerospikeTypeAliasAccessor
implements TypeAliasAccessor<Map<String, Object>> {
    private final String classKey;

    public AerospikeTypeAliasAccessor(String classKey) {
        this.classKey = StringUtils.hasText((String)classKey) ? classKey : null;
    }

    public Alias readAliasFrom(Map<String, Object> source) {
        if (this.classKey == null) {
            return Alias.NONE;
        }
        return Alias.ofNullable((Object)source.get(this.classKey));
    }

    public void writeTypeTo(Map<String, Object> sink, Object alias) {
        if (this.classKey != null) {
            sink.put(this.classKey, alias);
        }
    }
}

