/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.convert;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.core.convert.support.GenericConversionService;
import org.springframework.data.aerospike.config.AerospikeDataSettings;
import org.springframework.data.aerospike.convert.AerospikeConverter;
import org.springframework.data.aerospike.convert.AerospikeReadData;
import org.springframework.data.aerospike.convert.AerospikeTypeAliasAccessor;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeReadConverter;
import org.springframework.data.aerospike.convert.MappingAerospikeWriteConverter;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.DefaultTypeMapper;
import org.springframework.data.convert.SimpleTypeInformationMapper;
import org.springframework.data.convert.TypeAliasAccessor;
import org.springframework.data.convert.TypeMapper;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.model.EntityInstantiators;
import org.springframework.data.util.TypeInformation;

public class MappingAerospikeConverter
implements InitializingBean,
AerospikeConverter {
    private final CustomConversions conversions;
    private final GenericConversionService conversionService;
    private final AerospikeDataSettings aerospikeDataSettings;
    private final MappingAerospikeReadConverter readConverter;
    private final MappingAerospikeWriteConverter writeConverter;

    public MappingAerospikeConverter(AerospikeMappingContext mappingContext, CustomConversions conversions, AerospikeTypeAliasAccessor aerospikeTypeAliasAccessor, AerospikeDataSettings settings) {
        this.conversions = conversions;
        this.conversionService = new DefaultConversionService();
        this.aerospikeDataSettings = settings;
        EntityInstantiators entityInstantiators = new EntityInstantiators();
        DefaultTypeMapper typeMapper = new DefaultTypeMapper((TypeAliasAccessor)aerospikeTypeAliasAccessor, (MappingContext)mappingContext, List.of(new SimpleTypeInformationMapper()));
        this.writeConverter = new MappingAerospikeWriteConverter((TypeMapper<Map<String, Object>>)typeMapper, mappingContext, conversions, this.conversionService, settings);
        this.readConverter = new MappingAerospikeReadConverter(entityInstantiators, aerospikeTypeAliasAccessor, (TypeMapper<Map<String, Object>>)typeMapper, mappingContext, conversions, this.conversionService);
    }

    public void afterPropertiesSet() {
        this.conversions.registerConvertersIn((ConverterRegistry)this.conversionService);
    }

    public <R> R read(Class<R> type, AerospikeReadData data) {
        return this.readConverter.read(type, data);
    }

    public void write(Object source, AerospikeWriteData sink) {
        this.writeConverter.write(source, sink);
    }

    public Object toWritableValue(Object source, TypeInformation<?> type) {
        return this.writeConverter.getValueToWrite(source, type);
    }

    public CustomConversions getCustomConversions() {
        return this.conversions;
    }

    @Generated
    public GenericConversionService getConversionService() {
        return this.conversionService;
    }

    @Override
    @Generated
    public AerospikeDataSettings getAerospikeDataSettings() {
        return this.aerospikeDataSettings;
    }
}

