/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.core;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.BatchRecord;
import com.aerospike.client.BatchResults;
import com.aerospike.client.Bin;
import com.aerospike.client.Key;
import com.aerospike.client.Operation;
import com.aerospike.client.Record;
import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.cluster.Node;
import com.aerospike.client.policy.BatchPolicy;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.RecordExistsAction;
import com.aerospike.client.policy.WritePolicy;
import com.aerospike.client.query.IndexCollectionType;
import com.aerospike.client.query.IndexType;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.convert.AerospikeWriteData;
import org.springframework.data.aerospike.convert.MappingAerospikeConverter;
import org.springframework.data.aerospike.core.AerospikeExceptionTranslator;
import org.springframework.data.aerospike.core.BaseAerospikeTemplate;
import org.springframework.data.aerospike.core.CoreUtils;
import org.springframework.data.aerospike.core.EntitiesKeys;
import org.springframework.data.aerospike.core.ReactiveAerospikeOperations;
import org.springframework.data.aerospike.core.TemplateUtils;
import org.springframework.data.aerospike.core.WritePolicyBuilder;
import org.springframework.data.aerospike.core.model.GroupedEntities;
import org.springframework.data.aerospike.core.model.GroupedKeys;
import org.springframework.data.aerospike.index.IndexesCacheRefresher;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.AerospikePersistentEntity;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.ReactorQueryEngine;
import org.springframework.data.aerospike.query.cache.ReactorIndexRefresher;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.server.version.ServerVersionSupport;
import org.springframework.data.aerospike.util.InfoCommandUtils;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.data.domain.Sort;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactiveAerospikeTemplate
extends BaseAerospikeTemplate
implements ReactiveAerospikeOperations,
IndexesCacheRefresher<Mono<Integer>> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactiveAerospikeTemplate.class);
    private static final Pattern INDEX_EXISTS_REGEX_PATTERN = Pattern.compile("^FAIL:(-?\\d+).*$");
    private final IAerospikeReactorClient reactorClient;
    private final ReactorQueryEngine reactorQueryEngine;
    private final ReactorIndexRefresher reactorIndexRefresher;

    public ReactiveAerospikeTemplate(IAerospikeReactorClient reactorClient, String namespace, MappingAerospikeConverter converter, AerospikeMappingContext mappingContext, AerospikeExceptionTranslator exceptionTranslator, ReactorQueryEngine queryEngine, ReactorIndexRefresher reactorIndexRefresher, ServerVersionSupport serverVersionSupport) {
        super(namespace, converter, mappingContext, exceptionTranslator, reactorClient.getAerospikeClient().copyWritePolicyDefault(), serverVersionSupport);
        Assert.notNull((Object)reactorClient, (String)"Aerospike reactor client must not be null!");
        this.reactorClient = reactorClient;
        this.reactorQueryEngine = queryEngine;
        this.reactorIndexRefresher = reactorIndexRefresher;
    }

    @Override
    public Mono<Integer> refreshIndexesCache() {
        return this.reactorIndexRefresher.refreshIndexes();
    }

    @Override
    public <T> Mono<T> save(T document) {
        Assert.notNull(document, (String)"Document for saving must not be null!");
        return this.save(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> save(T document, String setName) {
        Assert.notNull(document, (String)"Document for saving must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = this.expectGenerationCasAwarePolicy(data);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, writePolicy, operations, BaseAerospikeTemplate.OperationType.SAVE_OPERATION);
        }
        WritePolicy writePolicy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return this.doPersistAndHandleError(document, data, writePolicy, operations);
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> documents) {
        TemplateUtils.validateForBatchWrite(documents, "Documents for saving");
        return this.saveAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> saveAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(documents, "Documents for saving");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.SAVE_OPERATION);
    }

    private <T> Flux<T> applyBufferedBatchWrite(Iterable<? extends T> documents, String setName, BaseAerospikeTemplate.OperationType operationType) {
        return Flux.defer(() -> {
            int batchSize = this.converter.getAerospikeDataSettings().getBatchWriteSize();
            return TemplateUtils.createNullTolerantBatches(documents, batchSize).concatMap(batch -> this.batchWriteAllDocuments((List)batch, setName, operationType));
        });
    }

    private <T> Flux<T> batchWriteAllDocuments(List<T> documents, String setName, BaseAerospikeTemplate.OperationType operationType) {
        return Flux.defer(() -> {
            try {
                List<BaseAerospikeTemplate.BatchWriteData> batchWriteDataList = documents.stream().map(document -> switch (operationType) {
                    default -> throw new IncompatibleClassChangeError();
                    case BaseAerospikeTemplate.OperationType.SAVE_OPERATION -> this.getBatchWriteForSave(document, setName);
                    case BaseAerospikeTemplate.OperationType.INSERT_OPERATION -> this.getBatchWriteForInsert(document, setName);
                    case BaseAerospikeTemplate.OperationType.UPDATE_OPERATION -> this.getBatchWriteForUpdate(document, setName);
                    case BaseAerospikeTemplate.OperationType.DELETE_OPERATION -> this.getBatchWriteForDelete(document, setName);
                }).toList();
                List<BatchRecord> batchWriteRecords = batchWriteDataList.stream().map(BaseAerospikeTemplate.BatchWriteData::batchRecord).toList();
                return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyBatchPolicyDefault()).flatMapMany(batchPolicyEnriched -> this.batchWriteAndCheckForErrors((BatchPolicy)batchPolicyEnriched, batchWriteRecords, batchWriteDataList, operationType));
            }
            catch (Exception e) {
                return Flux.error((Throwable)e);
            }
        });
    }

    private <T> Flux<T> batchWriteAndCheckForErrors(BatchPolicy batchPolicy, List<BatchRecord> batchWriteRecords, List<BaseAerospikeTemplate.BatchWriteData<T>> batchWriteDataList, BaseAerospikeTemplate.OperationType operationType) {
        return this.reactorClient.operate(batchPolicy, batchWriteRecords).onErrorMap(this::translateError).flatMap(ignore -> this.checkForErrorsAndUpdateVersion(batchWriteDataList, batchWriteRecords, operationType)).flux().flatMapIterable(list -> list.stream().map(BaseAerospikeTemplate.BatchWriteData::document).toList());
    }

    private <T> Mono<List<BaseAerospikeTemplate.BatchWriteData<T>>> checkForErrorsAndUpdateVersion(List<BaseAerospikeTemplate.BatchWriteData<T>> batchWriteDataList, List<BatchRecord> batchWriteRecords, BaseAerospikeTemplate.OperationType operationType) {
        boolean errorsFound = false;
        String casErrorDocumentId = null;
        for (BaseAerospikeTemplate.BatchWriteData<T> data : batchWriteDataList) {
            if (!errorsFound && TemplateUtils.batchRecordFailed(data.batchRecord(), false)) {
                errorsFound = true;
            }
            if (!data.hasVersionProperty()) continue;
            if (!TemplateUtils.batchRecordFailed(data.batchRecord(), false)) {
                if (operationType == BaseAerospikeTemplate.OperationType.DELETE_OPERATION) continue;
                this.updateVersion(data.document(), data.batchRecord().record);
                continue;
            }
            if (!this.hasOptimisticLockingError(data.batchRecord().resultCode)) continue;
            casErrorDocumentId = data.batchRecord().key.userKey.toString();
        }
        if (errorsFound) {
            if (casErrorDocumentId != null) {
                return Mono.error((Throwable)this.getOptimisticLockingFailureException("Failed to %s the record with ID '%s' due to versions mismatch".formatted(new Object[]{operationType, casErrorDocumentId}), null));
            }
            AerospikeException e = new AerospikeException("Errors during batch " + operationType);
            return Mono.error((Throwable)new AerospikeException.BatchRecordArray((BatchRecord[])batchWriteRecords.toArray(BatchRecord[]::new), (Throwable)e));
        }
        return Mono.just(batchWriteDataList);
    }

    @Override
    public <T> Mono<T> insert(T document) {
        return this.insert(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> insert(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        WritePolicy writePolicy = this.ignoreGenerationPolicy(data, RecordExistsAction.CREATE_ONLY);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleError(document, data, writePolicy, operations);
        }
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return this.doPersistAndHandleError(document, data, writePolicy, operations);
    }

    @Override
    public <T> Flux<T> insertAll(Iterable<? extends T> documents) {
        TemplateUtils.validateForBatchWrite(documents, "Documents for insert");
        return this.insertAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> insertAll(Iterable<? extends T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(documents, "Documents for insert");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.INSERT_OPERATION);
    }

    @Override
    public <T> Mono<T> persist(T document, WritePolicy writePolicy) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)writePolicy, (String)"Policy must not be null!");
        return this.persist(document, writePolicy, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> persist(T document, WritePolicy writePolicy, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)writePolicy, (String)"Policy must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)new WritePolicy(writePolicy)).flatMap(writePolicyEnriched -> this.doPersistAndHandleError(document, data, (WritePolicy)writePolicyEnriched, operations));
    }

    @Override
    public <T> Mono<T> update(T document) {
        return this.update(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<T> update(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = this.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}), Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, writePolicy, operations, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
        }
        WritePolicy writePolicy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, Operation.array((Operation[])new Operation[]{Operation.delete()}));
        return this.doPersistAndHandleError(document, data, writePolicy, operations);
    }

    @Override
    public <T> Mono<T> update(T document, Collection<String> fields) {
        return this.update(document, this.getSetName((Object)document), fields);
    }

    @Override
    public <T> Mono<T> update(T document, String setName, Collection<String> fields) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(fields, (String)"Fields must not be null!");
        AerospikeWriteData data = this.writeDataWithSpecificFields(document, setName, fields);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            WritePolicy writePolicy = this.expectGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
            Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put, null, Operation.array((Operation[])new Operation[]{Operation.getHeader()}));
            return this.doPersistWithVersionAndHandleCasError(document, data, writePolicy, operations, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
        }
        WritePolicy writePolicy = this.ignoreGenerationPolicy(data, RecordExistsAction.UPDATE_ONLY);
        Operation[] operations = CoreUtils.operations(data.getBinsAsArray(), Operation::put);
        return this.doPersistAndHandleError(document, data, writePolicy, operations);
    }

    @Override
    public <T> Flux<T> updateAll(Iterable<? extends T> documents) {
        TemplateUtils.validateForBatchWrite(documents, "Documents for update");
        return this.updateAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Flux<T> updateAll(Iterable<? extends T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(documents, "Documents for update");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.UPDATE_OPERATION);
    }

    @Override
    public <T> Mono<Boolean> delete(T document) {
        return this.delete(document, this.getSetName((Object)document));
    }

    @Override
    public <T> Mono<Boolean> delete(T document, String setName) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull(document, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(document.getClass());
        if (entity.hasVersionProperty()) {
            return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.expectGenerationPolicy(data)).flatMap(writePolicyEnriched -> this.reactorClient.delete((WritePolicy)writePolicyEnriched, data.getKey())).hasElement().onErrorMap(e -> this.translateCasThrowable((Throwable)e, BaseAerospikeTemplate.OperationType.DELETE_OPERATION.toString()));
        }
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.ignoreGenerationPolicy()).flatMap(writePolicyEnriched -> this.reactorClient.delete((WritePolicy)writePolicyEnriched, data.getKey())).hasElement().onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> delete(Query query, Class<T> entityClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Mono findQueryResults = this.find(query, entityClass, setName).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        return findQueryResults.flatMap(list -> {
            if (!list.isEmpty()) {
                return this.deleteAll((Iterable)list);
            }
            return Mono.empty();
        });
    }

    @Override
    public <T> Mono<Void> delete(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.delete(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<Void> deleteByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.deleteByIdsUsingQuery(ids, entityClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T> Mono<Void> deleteByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, String setName, @Nullable Query query) {
        Mono findQueryResults = this.findByIdsUsingQuery(ids, entityClass, entityClass, setName, query).filter(Objects::nonNull).collect(Collectors.toUnmodifiableList());
        return findQueryResults.flatMap(list -> {
            if (!list.isEmpty()) {
                return this.deleteAll((Iterable)list);
            }
            return Mono.empty();
        });
    }

    @Override
    public <T> Mono<Boolean> deleteById(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteById(id, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> deleteById(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.ignoreGenerationPolicy()).flatMap(writePolicyEnriched -> this.reactorClient.delete((WritePolicy)writePolicyEnriched, this.getKey(id, setName))).map(k -> true).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> deleteAll(Iterable<T> documents) {
        TemplateUtils.validateForBatchWrite(documents, "Documents for deleting");
        return this.deleteAll(documents, this.getSetName((Object)documents.iterator().next()));
    }

    @Override
    public <T> Mono<Void> deleteAll(Iterable<T> documents, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(documents, "Documents for deleting");
        return this.applyBufferedBatchWrite(documents, setName, BaseAerospikeTemplate.OperationType.DELETE_OPERATION).then();
    }

    @Override
    public <T> Mono<Void> deleteByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        TemplateUtils.validateForBatchWrite(ids, "IDs");
        return this.deleteByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<Void> deleteExistingByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        TemplateUtils.validateForBatchWrite(ids, "IDs");
        return this.deleteExistingByIds(ids, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Void> deleteByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(ids, "IDs");
        return this.deleteByIds(ids, setName, false);
    }

    @Override
    public Mono<Void> deleteExistingByIds(Iterable<?> ids, String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(ids, "IDs");
        return this.deleteByIds(ids, setName, true);
    }

    private Mono<Void> deleteByIds(Iterable<?> ids, String setName, boolean skipNonExisting) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(ids, "IDs");
        ArrayList idsList = new ArrayList();
        ArrayList<Mono<Void>> deleteResults = new ArrayList<Mono<Void>>();
        for (Object id : ids) {
            if (TemplateUtils.batchWriteSizeMatch(this.converter.getAerospikeDataSettings().getBatchWriteSize(), idsList.size())) {
                deleteResults.add(this.doDeleteByIds(new ArrayList(idsList), setName, skipNonExisting));
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            deleteResults.add(this.doDeleteByIds(new ArrayList(idsList), setName, skipNonExisting));
        }
        return Flux.concat((Publisher)Flux.fromIterable(deleteResults)).then();
    }

    private Mono<Void> doDeleteByIds(Collection<?> ids, String setName, boolean skipNonExisting) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        TemplateUtils.validateForBatchWrite(ids, "IDs");
        Key[] keys = (Key[])ids.stream().map(id -> this.getKey(id, setName)).toArray(Key[]::new);
        return this.batchDeleteAndCheckForErrors(this.reactorClient, keys, skipNonExisting);
    }

    private Mono<Void> batchDeleteAndCheckForErrors(IAerospikeReactorClient reactorClient, Key[] keys, boolean skipNonExisting) {
        Function<BatchResults, Mono> checkForErrors = results -> {
            if (results.records == null) {
                return Mono.error((Throwable)new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete")));
            }
            for (BatchRecord record : results.records) {
                if (!TemplateUtils.batchRecordFailed(record, skipNonExisting)) continue;
                return Mono.error((Throwable)new AerospikeException.BatchRecordArray(results.records, (Throwable)new AerospikeException("Errors during batch delete")));
            }
            return Mono.empty();
        };
        return TemplateUtils.enrichPolicyWithTransaction(reactorClient, (Policy)reactorClient.getAerospikeClient().copyBatchPolicyDefault()).flatMap(batchPolicy -> reactorClient.delete((BatchPolicy)batchPolicy, null, keys)).onErrorMap(this::translateError).flatMap(checkForErrors);
    }

    @Override
    public Mono<Void> deleteByIds(GroupedKeys groupedKeys) {
        TemplateUtils.validateGroupedKeys(groupedKeys);
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return Mono.empty();
        }
        return this.deleteEntitiesByGroupedKeys(groupedKeys);
    }

    private Mono<Void> deleteEntitiesByGroupedKeys(GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyBatchPolicyDefault()).flatMap(batchPolicy -> this.reactorClient.delete((BatchPolicy)batchPolicy, null, entitiesKeys.getKeys())).doOnError(this::translateError);
        return this.batchDeleteAndCheckForErrors(this.reactorClient, entitiesKeys.getKeys(), false);
    }

    @Override
    public <T> Mono<Void> deleteAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteAll(this.getSetName((Class)entityClass), null);
    }

    @Override
    public <T> Mono<Void> deleteAll(Class<T> entityClass, Instant beforeLastUpdate) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteAll(this.getSetName((Class)entityClass), beforeLastUpdate);
    }

    @Override
    public Mono<Void> deleteAll(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.deleteAll(setName, null);
    }

    @Override
    public Mono<Void> deleteAll(String setName, Instant beforeLastUpdate) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Calendar beforeLastUpdateCalendar = this.convertToCalendar(beforeLastUpdate);
        try {
            return Mono.fromRunnable(() -> this.reactorClient.getAerospikeClient().truncate(null, this.namespace, setName, beforeLastUpdateCalendar));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Mono<T> add(T document, Map<String, Long> values) {
        return this.add(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> add(T document, String setName, Map<String, Long> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = new Operation[values.size() + 1];
        int x = 0;
        for (Map.Entry<String, Long> entry : values.entrySet()) {
            operations[x] = new Operation(Operation.Type.ADD, entry.getKey(), Value.get((Object)entry.getValue()));
            ++x;
        }
        operations[x] = Operation.get();
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> this.executeOperationsOnValue(document, data, (WritePolicy)writePolicyEnriched, operations));
    }

    @Override
    public <T> Mono<T> add(T document, String binName, long value) {
        return this.add(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> add(T document, String setName, String binName, long value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        WritePolicy writePolicy = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(data.getExpiration()).build();
        Operation[] operations = new Operation[]{Operation.add((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> this.executeOperationsOnValue(document, data, (WritePolicy)writePolicyEnriched, operations));
    }

    @Override
    public <T> Mono<T> append(T document, Map<String, String> values) {
        return this.append(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> append(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = CoreUtils.operations(values, Operation.Type.APPEND, Operation.get());
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> this.executeOperationsOnValue(document, data, (WritePolicy)writePolicyEnriched, operations));
    }

    @Override
    public <T> Mono<T> append(T document, String binName, String value) {
        return this.append(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> append(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = new Operation[]{Operation.append((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> this.executeOperationsOnValue(document, data, (WritePolicy)writePolicyEnriched, operations));
    }

    @Override
    public <T> Mono<T> prepend(T document, Map<String, String> values) {
        return this.prepend(document, this.getSetName((Object)document), values);
    }

    @Override
    public <T> Mono<T> prepend(T document, String setName, Map<String, String> values) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull(values, (String)"Values must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = CoreUtils.operations(values, Operation.Type.PREPEND, Operation.get());
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> this.executeOperationsOnValue(document, data, (WritePolicy)writePolicyEnriched, operations));
    }

    @Override
    public <T> Mono<T> prepend(T document, String binName, String value) {
        return this.prepend(document, this.getSetName((Object)document), binName, value);
    }

    @Override
    public <T> Mono<T> prepend(T document, String setName, String binName, String value) {
        Assert.notNull(document, (String)"Document must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        AerospikeWriteData data = this.writeData(document, setName);
        Operation[] operations = new Operation[]{Operation.prepend((Bin)new Bin(binName, value)), Operation.get((String)binName)};
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyWritePolicyDefault()).flatMap(writePolicyEnriched -> this.executeOperationsOnValue(document, data, (WritePolicy)writePolicyEnriched, operations));
    }

    private <T> Mono<T> executeOperationsOnValue(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations) {
        return this.reactorClient.operate(writePolicy, data.getKey(), operations).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, this.getEntityClass(document), keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<T> execute(Supplier<T> supplier) {
        Assert.notNull(supplier, (String)"Supplier must not be null!");
        return Mono.fromSupplier(supplier).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findById(id, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Mono<T> findById(Object id, Class<T> entityClass, String setName) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, setName);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), null, null).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, this.reactorClient.getAerospikeClient().copyReadPolicyDefault()).flatMap(policy -> this.reactorClient.get(policy, key)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, entityClass, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Mono<S> findById(Object id, Class<T> entityClass, Class<S> targetClass) {
        return this.findById(id, entityClass, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Mono<S> findById(Object id, Class<T> entityClass, Class<S> targetClass, String setName) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, setName);
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), binNames, null).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, targetClass, keyRecord.record)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, this.reactorClient.getAerospikeClient().copyReadPolicyDefault()).flatMap(policy -> this.reactorClient.get(policy, key, binNames)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, targetClass, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIds(ids, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findByIds(Iterable<?> ids, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findByIds(ids, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findByIds(Iterable<?> ids, Class<T> targetClass, String setName) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull(targetClass, (String)"Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        ArrayList idsList = new ArrayList();
        Flux result = Flux.empty();
        for (Object id : ids) {
            if (TemplateUtils.batchWriteSizeMatch(this.converter.getAerospikeDataSettings().getBatchWriteSize(), idsList.size())) {
                result = Flux.concat((Publisher[])new Publisher[]{result, this.findByIds(idsList, targetClass, setName)});
                idsList.clear();
            }
            idsList.add(id);
        }
        if (!idsList.isEmpty()) {
            result = Flux.concat((Publisher[])new Publisher[]{result, this.findByIds(idsList, targetClass, setName)});
        }
        return result;
    }

    private <T> Flux<T> findByIds(Collection<?> ids, Class<T> targetClass, String setName) {
        Key[] keys = (Key[])Utils.iterableToList(ids).stream().map(id -> this.getKey(id, setName)).toArray(Key[]::new);
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)this.reactorClient.getAerospikeClient().copyBatchPolicyDefault()).flatMap(batchPolicy -> this.reactorClient.get((BatchPolicy)batchPolicy, keys)).flatMap(kr -> Mono.just((Object)kr.asMap())).flatMapMany(keyRecordMap -> {
            List entities = keyRecordMap.entrySet().stream().filter(entry -> entry.getValue() != null).map(entry -> this.mapToEntity((Key)entry.getKey(), targetClass, (Record)entry.getValue())).collect(Collectors.toList());
            return Flux.fromIterable(entities);
        });
    }

    @Override
    public Mono<GroupedEntities> findByIds(GroupedKeys groupedKeys) {
        TemplateUtils.validateGroupedKeys(groupedKeys);
        if (groupedKeys.getEntitiesKeys().isEmpty()) {
            return Mono.just((Object)GroupedEntities.builder().build());
        }
        return this.findGroupedEntitiesByGroupedKeys(this.reactorClient.getAerospikeClient().copyBatchPolicyDefault(), groupedKeys);
    }

    private Mono<GroupedEntities> findGroupedEntitiesByGroupedKeys(BatchPolicy batchPolicy, GroupedKeys groupedKeys) {
        EntitiesKeys entitiesKeys = EntitiesKeys.of(this.toEntitiesKeyMap(groupedKeys));
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)batchPolicy).flatMap(batchPolicyEnriched -> this.reactorClient.get((BatchPolicy)batchPolicyEnriched, entitiesKeys.getKeys())).map(item -> this.toGroupedEntities(entitiesKeys, item.records)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Mono<?> findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, Query query) {
        return this.findByIdUsingQuery(id, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Mono<?> findByIdUsingQuery(Object id, Class<T> entityClass, Class<S> targetClass, String setName, Query query) {
        AerospikePersistentEntity entity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(entityClass);
        Key key = this.getKey(id, setName);
        String[] binNames = this.getBinNamesFromTargetClass(targetClass);
        Class<Object> target = targetClass != null && targetClass != entityClass ? targetClass : entityClass;
        if (entity.isTouchOnRead()) {
            Assert.state((!entity.hasExpirationProperty() ? 1 : 0) != 0, (String)"Touch on read is not supported for entity without expiration property");
            return this.getAndTouch(key, entity.getExpiration(), binNames, query).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record)).onErrorResume(th -> {
                AerospikeException ae;
                return th instanceof AerospikeException && (ae = (AerospikeException)((Object)th)).getResultCode() == 2;
            }, th -> Mono.empty()).onErrorMap(this::translateError);
        }
        Policy policy = null;
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            policy = this.reactorClient.getAerospikeClient().copyReadPolicyDefault();
            Qualifier qualifier = query.getCriteriaObject();
            policy.filterExp = this.reactorQueryEngine.getFilterExpressionsBuilder().build(qualifier);
        }
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, policy).flatMap(rPolicy -> this.reactorClient.get(rPolicy, key, binNames)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record)).onErrorMap(this::translateError);
    }

    @Override
    public <T, S> Flux<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, @Nullable Query query) {
        return this.findByIdsUsingQuery(ids, entityClass, targetClass, this.getSetName((Class)entityClass), query);
    }

    @Override
    public <T, S> Flux<?> findByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, Class<S> targetClass, String setName, @Nullable Query query) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy batchPolicy = this.getBatchPolicyFilterExp(query);
        Class<Object> target = targetClass != null && targetClass != entityClass ? targetClass : entityClass;
        Flux results = Flux.fromIterable(ids).map(id -> this.getKey(id, setName)).flatMap(key -> this.getFromClient(batchPolicy, (Key)key, targetClass)).filter(keyRecord -> Objects.nonNull(keyRecord.record)).map(keyRecord -> this.mapToEntity(keyRecord.key, target, keyRecord.record));
        return this.applyPostProcessingOnResults(results, query);
    }

    private Flux<?> findByIdsUsingQueryWithoutMapping(Collection<?> ids, String setName, Query query) {
        Assert.notNull(ids, (String)"Ids must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy batchPolicy = this.getBatchPolicyFilterExp(query);
        return Flux.fromIterable(ids).map(id -> this.getKey(id, setName)).flatMap(key -> this.getFromClient(batchPolicy, (Key)key, null)).filter(keyRecord -> Objects.nonNull(keyRecord.record));
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.find(query, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> find(Query query, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.find(query, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> find(Query query, Class<T> targetClass, String setName) {
        Assert.notNull((Object)query, (String)"Query must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, query);
    }

    @Override
    public <T> Flux<T> findAll(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        return this.findAll(entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findAll(Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Entity class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findAll(Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.find(setName, targetClass);
    }

    @Override
    public <T> Flux<T> findAll(Sort sort, long offset, long limit, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findAll(sort, offset, limit, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findAll(Sort sort, long offset, long limit, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findAll(sort, offset, limit, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findAll(Sort sort, long offset, long limit, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, sort, offset, limit);
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.findInRange(offset, limit, sort, entityClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T, S> Flux<S> findInRange(long offset, long limit, Sort sort, Class<T> entityClass, Class<S> targetClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        Assert.notNull(targetClass, (String)"Target class must not be null!");
        return this.findInRange(offset, limit, sort, targetClass, this.getSetName((Class)entityClass));
    }

    @Override
    public <T> Flux<T> findInRange(long offset, long limit, Sort sort, Class<T> targetClass, String setName) {
        Assert.notNull(targetClass, (String)"Target Class must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findWithPostProcessing(setName, targetClass, sort, offset, limit);
    }

    private BatchPolicy getBatchPolicyFilterExp(Query query) {
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            BatchPolicy batchPolicy = this.reactorClient.getAerospikeClient().copyBatchPolicyDefault();
            Qualifier qualifier = query.getCriteriaObject();
            batchPolicy.filterExp = this.reactorQueryEngine.getFilterExpressionsBuilder().build(qualifier);
            return batchPolicy;
        }
        return null;
    }

    private Mono<KeyRecord> getFromClient(BatchPolicy batchPolicy, Key key, Class<?> targetClass) {
        if (targetClass != null) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)batchPolicy).flatMap(rPolicy -> this.reactorClient.get(rPolicy, key, binNames));
        }
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)batchPolicy).flatMap(rPolicy -> this.reactorClient.get(rPolicy, key));
    }

    @Override
    public <T> Mono<Boolean> exists(Object id, Class<T> entityClass) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(id, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> exists(Object id, String setName) {
        Assert.notNull((Object)id, (String)"Id must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Key key = this.getKey(id, setName);
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, this.reactorClient.getAerospikeClient().copyReadPolicyDefault()).flatMap(policy -> this.reactorClient.exists(policy, key)).map(Objects::nonNull).defaultIfEmpty((Object)false).onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Boolean> exists(Query query, Class<T> entityClass) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.exists(query, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Boolean> exists(Query query, String setName) {
        Assert.notNull((Object)query, (String)"Query passed in to exist can't be null");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        return this.findKeyRecordsUsingQuery(setName, query).hasElements();
    }

    @Override
    public <T> Mono<Boolean> existsByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.existsByIdsUsingQuery(ids, this.getSetName((Class)entityClass), query);
    }

    @Override
    public Mono<Boolean> existsByIdsUsingQuery(Collection<?> ids, String setName, @Nullable Query query) {
        return this.findByIdsUsingQueryWithoutMapping(ids, setName, query).filter(Objects::nonNull).hasElements();
    }

    @Override
    public <T> Mono<Long> count(Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        String setName = this.getSetName((Class)entityClass);
        return this.count(setName);
    }

    @Override
    public Mono<Long> count(String setName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        try {
            return Mono.fromCallable(() -> this.countSet(setName));
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
    }

    @Override
    public <T> Mono<Long> countByIdsUsingQuery(Collection<?> ids, Class<T> entityClass, @Nullable Query query) {
        return this.countByIdsUsingQuery(ids, this.getSetName((Class)entityClass), query);
    }

    @Override
    public Mono<Long> countByIdsUsingQuery(Collection<?> ids, String setName, @Nullable Query query) {
        return this.findByIdsUsingQueryWithoutMapping(ids, setName, query).filter(Objects::nonNull).count();
    }

    private long countSet(String setName) {
        Node[] nodes = this.reactorClient.getAerospikeClient().getNodes();
        int replicationFactor = Utils.getReplicationFactor(this.reactorClient.getAerospikeClient(), nodes, this.namespace);
        long totalObjects = Arrays.stream(nodes).mapToLong(node -> Utils.getObjectsCount(this.reactorClient.getAerospikeClient(), node, this.namespace, setName)).sum();
        return nodes.length > 1 ? totalObjects / (long)replicationFactor : totalObjects;
    }

    @Override
    public <T> Mono<Long> count(Query query, Class<T> entityClass) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.count(query, this.getSetName((Class)entityClass));
    }

    @Override
    public Mono<Long> count(Query query, String setName) {
        Assert.notNull((Object)setName, (String)"Set for count must not be null!");
        return this.findKeyRecordsUsingQuery(setName, query).count();
    }

    private Flux<KeyRecord> findKeyRecordsUsingQuery(String setName, Query query) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = QualifierUtils.getIdQualifier(qualifier)) != null) {
            return this.findByIdsWithoutMapping(TemplateUtils.getIdValue(idQualifier), setName, null, new Query(TemplateUtils.excludeIdQualifier(qualifier)));
        }
        return this.reactorQueryEngine.selectForCount(this.namespace, setName, query);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType) {
        return this.createIndex(entityClass, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.createIndex(entityClass, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public <T> Mono<Void> createIndex(Class<T> entityClass, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        return this.createIndex(this.getSetName((Class)entityClass), indexName, binName, indexType, indexCollectionType, ctx);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType) {
        return this.createIndex(setName, indexName, binName, indexType, IndexCollectionType.DEFAULT);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType) {
        return this.createIndex(setName, indexName, binName, indexType, indexCollectionType, new CTX[0]);
    }

    @Override
    public Mono<Void> createIndex(String setName, String indexName, String binName, IndexType indexType, IndexCollectionType indexCollectionType, CTX ... ctx) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        Assert.notNull((Object)binName, (String)"Bin name must not be null!");
        Assert.notNull((Object)indexType, (String)"Index type must not be null!");
        Assert.notNull((Object)indexCollectionType, (String)"Index collection type must not be null!");
        Assert.notNull((Object)ctx, (String)"Ctx must not be null!");
        return this.reactorClient.createIndex(null, this.namespace, setName, indexName, binName, indexType, indexCollectionType, ctx).then(this.refreshIndexesCache()).then().onErrorMap(this::translateError);
    }

    @Override
    public <T> Mono<Void> deleteIndex(Class<T> entityClass, String indexName) {
        Assert.notNull(entityClass, (String)"Class must not be null!");
        return this.deleteIndex(this.getSetName((Class)entityClass), indexName);
    }

    @Override
    public Mono<Void> deleteIndex(String setName, String indexName) {
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        return this.reactorClient.dropIndex(null, this.namespace, setName, indexName).then(this.refreshIndexesCache()).then().onErrorMap(this::translateError);
    }

    @Override
    public Mono<Boolean> indexExists(String indexName) {
        Assert.notNull((Object)indexName, (String)"Index name must not be null!");
        try {
            Node[] nodes;
            for (Node node : nodes = this.reactorClient.getAerospikeClient().getNodes()) {
                if (!node.isActive()) continue;
                String response = InfoCommandUtils.request(this.reactorClient.getAerospikeClient(), node, "sindex-exists:ns=" + this.namespace + ";indexname=" + indexName);
                if (response == null) {
                    throw new AerospikeException("Null node response");
                }
                if (response.equalsIgnoreCase("true")) {
                    return Mono.just((Object)true);
                }
                if (response.equalsIgnoreCase("false")) {
                    return Mono.just((Object)false);
                }
                Matcher matcher = INDEX_EXISTS_REGEX_PATTERN.matcher(response);
                if (matcher.matches()) {
                    int reason;
                    try {
                        reason = Integer.parseInt(matcher.group(1));
                    }
                    catch (NumberFormatException e) {
                        throw new AerospikeException("Unexpected node response, unable to parse ResultCode: " + response);
                    }
                    if (reason == 20) continue;
                    throw new AerospikeException(reason);
                }
                throw new AerospikeException("Unexpected node response: " + response);
            }
        }
        catch (AerospikeException e) {
            throw this.translateError(e);
        }
        return Mono.just((Object)false);
    }

    @Override
    public IAerospikeReactorClient getAerospikeReactorClient() {
        return this.reactorClient;
    }

    @Override
    public long getQueryMaxRecords() {
        return this.reactorQueryEngine.getQueryMaxRecords();
    }

    private <T> Mono<T> doPersistAndHandleError(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations) {
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> this.reactorClient.operate((WritePolicy)writePolicyEnriched, data.getKey(), operations)).map(docKey -> document).onErrorMap(this::translateError);
    }

    private <T> Mono<T> doPersistWithVersionAndHandleCasError(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations, BaseAerospikeTemplate.OperationType operationType) {
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> this.putAndGetHeader(data, (WritePolicy)writePolicyEnriched, operations)).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, i -> this.translateCasError((AerospikeException)((Object)i), "Failed to " + operationType.toString() + " record due to versions mismatch"));
    }

    private <T> Mono<T> doPersistWithVersionAndHandleError(T document, AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations) {
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> this.putAndGetHeader(data, (WritePolicy)writePolicyEnriched, operations)).map(newRecord -> this.updateVersion(document, (Record)newRecord)).onErrorMap(AerospikeException.class, this::translateError);
    }

    private Mono<Record> putAndGetHeader(AerospikeWriteData data, WritePolicy writePolicy, Operation[] operations) {
        return this.reactorClient.operate(writePolicy, data.getKey(), operations).map(keyRecord -> keyRecord.record);
    }

    private Mono<KeyRecord> getAndTouch(Key key, int expiration, String[] binNames, Query query) {
        WritePolicyBuilder writePolicyBuilder = WritePolicyBuilder.builder(this.writePolicyDefault).expiration(expiration);
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            Qualifier qualifier = query.getCriteriaObject();
            writePolicyBuilder.filterExp(this.reactorQueryEngine.getFilterExpressionsBuilder().build(qualifier));
        }
        WritePolicy writePolicy = writePolicyBuilder.build();
        if (binNames == null || binNames.length == 0) {
            return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> this.reactorClient.operate((WritePolicy)writePolicyEnriched, key, new Operation[]{Operation.touch(), Operation.get()}));
        }
        Operation[] operations = new Operation[binNames.length + 1];
        operations[0] = Operation.touch();
        for (int i = 1; i < operations.length; ++i) {
            operations[i] = Operation.get((String)binNames[i - 1]);
        }
        return TemplateUtils.enrichPolicyWithTransaction(this.reactorClient, (Policy)writePolicy).flatMap(writePolicyEnriched -> this.reactorClient.operate((WritePolicy)writePolicyEnriched, key, operations));
    }

    private String[] getBinNamesFromTargetClass(Class<?> targetClass) {
        AerospikePersistentEntity targetEntity = (AerospikePersistentEntity)this.mappingContext.getRequiredPersistentEntity(targetClass);
        ArrayList binNamesList = new ArrayList();
        targetEntity.doWithProperties(property -> {
            if (!property.isIdProperty()) {
                binNamesList.add(property.getFieldName());
            }
        });
        return binNamesList.toArray(new String[0]);
    }

    private Throwable translateError(Throwable e) {
        if (e instanceof AerospikeException) {
            AerospikeException ae = (AerospikeException)e;
            return this.translateError(ae);
        }
        return e;
    }

    private Throwable translateCasThrowable(Throwable e, String operationName) {
        if (e instanceof AerospikeException) {
            AerospikeException ae = (AerospikeException)e;
            return this.translateCasError(ae, "Failed to %s record due to versions mismatch".formatted(operationName));
        }
        return e;
    }

    private <T> Flux<T> findWithPostProcessing(String setName, Class<T> targetClass, Query query) {
        this.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        Flux<T> results = this.findUsingQueryWithDistinctPredicate(setName, targetClass, CoreUtils.getDistinctPredicate(query), query);
        results = this.applyPostProcessingOnResults(results, query);
        return results;
    }

    private <T> Flux<T> findWithPostProcessing(String setName, Class<T> targetClass, Sort sort, long offset, long limit) {
        this.verifyUnsortedWithOffset(sort, offset);
        Flux<T> results = this.find(setName, targetClass);
        results = this.applyPostProcessingOnResults(results, sort, offset, limit);
        return results;
    }

    @Override
    public <T, S> Flux<S> findUsingQueryWithoutPostProcessing(Class<T> entityClass, Class<S> targetClass, Query query) {
        this.verifyUnsortedWithOffset(query.getSort(), query.getOffset());
        return this.findUsingQueryWithDistinctPredicate(this.getSetName((Class)entityClass), targetClass, CoreUtils.getDistinctPredicate(query), query);
    }

    private void verifyUnsortedWithOffset(Sort sort, long offset) {
        if ((sort == null || sort.isUnsorted()) && offset > 0L) {
            throw new IllegalArgumentException("Unsorted query must not have offset value. For retrieving paged results use sorted query.");
        }
    }

    private <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, Query query) {
        if (query.getSort() != null && query.getSort().isSorted()) {
            Comparator comparator = this.getComparator(query);
            results = results.sort(comparator);
        }
        if (query.hasOffset()) {
            results = results.skip(query.getOffset());
        }
        if (query.hasRows()) {
            results = results.take((long)query.getRows());
        }
        return results;
    }

    private <T> Flux<T> applyPostProcessingOnResults(Flux<T> results, Sort sort, long offset, long limit) {
        if (sort != null && sort.isSorted()) {
            Comparator comparator = this.getComparator(sort);
            results = results.sort(comparator);
        }
        if (offset > 0L) {
            results = results.skip(offset);
        }
        if (limit > 0L) {
            results = results.take(limit);
        }
        return results;
    }

    private <T> Flux<T> find(String setName, Class<T> targetClass) {
        return this.findRecordsUsingQuery(setName, targetClass, null).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, targetClass));
    }

    private <T> Flux<T> findUsingQueryWithDistinctPredicate(String setName, Class<T> targetClass, Predicate<KeyRecord> distinctPredicate, Query query) {
        return this.findRecordsUsingQuery(setName, targetClass, query).filter(distinctPredicate).map(keyRecord -> this.mapToEntity((KeyRecord)keyRecord, targetClass));
    }

    private <T> Flux<KeyRecord> findRecordsUsingQuery(String setName, Class<T> targetClass, Query query) {
        Qualifier idQualifier;
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (qualifier != null && (idQualifier = QualifierUtils.getIdQualifier(qualifier)) != null) {
            return this.findByIdsWithoutMapping(TemplateUtils.getIdValue(idQualifier), setName, targetClass, new Query(TemplateUtils.excludeIdQualifier(qualifier)));
        }
        if (targetClass != null) {
            String[] binNames = this.getBinNamesFromTargetClass(targetClass);
            return this.reactorQueryEngine.select(this.namespace, setName, binNames, query);
        }
        return this.reactorQueryEngine.select(this.namespace, setName, null, query);
    }

    private <T> Flux<KeyRecord> findByIdsWithoutMapping(Collection<?> ids, String setName, Class<T> targetClass, Query query) {
        Assert.notNull(ids, (String)"List of ids must not be null!");
        Assert.notNull((Object)setName, (String)"Set name must not be null!");
        if (ids.isEmpty()) {
            return Flux.empty();
        }
        BatchPolicy batchPolicy = this.getBatchPolicyFilterExp(query);
        return Flux.fromIterable(ids).map(id -> this.getKey(id, setName)).flatMap(key -> this.getFromClient(batchPolicy, (Key)key, targetClass)).filter(keyRecord -> Objects.nonNull(keyRecord.record));
    }
}

