/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import com.aerospike.client.Value;
import com.aerospike.client.cdt.CTX;
import com.aerospike.client.exp.Exp;
import java.util.List;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;

public class AerospikeContextDslResolverUtils {
    public static CTX toCtx(String singleCtx) {
        switch (singleCtx.charAt(0)) {
            case '{': {
                return AerospikeContextDslResolverUtils.processSingleCtx(singleCtx, AerospikeIndexResolver.CtxType.MAP);
            }
            case '[': {
                return AerospikeContextDslResolverUtils.processSingleCtx(singleCtx, AerospikeIndexResolver.CtxType.LIST);
            }
        }
        Object res = AerospikeContextDslResolverUtils.isInDoubleOrSingleQuotes(singleCtx) ? singleCtx.substring(1, singleCtx.length() - 1) : AerospikeContextDslResolverUtils.parseIntOrReturnStr(singleCtx);
        return CTX.mapKey((Value)Value.get((Object)res));
    }

    private static CTX processSingleCtx(String singleCtx, AerospikeIndexResolver.CtxType ctxType) {
        int length = singleCtx.length();
        if (length < 3) {
            throw new IllegalArgumentException(String.format("Context DSL: string '%s' has no content", singleCtx));
        }
        if (singleCtx.charAt(length - 1) != ctxType.closingChar) {
            throw new IllegalArgumentException(String.format("Context DSL: brackets mismatch, expecting '%s', got '%s' instead", Character.valueOf(ctxType.closingChar), Character.valueOf(singleCtx.charAt(length - 1))));
        }
        String substring = singleCtx.substring(2, length - 1);
        CTX result = singleCtx.charAt(1) == '=' && length > 3 ? AerospikeContextDslResolverUtils.processCtxValue(substring, ctxType) : (singleCtx.charAt(1) == '#' && length > 3 ? AerospikeContextDslResolverUtils.processCtxRank(substring, ctxType) : AerospikeContextDslResolverUtils.processCtxIndex(singleCtx, length, ctxType));
        return result;
    }

    private static CTX processCtxValue(String substring, AerospikeIndexResolver.CtxType ctxType) {
        Object result = AerospikeContextDslResolverUtils.isInDoubleOrSingleQuotes(substring) ? substring.substring(1, substring.length() - 1) : AerospikeContextDslResolverUtils.parseIntOrReturnStr(substring);
        return switch (ctxType) {
            default -> throw new IncompatibleClassChangeError();
            case AerospikeIndexResolver.CtxType.MAP -> CTX.mapValue((Value)Value.get((Object)result));
            case AerospikeIndexResolver.CtxType.LIST -> CTX.listValue((Value)Value.get((Object)result));
        };
    }

    private static CTX processCtxRank(String substring, AerospikeIndexResolver.CtxType ctxType) {
        int rank = AerospikeContextDslResolverUtils.parseIntOrFail(substring, ctxType, "rank");
        return switch (ctxType) {
            default -> throw new IncompatibleClassChangeError();
            case AerospikeIndexResolver.CtxType.MAP -> CTX.mapRank((int)rank);
            case AerospikeIndexResolver.CtxType.LIST -> CTX.listRank((int)rank);
        };
    }

    private static CTX processCtxIndex(String singleCtx, int length, AerospikeIndexResolver.CtxType ctxType) {
        String substring = singleCtx.substring(1, length - 1);
        int idx = AerospikeContextDslResolverUtils.parseIntOrFail(substring, ctxType, "index");
        return switch (ctxType) {
            default -> throw new IncompatibleClassChangeError();
            case AerospikeIndexResolver.CtxType.MAP -> CTX.mapIndex((int)idx);
            case AerospikeIndexResolver.CtxType.LIST -> CTX.listIndex((int)idx);
        };
    }

    private static int parseIntOrFail(String substring, AerospikeIndexResolver.CtxType ctxType, String parameterName) {
        try {
            return Integer.parseInt(substring);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Context DSL %s %s: expecting only integer values, got '%s' instead", new Object[]{ctxType, parameterName, substring}));
        }
    }

    private static Object parseIntOrReturnStr(String str) {
        Object res;
        try {
            res = Integer.parseInt(str);
        }
        catch (NumberFormatException e) {
            res = str;
        }
        return res;
    }

    private static boolean isInDoubleOrSingleQuotes(String str) {
        return !(str.length() <= 2 || str.charAt(0) != '\"' && str.charAt(0) != '\'' || str.charAt(str.length() - 1) != '\"' && str.charAt(str.length() - 1) != '\'');
    }

    public static boolean isCtxMapKey(CTX ctx) {
        return ctx.id == CtxType.MAP_KEY.getId();
    }

    public static boolean isCtxMapValue(CTX ctx) {
        return ctx.id == CtxType.MAP_VALUE.getId();
    }

    public static Exp.Type getCtxType(CTX ctx) {
        List<Integer> listIds = List.of(Integer.valueOf(CtxType.LIST_INDEX.getId()), Integer.valueOf(CtxType.LIST_RANK.getId()), Integer.valueOf(CtxType.LIST_VALUE.getId()));
        List<Integer> mapIds = List.of(Integer.valueOf(CtxType.MAP_INDEX.getId()), Integer.valueOf(CtxType.MAP_RANK.getId()), Integer.valueOf(CtxType.MAP_KEY.getId()), Integer.valueOf(CtxType.MAP_VALUE.getId()));
        if (listIds.contains(ctx.id)) {
            return Exp.Type.LIST;
        }
        if (mapIds.contains(ctx.id)) {
            return Exp.Type.MAP;
        }
        throw new IllegalStateException("Unexpected CTX element id");
    }

    static enum CtxType {
        LIST_INDEX(16),
        LIST_RANK(17),
        LIST_VALUE(19),
        MAP_INDEX(32),
        MAP_RANK(33),
        MAP_KEY(34),
        MAP_VALUE(35);

        private final int id;

        private CtxType(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }
    }
}

