/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import com.aerospike.client.cdt.CTX;
import java.util.Arrays;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.data.aerospike.annotation.Indexed;
import org.springframework.data.aerospike.index.AerospikeContextDslResolverUtils;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.mapping.AerospikePersistentProperty;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class AerospikeIndexResolver
implements EnvironmentAware {
    private Environment environment;

    public Set<AerospikeIndexDefinition> detectIndexes(BasicAerospikePersistentEntity<?> persistentEntity) {
        return StreamSupport.stream(persistentEntity.spliterator(), false).filter(property -> property.isAnnotationPresent(Indexed.class)).map(property -> this.convertToIndex(persistentEntity, (AerospikePersistentProperty)property)).collect(Collectors.toSet());
    }

    private AerospikeIndexDefinition convertToIndex(BasicAerospikePersistentEntity<?> persistentEntity, AerospikePersistentProperty property) {
        String indexName;
        Indexed annotation = (Indexed)property.getRequiredAnnotation(Indexed.class);
        if (StringUtils.hasText((String)annotation.name())) {
            Assert.notNull((Object)this.environment, (String)"Environment must be set to use 'indexed'");
            indexName = this.environment.resolveRequiredPlaceholders(annotation.name());
        } else {
            indexName = this.getIndexName(persistentEntity, property, annotation);
        }
        String binName = StringUtils.hasText((String)annotation.bin()) ? annotation.bin() : property.getFieldName();
        return AerospikeIndexDefinition.builder().entityClass(persistentEntity.getType()).bin(binName).name(indexName).type(annotation.type()).collectionType(annotation.collectionType()).ctx(this.toCtxArray(annotation.ctx())).build();
    }

    private String getIndexName(BasicAerospikePersistentEntity<?> entity, AerospikePersistentProperty property, Indexed annotation) {
        return String.join((CharSequence)"_", entity.getSetName(), property.getFieldName(), annotation.type().name().toLowerCase(), annotation.collectionType().name().toLowerCase());
    }

    public void setEnvironment(Environment environment) {
        this.environment = environment;
    }

    private CTX[] toCtxArray(String ctxString) {
        CTX[] ctxArr;
        if (!StringUtils.hasLength((String)ctxString)) {
            return null;
        }
        String[] ctxTokens = ctxString.split("\\.");
        if (ctxTokens.length != (ctxArr = (CTX[])Arrays.stream(ctxTokens).filter(Predicate.not(String::isEmpty)).map(AerospikeContextDslResolverUtils::toCtx).filter(Objects::nonNull).toArray(CTX[]::new)).length) {
            throw new IllegalArgumentException("@Indexed annotation '" + ctxString + "' contains empty context");
        }
        return ctxArr;
    }

    protected static enum CtxType {
        MAP('}'),
        LIST(']');

        final char closingChar;

        private CtxType(char closingChar) {
            this.closingChar = closingChar;
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

