/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.index;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.context.ApplicationListener;
import org.springframework.context.SmartLifecycle;
import org.springframework.data.aerospike.index.AerospikeIndexDefinition;
import org.springframework.data.aerospike.index.AerospikeIndexResolver;
import org.springframework.data.aerospike.mapping.AerospikeMappingContext;
import org.springframework.data.aerospike.mapping.BasicAerospikePersistentEntity;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.context.MappingContext;
import org.springframework.data.mapping.context.MappingContextEvent;

public abstract class BaseAerospikePersistenceEntityIndexCreator
implements ApplicationListener<MappingContextEvent<?, ?>>,
SmartLifecycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BaseAerospikePersistenceEntityIndexCreator.class);
    private final ObjectProvider<AerospikeMappingContext> mappingContext;
    private final boolean createIndexesOnStartup;
    private final AerospikeIndexResolver aerospikeIndexResolver;
    private final Set<IndexesEvent> initialIndexes = new HashSet<IndexesEvent>();
    private final AtomicBoolean initialized = new AtomicBoolean(false);

    public void onApplicationEvent(MappingContextEvent<?, ?> event) {
        if (!this.createIndexesOnStartup) {
            return;
        }
        Object source = event.getSource();
        if (!(source instanceof AerospikeMappingContext)) {
            return;
        }
        PersistentEntity entity = event.getPersistentEntity();
        if (!(entity instanceof BasicAerospikePersistentEntity)) {
            return;
        }
        BasicAerospikePersistentEntity persistentEntity = (BasicAerospikePersistentEntity)entity;
        Set<AerospikeIndexDefinition> indexes = this.aerospikeIndexResolver.detectIndexes(persistentEntity);
        if (!indexes.isEmpty()) {
            if (!this.initialized.get()) {
                this.initialIndexes.add(new IndexesEvent(indexes, event));
                return;
            }
            log.debug("Creating {} indexes for entity[{}]...", indexes, (Object)entity.getName());
            this.installIndexes(indexes);
        }
    }

    public void start() {
        this.initialized.set(true);
        this.initialIndexes.forEach(event -> {
            AerospikeMappingContext mappingContext = this.getMappingContext();
            if (event.getEvent().wasEmittedBy((MappingContext)mappingContext)) {
                this.installIndexes(event.getIndexes());
            }
        });
        this.initialIndexes.clear();
    }

    private AerospikeMappingContext getMappingContext() {
        AerospikeMappingContext mappingContext = (AerospikeMappingContext)((Object)this.mappingContext.getIfUnique());
        if (mappingContext == null) {
            throw new IllegalStateException("AerospikeMappingContext bean is not available in context OR is not unique");
        }
        return mappingContext;
    }

    protected abstract void installIndexes(Set<AerospikeIndexDefinition> var1);

    public void stop() {
    }

    public boolean isRunning() {
        return this.initialized.get();
    }

    @Generated
    public BaseAerospikePersistenceEntityIndexCreator(ObjectProvider<AerospikeMappingContext> mappingContext, boolean createIndexesOnStartup, AerospikeIndexResolver aerospikeIndexResolver) {
        this.mappingContext = mappingContext;
        this.createIndexesOnStartup = createIndexesOnStartup;
        this.aerospikeIndexResolver = aerospikeIndexResolver;
    }

    private static final class IndexesEvent {
        private final Set<AerospikeIndexDefinition> indexes;
        private final MappingContextEvent<?, ?> event;

        @Generated
        public IndexesEvent(Set<AerospikeIndexDefinition> indexes, MappingContextEvent<?, ?> event) {
            this.indexes = indexes;
            this.event = event;
        }

        @Generated
        public Set<AerospikeIndexDefinition> getIndexes() {
            return this.indexes;
        }

        @Generated
        public MappingContextEvent<?, ?> getEvent() {
            return this.event;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof IndexesEvent)) {
                return false;
            }
            IndexesEvent other = (IndexesEvent)o;
            Set<AerospikeIndexDefinition> this$indexes = this.getIndexes();
            Set<AerospikeIndexDefinition> other$indexes = other.getIndexes();
            if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
                return false;
            }
            MappingContextEvent<?, ?> this$event = this.getEvent();
            MappingContextEvent<?, ?> other$event = other.getEvent();
            return !(this$event == null ? other$event != null : !this$event.equals(other$event));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Set<AerospikeIndexDefinition> $indexes = this.getIndexes();
            result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
            MappingContextEvent<?, ?> $event = this.getEvent();
            result = result * 59 + ($event == null ? 43 : $event.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "BaseAerospikePersistenceEntityIndexCreator.IndexesEvent(indexes=" + this.getIndexes() + ", event=" + this.getEvent() + ")";
        }
    }
}

