/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.AerospikeException;
import com.aerospike.client.Key;
import com.aerospike.client.policy.Policy;
import com.aerospike.client.policy.QueryPolicy;
import com.aerospike.client.query.KeyRecord;
import com.aerospike.client.query.Statement;
import com.aerospike.client.reactor.IAerospikeReactorClient;
import lombok.Generated;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.config.AerospikeDataSettings;
import org.springframework.data.aerospike.query.FilterExpressionsBuilder;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.QueryEngine;
import org.springframework.data.aerospike.query.StatementBuilder;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.lang.Nullable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class ReactorQueryEngine {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReactorQueryEngine.class);
    private final IAerospikeReactorClient client;
    private final StatementBuilder statementBuilder;
    private final FilterExpressionsBuilder filterExpressionsBuilder;
    private final AerospikeDataSettings dataSettings;
    private boolean scansEnabled;
    private long queryMaxRecords;

    public ReactorQueryEngine(IAerospikeReactorClient client, StatementBuilder statementBuilder, FilterExpressionsBuilder filterExpressionsBuilder, AerospikeDataSettings dataSettings) {
        this.client = client;
        this.statementBuilder = statementBuilder;
        this.filterExpressionsBuilder = filterExpressionsBuilder;
        this.dataSettings = dataSettings;
    }

    public Flux<KeyRecord> select(String namespace, String set, @Nullable Query query) {
        return this.select(namespace, set, null, query);
    }

    public Flux<KeyRecord> select(String namespace, String set, String[] binNames, @Nullable Query query) {
        Qualifier qualifier;
        Qualifier qualifier2 = qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        if (query != null) {
            query.getCriteriaObject().setDataSettings(this.dataSettings);
        }
        Statement statement = this.statementBuilder.build(namespace, set, query, binNames);
        statement.setMaxRecords(this.queryMaxRecords);
        QueryPolicy localQueryPolicy = this.getQueryPolicy(qualifier, true);
        if (!this.scansEnabled && statement.getFilter() == null) {
            return Flux.error((Throwable)new IllegalStateException("Query without a secondary index filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scans-enabled` property."));
        }
        return this.client.query(localQueryPolicy, statement).onErrorResume(throwable -> {
            if (throwable instanceof AerospikeException) {
                AerospikeException ae = (AerospikeException)((Object)throwable);
                if (statement.getFilter() != null && QueryEngine.SEC_INDEX_ERROR_RESULT_CODES.contains(ae.getResultCode())) {
                    log.warn("Got secondary index related exception (resultCode: {}), retrying with filter expression only (scan operation)", (Object)ae.getResultCode());
                    return this.retryWithFilterExpression(qualifier, statement);
                }
            }
            return Mono.error((Throwable)throwable);
        });
    }

    private Publisher<? extends KeyRecord> retryWithFilterExpression(Qualifier qualifier, Statement statement) {
        qualifier.setHasSecIndexFilter(false);
        QueryPolicy localQueryPolicyFallback = this.getQueryPolicy(qualifier, true);
        statement.setFilter(null);
        return this.client.query(localQueryPolicyFallback, statement);
    }

    public Flux<KeyRecord> selectForCount(String namespace, String set, @Nullable Query query) {
        Statement statement = this.statementBuilder.build(namespace, set, query);
        statement.setMaxRecords(this.queryMaxRecords);
        Qualifier qualifier = QualifierUtils.queryCriteriaIsNotNull(query) ? query.getCriteriaObject() : null;
        QueryPolicy localQueryPolicy = this.getQueryPolicy(qualifier, false);
        if (!this.scansEnabled && statement.getFilter() == null) {
            return Flux.error((Throwable)new IllegalStateException("Query without a secondary index filter will initiate a scan. Since scans are potentially dangerous operations, they are disabled by default in spring-data-aerospike. If you still need to use them, enable them via `scans-enabled` property."));
        }
        return this.client.query(localQueryPolicy, statement);
    }

    private QueryPolicy getQueryPolicy(Qualifier qualifier, boolean includeBins) {
        QueryPolicy queryPolicy = new QueryPolicy(this.client.getQueryPolicyDefault());
        queryPolicy.filterExp = this.filterExpressionsBuilder.build(qualifier);
        queryPolicy.includeBinData = includeBins;
        return queryPolicy;
    }

    private Mono<KeyRecord> getRecord(Policy policy, Key key, String[] binNames) {
        if (binNames == null || binNames.length == 0) {
            return this.client.get(policy, key);
        }
        return this.client.get(policy, key, binNames);
    }

    @Generated
    public StatementBuilder getStatementBuilder() {
        return this.statementBuilder;
    }

    @Generated
    public FilterExpressionsBuilder getFilterExpressionsBuilder() {
        return this.filterExpressionsBuilder;
    }

    @Generated
    public void setScansEnabled(boolean scansEnabled) {
        this.scansEnabled = scansEnabled;
    }

    @Generated
    public void setQueryMaxRecords(long queryMaxRecords) {
        this.queryMaxRecords = queryMaxRecords;
    }

    @Generated
    public long getQueryMaxRecords() {
        return this.queryMaxRecords;
    }
}

