/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.aerospike.query;

import com.aerospike.client.query.Filter;
import com.aerospike.client.query.Statement;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.aerospike.query.FilterOperation;
import org.springframework.data.aerospike.query.QualifierUtils;
import org.springframework.data.aerospike.query.cache.IndexesCache;
import org.springframework.data.aerospike.query.model.Index;
import org.springframework.data.aerospike.query.model.IndexedField;
import org.springframework.data.aerospike.query.qualifier.Qualifier;
import org.springframework.data.aerospike.repository.query.Query;
import org.springframework.data.aerospike.util.Utils;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

public class StatementBuilder {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StatementBuilder.class);
    private final IndexesCache indexesCache;

    public StatementBuilder(IndexesCache indexesCache) {
        this.indexesCache = indexesCache;
    }

    public Statement build(String namespace, String set, Query query) {
        return this.build(namespace, set, query, null);
    }

    public Statement build(String namespace, String set, @Nullable Query query, String[] binNames) {
        Statement stmt = new Statement();
        stmt.setNamespace(namespace);
        stmt.setSetName(set);
        if (binNames != null && binNames.length != 0) {
            stmt.setBinNames(binNames);
        }
        if (QualifierUtils.queryCriteriaIsNotNull(query)) {
            Utils.logQualifierDetails(query.getCriteriaObject(), log);
            this.setStatementFilterFromQualifiers(stmt, query.getCriteriaObject());
        }
        return stmt;
    }

    private void setStatementFilterFromQualifiers(Statement stmt, Qualifier qualifier) {
        if (qualifier == null) {
            log.debug("Query #{}, secondary index filter is not set", (Object)qualifier.hashCode());
            return;
        }
        if (qualifier.getOperation() == FilterOperation.AND) {
            this.setFilterFromMultipleQualifiers(stmt, qualifier);
        } else if (this.isIndexedBin(stmt, qualifier)) {
            this.setFilterFromSingleQualifier(stmt, qualifier);
        }
        if (stmt.getFilter() != null) {
            log.debug("Query #{}, secondary index filter is set on the bin '{}'", (Object)qualifier.hashCode(), (Object)stmt.getFilter().getName());
        } else {
            log.debug("Query #{}, secondary index filter is not set", (Object)qualifier.hashCode());
        }
    }

    private void setFilterFromMultipleQualifiers(Statement stmt, Qualifier qualifier) {
        int minBinValuesRatio = Integer.MAX_VALUE;
        Qualifier minBinValuesRatioQualifier = null;
        for (Qualifier innerQualifier : qualifier.getQualifiers()) {
            int currBinValuesRatio;
            if (innerQualifier == null || !this.isIndexedBin(stmt, innerQualifier) || (currBinValuesRatio = this.getMinBinValuesRatioForQualifier(stmt, innerQualifier)) == 0 || currBinValuesRatio >= minBinValuesRatio) continue;
            minBinValuesRatio = currBinValuesRatio;
            minBinValuesRatioQualifier = innerQualifier;
        }
        if (minBinValuesRatioQualifier != null) {
            this.setFilterFromSingleQualifier(stmt, minBinValuesRatioQualifier);
        } else {
            for (Qualifier innerQualifier : qualifier.getQualifiers()) {
                Filter filter;
                if (innerQualifier == null || !this.isIndexedBin(stmt, innerQualifier) || (filter = innerQualifier.getSecondaryIndexFilter()) == null) continue;
                stmt.setFilter(filter);
                innerQualifier.setHasSecIndexFilter(true);
                break;
            }
        }
    }

    private void setFilterFromSingleQualifier(Statement stmt, Qualifier qualifier) {
        Filter filter = qualifier.getSecondaryIndexFilter();
        if (filter != null) {
            stmt.setFilter(filter);
            qualifier.setHasSecIndexFilter(true);
        }
    }

    private boolean isIndexedBin(Statement stmt, Qualifier qualifier) {
        boolean hasIndexesForField = false;
        boolean hasField = false;
        if (StringUtils.hasLength((String)qualifier.getBinName())) {
            hasField = true;
            hasIndexesForField = this.indexesCache.hasIndexFor(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getBinName()));
        }
        if (log.isDebugEnabled() && hasField) {
            log.debug("Qualifier #{}, bin {}.{}.{} has secondary index(es): {}", new Object[]{qualifier.hashCode(), stmt.getNamespace(), stmt.getSetName(), qualifier.getBinName(), hasIndexesForField});
        }
        return hasIndexesForField;
    }

    private int getMinBinValuesRatioForQualifier(Statement stmt, Qualifier qualifier) {
        List<Index> indexList = this.indexesCache.getAllIndexesForField(new IndexedField(stmt.getNamespace(), stmt.getSetName(), qualifier.getBinName()));
        Optional<Index> minBinValuesRatio = indexList.stream().filter(index -> index.getBinValuesRatio() != 0).min(Comparator.comparing(Index::getBinValuesRatio));
        return minBinValuesRatio.map(Index::getBinValuesRatio).orElse(0);
    }
}

